/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.google.common.collect.Lists;
import com.pixelextras.config.PixelExtrasConfig;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.enums.ReceiveType;
import com.pixelmonmod.pixelmon.api.events.PixelmonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.PixelmonPlayerUtils;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PokeRandom
extends CommandBase {
    public String func_71517_b() {
        return "pokerandom";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("prandom");
    }

    public String func_71518_a(ICommandSender sender) {
        return "/pokerandom <player> [options]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if ((args.length < 1 || PixelmonPlayerUtils.getUniquePlayerStartingWith((String)args[0]) == null) && sender instanceof EntityPlayerMP) {
            this.func_184881_a(server, sender, new String[]{sender.func_70005_c_()});
            return;
        }
        EntityPlayerMP player = args.length < 1 ? PokeRandom.func_71521_c((ICommandSender)sender) : PokeRandom.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
        if (storage == null) {
            return;
        }
        ArrayList possibleSpecies = Lists.newArrayList((Object[])EnumSpecies.values());
        if (!PixelExtrasConfig.allowRandomLegendaries) {
            possibleSpecies.removeIf(species -> EnumSpecies.legendaries.contains(species.name));
        }
        if (!PixelExtrasConfig.allowRandomUltraBeasts) {
            possibleSpecies.removeIf(species -> EnumSpecies.ultrabeasts.contains(species.name));
        }
        Pokemon pokemon = Pixelmon.pokemonFactory.create((EnumSpecies)CollectionHelper.getRandomElement((List)possibleSpecies));
        PokemonSpec spec = PokemonSpec.from((String[])args);
        spec.name = null;
        pokemon.setCaughtBall(EnumPokeballs.PokeBall);
        spec.apply(pokemon);
        PixelmonReceivedEvent event = new PixelmonReceivedEvent(player, ReceiveType.Command, pokemon);
        if (Pixelmon.EVENT_BUS.post((Event)event)) {
            return;
        }
        storage.add(pokemon);
        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.GREEN, (String)("You randomly gave a " + pokemon.getDisplayName() + " to " + player.getDisplayNameString()), (Object[])new Object[0]);
        if (PixelExtrasConfig.notifyOPs) {
            PokeRandom.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(sender.func_70005_c_() + " randomly gave a " + pokemon.getDisplayName() + " to " + player.getDisplayNameString()), (Object[])new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return PokeRandom.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

