/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.pixelextras.config.PixelExtrasConfig;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class PokeExp
extends CommandBase {
    public String func_71517_b() {
        return "pokexp";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/pokexp <slot> <player exp> - converts <player exp> into Pixelmon exp on <slot>";
    }

    private static void removeExperience(EntityPlayerMP player, int amount) {
        int j = Integer.MIN_VALUE + player.field_71067_cb;
        if (amount < j) {
            amount = j;
        }
        player.func_71023_q(amount);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 2 && sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = PokeExp.func_71521_c((ICommandSender)sender);
            int slot = Integer.parseInt(args[0]) - 1;
            int exp = Integer.parseInt(args[1]);
            int expToUse = (int)((double)exp * PixelExtrasConfig.expConversionRate);
            int playerTotalXP = player.field_71067_cb;
            float playerXP = player.field_71106_cc;
            if (expToUse > playerTotalXP) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Not enough experience!", (Object[])new Object[0]);
                if (playerXP > 0.0f) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)(playerXP + " exp is left!"), (Object[])new Object[0]);
                }
                return;
            }
            PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
            if (storage == null) {
                return;
            }
            List party = storage.getTeam();
            Pokemon pixelmon = (Pokemon)party.get(slot);
            pixelmon.getLevelContainer().awardEXP(exp);
            PokeExp.removeExperience(player, -((int)((double)exp * PixelExtrasConfig.expConversionRate)));
        } else {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return PokeExp.func_71530_a((String[])args, (String[])new String[]{"1", "2", "3", "4", "5", "6"});
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

