/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.pixelextras.api.command.TargetOfflinePartyCommand;
import com.pixelextras.util.TabCompletion;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class PokeEdit
extends TargetOfflinePartyCommand {
    public String func_71517_b() {
        return "pokeedit";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public int getMinimumArgs() {
        return 3;
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/pokeedit <player> <slot> <params>";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            return PokeEdit.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            return PokeEdit.func_71530_a((String[])args, (String[])new String[]{"1", "2", "3", "4", "5", "6"});
        }
        if (args.length >= 3) {
            int start = 0;
            String arg = args[args.length - 1].toLowerCase();
            if (arg.equals("")) {
                return PokeEdit.func_71530_a((String[])args, (String[])new String[]{"nature:", "growth:", "gender:", "ball:", "ability:", "shiny", "notshiny", "evHP:", "evAttack:", "evDefence:", "evSpecialAttack:", "evSpecialDefence:", "evSpeed:", "resetevs", "ivHP:", "ivAttack:", "ivDefence:", "ivSpecialAttack:", "ivSpecialDefence:", "ivSpeed:", "resetivs"});
            }
            if (arg.startsWith("n") || arg.startsWith("n:") || arg.startsWith("nature:")) {
                for (EnumNature n : EnumNature.values()) {
                    list.add(n.toString());
                }
                if (arg.startsWith("nature:")) {
                    start = 7;
                } else if (arg.startsWith("n:")) {
                    start = 2;
                } else if (arg.startsWith("n")) {
                    start = 1;
                }
                return TabCompletion.getListOfStringsMatchingLastWordCustom(args, start, list);
            }
            if (arg.startsWith("gr") || arg.startsWith("gr:") || arg.startsWith("growth:")) {
                for (EnumGrowth g : EnumGrowth.values()) {
                    list.add(g.toString());
                }
                if (arg.startsWith("growth:")) {
                    start = 7;
                } else if (arg.startsWith("gr:")) {
                    start = 3;
                } else if (arg.startsWith("gr")) {
                    start = 2;
                }
                return TabCompletion.getListOfStringsMatchingLastWordCustom(args, start, list);
            }
            if (arg.startsWith("ev") || arg.startsWith("iv")) {
                for (StatsType s : StatsType.values()) {
                    if (s.toString().equals("None") || s.toString().equals("Evasion") || s.toString().equals("Accuracy")) continue;
                    list.add(s.toString());
                }
                return TabCompletion.getListOfStringsMatchingLastWordCustom(args, 2, list);
            }
            if (arg.startsWith("ball:") || arg.startsWith("ba:") || arg.startsWith("ba")) {
                for (EnumPokeballs b : EnumPokeballs.values()) {
                    list.add(b.toString().replaceAll("Ball", ""));
                }
                if (arg.startsWith("ball:")) {
                    start = 5;
                } else if (arg.startsWith("ba:")) {
                    start = 3;
                } else if (arg.startsWith("ba")) {
                    start = 2;
                }
                return TabCompletion.getListOfStringsMatchingLastWordCustom(args, start, list);
            }
            if (arg.startsWith("ability:") || arg.startsWith("ab:") || arg.startsWith("ab")) {
                if (arg.startsWith("ability:")) {
                    start = 8;
                } else if (arg.startsWith("ab:")) {
                    start = 3;
                } else if (arg.startsWith("ab")) {
                    start = 2;
                }
                try {
                    EntityPlayerMP player = PokeEdit.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                    PlayerPartyStorage pStorage = Pixelmon.storageManager.getParty(player);
                    Pokemon pokemon = pStorage.get(Integer.parseInt(args[1]) - 1);
                    if (pokemon != null) {
                        return TabCompletion.getListOfStringsMatchingLastWordCustom(args, start, pokemon.getBaseStats().abilities);
                    }
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid pokemon in that slot!", (Object[])new Object[0]);
                }
                catch (CommandException e) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid Name! Try again!", (Object[])new Object[0]);
                }
            }
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args, PlayerPartyStorage storage, Pokemon pokemon) {
        String argString = String.join((CharSequence)" ", args);
        if (argString.contains("resetivs")) {
            pokemon.getIVs().set(StatsType.Defence, 0);
            pokemon.getIVs().set(StatsType.HP, 0);
            pokemon.getIVs().set(StatsType.SpecialDefence, 0);
            pokemon.getIVs().set(StatsType.SpecialAttack, 0);
            pokemon.getIVs().set(StatsType.Attack, 0);
            pokemon.getIVs().set(StatsType.Speed, 0);
        } else if (argString.contains("resetevs")) {
            pokemon.getEVs().set(StatsType.Defence, 0);
            pokemon.getEVs().set(StatsType.HP, 0);
            pokemon.getEVs().set(StatsType.SpecialDefence, 0);
            pokemon.getEVs().set(StatsType.SpecialAttack, 0);
            pokemon.getEVs().set(StatsType.Attack, 0);
            pokemon.getEVs().set(StatsType.Speed, 0);
        }
        PokemonSpec spec = new PokemonSpec(pokemon.getSpecies().name + " " + argString);
        spec.apply(pokemon);
        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.GREEN, (String)(pokemon.getDisplayName() + " has been edited!"), (Object[])new Object[0]);
    }
}

