/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.google.common.collect.Lists;
import com.pixelextras.config.PixelExtrasConfig;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class NPCKill
extends CommandBase {
    private List<String> types = Lists.newArrayList((Object[])new String[]{"all", "chatting", "doctor", "relearner", "shop", "trader", "trainer", "tutor"});

    public String func_71517_b() {
        return "pokenpckill";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/pokenpckill <type> - kills the selected type of Pixelmon NPCs";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1) {
            String type = args[0];
            if (this.types.contains(type)) {
                int undeadTrainers = 0;
                int slaughterCount = 0;
                List loadedEntities = sender.func_130014_f_().field_72996_f;
                switch (type) {
                    case "all": {
                        for (Entity e : loadedEntities) {
                            if (!(e instanceof EntityNPC)) continue;
                            EntityNPC npc = (EntityNPC)e;
                            if (npc instanceof NPCTrainer) {
                                NPCTrainer trainer = (NPCTrainer)npc;
                                if (trainer.battleController != null) {
                                    ++undeadTrainers;
                                    continue;
                                }
                            }
                            ++slaughterCount;
                            npc.func_70106_y();
                        }
                        break;
                    }
                    case "chatting": {
                        for (Object e : loadedEntities) {
                            if (!(e instanceof NPCChatting)) continue;
                            NPCChatting npc = (NPCChatting)e;
                            ++slaughterCount;
                            npc.func_70106_y();
                        }
                        break;
                    }
                    case "doctor": {
                        for (Object e : loadedEntities) {
                            if (!(e instanceof NPCNurseJoy)) continue;
                            NPCNurseJoy npc = (NPCNurseJoy)e;
                            ++slaughterCount;
                            npc.func_70106_y();
                        }
                        break;
                    }
                    case "relearner": {
                        for (Object e : loadedEntities) {
                            if (!(e instanceof NPCRelearner)) continue;
                            NPCRelearner npc = (NPCRelearner)e;
                            ++slaughterCount;
                            npc.func_70106_y();
                        }
                        break;
                    }
                    case "shop": {
                        for (Object e : loadedEntities) {
                            if (!(e instanceof NPCShopkeeper)) continue;
                            NPCShopkeeper npc = (NPCShopkeeper)e;
                            ++slaughterCount;
                            npc.func_70106_y();
                        }
                        break;
                    }
                    case "trader": {
                        for (Object e : loadedEntities) {
                            if (!(e instanceof NPCTrader)) continue;
                            NPCTrader npc = (NPCTrader)e;
                            ++slaughterCount;
                            npc.func_70106_y();
                        }
                        break;
                    }
                    case "trainer": {
                        for (Object e : loadedEntities) {
                            if (!(e instanceof NPCTrainer)) continue;
                            NPCTrainer npc = (NPCTrainer)e;
                            if (npc.battleController != null) {
                                ++undeadTrainers;
                                continue;
                            }
                            ++slaughterCount;
                            npc.func_70106_y();
                        }
                        break;
                    }
                    case "tutor": {
                        for (Object e : loadedEntities) {
                            if (!(e instanceof NPCTutor)) continue;
                            NPCTutor npc = (NPCTutor)e;
                            ++slaughterCount;
                            npc.func_70106_y();
                        }
                        break;
                    }
                }
                if (slaughterCount > 0) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.GREEN, (String)(slaughterCount + " " + type + " NPCs are now deceased."), (Object[])new Object[0]);
                    if (PixelExtrasConfig.notifyOPs) {
                        NPCKill.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(sender.func_70005_c_() + " butchered " + slaughterCount + " \"" + type + "\" NPCs!"), (Object[])new Object[0]);
                    }
                } else {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.GREEN, (String)("No " + type + " NPCs were killed."), (Object[])new Object[0]);
                }
                if (undeadTrainers > 0) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"%i Trainers were in battle and not killed!", (Object[])new Object[]{undeadTrainers});
                }
            } else {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"%s is not a valid Pixelmon NPC type", (Object[])new Object[]{type});
            }
        } else {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return NPCKill.func_175762_a((String[])args, this.types);
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

