/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.pixelextras.config.PixelExtrasConfig;
import com.pixelextras.util.PixelmonHelper;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CompSee
extends CommandBase {
    public String func_71517_b() {
        return "compsee";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/compsee <name> <box>";
    }

    public List<String> func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{"pokecompsee", "pcompsee"});
    }

    public int func_82362_a() {
        return 4;
    }

    private void getBoxList(int box, UUID player, ICommandSender sender) {
        Pokemon[] storedPokemon;
        for (Pokemon pokemon : storedPokemon = Pixelmon.storageManager.getPCForPlayer(player).getBox(box).getAll()) {
            if (pokemon == null) continue;
            ITextComponent message = PixelmonHelper.getHoverTextPokemon(pokemon, pokemon.getPosition().box + 1, pokemon.getPosition().order + 1);
            sender.func_145747_a(message);
        }
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
        } else {
            try {
                Integer box = Integer.parseInt(args[1].replaceAll("[^0-9]", ""));
                if (box <= 0 || box > PixelmonConfig.computerBoxes) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)("That box does not exist! Must be 1-" + PixelmonConfig.computerBoxes + "!"), (Object[])new Object[0]);
                    return;
                }
                if (PixelExtrasConfig.allowOfflineCheck) {
                    GameProfile gp = server.func_152358_ax().func_152655_a(args[0]);
                    if (gp == null) {
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"This player doesn't exist.", (Object[])new Object[0]);
                        return;
                    }
                    UUID uuid = gp.getId();
                    if (Pixelmon.storageManager.getPCForPlayer(uuid).countPokemon() == 0) {
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"This player doesn't exist or don't have any pokemon in his PC.", (Object[])new Object[0]);
                        return;
                    }
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.AQUA, (String)(args[0] + "'s Computer Box " + box + ": (Mouse over for more info)"), (Object[])new Object[0]);
                    this.getBoxList(box - 1, uuid, sender);
                } else {
                    EntityPlayerMP player = CompSee.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.AQUA, (String)(player.getDisplayNameString() + "'s Computer Box " + box + ": (Mouse over for more info)"), (Object[])new Object[0]);
                    this.getBoxList(box - 1, player.func_110124_au(), sender);
                }
            }
            catch (PlayerNotFoundException e) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid Name! Try again!", (Object[])new Object[0]);
            }
            catch (NumberFormatException e) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Please provide a box number!", (Object[])new Object[0]);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CompSee.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            String[] boxes = new String[PixelmonConfig.computerBoxes];
            for (int i = 0; i < boxes.length; ++i) {
                boxes[i] = String.valueOf(i + 1);
            }
            return CompSee.func_71530_a((String[])args, (String[])boxes);
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

