/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.pixelextras.config.PixelExtrasConfig;
import com.pixelextras.util.PixelmonHelper;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.storage.PCBox;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CompSearch
extends CommandBase {
    public String func_71517_b() {
        return "compsearch";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/compsearch <name> <specs>";
    }

    public List<String> func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{"pokecompsearch", "pcompsearch"});
    }

    public int func_82362_a() {
        return 4;
    }

    private List<ITextComponent> searchComputerPokemon(String[] args, UUID player) {
        PCBox[] storageBoxes = Pixelmon.storageManager.getPCForPlayer(player).getBoxes();
        int boxCount = Pixelmon.storageManager.getPCForPlayer(player).getBoxCount();
        int boxLimit = 30;
        ArrayList<ITextComponent> pokemonList = new ArrayList<ITextComponent>();
        PokemonSpec spec = PokemonSpec.from((String[])args);
        for (int i = 0; i < boxCount; ++i) {
            ArrayList<ITextComponent> boxList = new ArrayList<ITextComponent>();
            PCBox b = storageBoxes[i];
            for (int j = 0; j < boxLimit; ++j) {
                Pokemon pokemon = b.get(j);
                if (pokemon == null || !spec.matches(pokemon)) continue;
                boxList.add(PixelmonHelper.getHoverTextPokemon(pokemon, i + 1, j + 1));
            }
            if (boxList.size() == 0) continue;
            pokemonList.addAll(boxList);
        }
        return pokemonList;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
        } else {
            try {
                if (PixelExtrasConfig.allowOfflineCheck) {
                    GameProfile gp = server.func_152358_ax().func_152655_a(args[0]);
                    if (gp == null) {
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"This player doesn't exist.", (Object[])new Object[0]);
                        return;
                    }
                    UUID uuid = gp.getId();
                    if (Pixelmon.storageManager.getPCForPlayer(uuid).countPokemon() == 0) {
                        CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"This player doesn't exist or don't have any pokemon in his PC", (Object[])new Object[0]);
                        return;
                    }
                    String[] spec = new String[args.length - 1];
                    ArrayList speclist = Lists.newArrayList((Object[])args);
                    speclist.remove(0);
                    for (int i = 0; i < speclist.size(); ++i) {
                        spec[i] = (String)speclist.get(i);
                    }
                    List<ITextComponent> pokemonList = this.searchComputerPokemon(spec, uuid);
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.AQUA, (String)(args[0] + "'s Computer: (Mouse over for more info)"), (Object[])new Object[0]);
                    for (ITextComponent c : pokemonList) {
                        sender.func_145747_a(c);
                    }
                } else {
                    String[] spec = new String[args.length - 1];
                    ArrayList speclist = Lists.newArrayList((Object[])args);
                    speclist.remove(0);
                    for (int i = 0; i < speclist.size(); ++i) {
                        spec[i] = (String)speclist.get(i);
                    }
                    EntityPlayerMP entityPlayer = CompSearch.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                    List<ITextComponent> pokemonList = this.searchComputerPokemon(spec, entityPlayer.func_110124_au());
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.AQUA, (String)(entityPlayer.getDisplayNameString() + "'s Computer: (Mouse over for more info)"), (Object[])new Object[0]);
                    for (ITextComponent c : pokemonList) {
                        sender.func_145747_a(c);
                    }
                }
            }
            catch (PlayerNotFoundException e) {
                CommandChatHandler.sendChat((ICommandSender)sender, (String)"Invalid Name! Try again!", (Object[])new Object[0]);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        ArrayList<String> pokemon = new ArrayList<String>();
        if (args.length == 1) {
            return CompSearch.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            for (EnumSpecies p : EnumSpecies.values()) {
                pokemon.add(p.name);
            }
            return CompSearch.func_175762_a((String[])args, pokemon);
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

