/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.api.command;

import com.pixelextras.api.command.TargetOfflineStorageCommand;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.TextFormatting;

public abstract class TargetOfflinePCCommand
extends TargetOfflineStorageCommand<PCStorage> {
    @Override
    public PCStorage getStorageForUUID(UUID uuid) {
        return Pixelmon.storageManager.getPCForPlayer(uuid);
    }

    @Override
    public int getMinimumArgs() {
        return 3;
    }

    @Override
    public StoragePosition getPositionFromArgs(ICommandSender sender, String[] args) throws NumberFormatException {
        int box = Integer.parseInt(args[1].replaceAll("[^0-9]", ""));
        int slot = Integer.parseInt(args[2].replaceAll("[^0-9]", ""));
        if (box < 1 || box > PixelmonConfig.computerBoxes) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Box number must be between 1 and %s.", (Object[])new Object[]{PixelmonConfig.computerBoxes});
            return null;
        }
        if (slot < 1 || slot > 30) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Slot number must be between 1 and 30.", (Object[])new Object[0]);
            return null;
        }
        return new StoragePosition(box - 1, slot - 1);
    }
}

