/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.gameshark.network.packets;

import de.waterdu.gameshark.event.ClientEventHandler;
import de.waterdu.gameshark.helper.RadarHit;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ServerDataPacket
implements IMessage {
    private List<RadarHit> hits = new ArrayList<RadarHit>();

    public ServerDataPacket() {
    }

    public ServerDataPacket(List<RadarHit> hits) {
        this.hits = hits;
    }

    public void fromBytes(ByteBuf buf) {
        int j = buf.readInt();
        for (int i = 0; i < j; ++i) {
            this.hits.add(RadarHit.read(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.hits.size());
        for (RadarHit hit : this.hits) {
            hit.write(buf);
        }
    }

    public static class Handler
    implements IMessageHandler<ServerDataPacket, IMessage> {
        public IMessage onMessage(ServerDataPacket message, MessageContext ctx) {
            ClientEventHandler.deliveredConfig.getHits().clear();
            if (message.hits != null && message.hits.size() != 0) {
                ClientEventHandler.deliveredConfig.getHits().addAll(message.hits);
            }
            return null;
        }
    }
}

