/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.gameshark.network.packets;

import de.waterdu.gameshark.config.FileManager;
import de.waterdu.gameshark.event.ServerEventHandler;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RequestUserDefinedSearchPacket
implements IMessage {
    private Set<String> searches = new HashSet<String>();

    public RequestUserDefinedSearchPacket() {
    }

    public RequestUserDefinedSearchPacket(Set<String> searches) {
        this.searches = searches;
    }

    public void fromBytes(ByteBuf buf) {
        this.searches = new HashSet<String>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.searches.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.searches.size());
        for (String search : this.searches) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)search);
        }
    }

    public static class Handler
    implements IMessageHandler<RequestUserDefinedSearchPacket, IMessage> {
        public IMessage onMessage(RequestUserDefinedSearchPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (FileManager.getConfig().isCustomSearch()) {
                if (ServerEventHandler.playerSearches == null) {
                    ServerEventHandler.playerSearches = new HashMap();
                }
                if (!ServerEventHandler.playerSearches.isEmpty() && ServerEventHandler.playerSearches.containsKey(player.getPersistentID())) {
                    ServerEventHandler.playerSearches.remove(player.getPersistentID());
                }
                if (!message.searches.isEmpty()) {
                    ServerEventHandler.playerSearches.put(player.getPersistentID(), message.searches);
                }
            }
            return null;
        }
    }
}

