/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.gameshark.helper;

import de.waterdu.gameshark.helper.Position;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class RadarHit {
    private int index;
    private Position pos;
    private String name;

    public RadarHit(int index) {
        this(index, null);
    }

    public RadarHit(int index, Position pos) {
        this(index, pos, "");
    }

    public RadarHit(int index, Position pos, String name) {
        this.index = index;
        this.pos = pos;
        this.name = name;
    }

    public boolean hasPos() {
        return this.pos != null;
    }

    public boolean hasName() {
        return !this.name.isEmpty();
    }

    public void write(ByteBuf buf) {
        buf.writeInt(this.index);
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.writeDouble(this.pos.getX());
            buf.writeDouble(this.pos.getY());
            buf.writeDouble(this.pos.getZ());
        } else {
            buf.writeBoolean(false);
        }
        if (!this.name.isEmpty()) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static RadarHit read(ByteBuf buf) {
        RadarHit r = new RadarHit(buf.readInt());
        if (buf.readBoolean()) {
            r.pos = new Position(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
        if (buf.readBoolean()) {
            r.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        return r;
    }

    public int getIndex() {
        return this.index;
    }

    public Position getPos() {
        return this.pos;
    }

    public String getName() {
        return this.name;
    }
}

