/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.gameshark.gui;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import de.waterdu.gameshark.Gameshark;
import de.waterdu.gameshark.config.FileManager;
import de.waterdu.gameshark.config.structures.DeliveredConfig;
import de.waterdu.gameshark.config.structures.SearchCriteria;
import de.waterdu.gameshark.event.ClientEventHandler;
import de.waterdu.gameshark.gui.components.GuiColouredTextField;
import de.waterdu.gameshark.gui.components.GuiImageButton;
import de.waterdu.gameshark.gui.components.GuiTextList;
import de.waterdu.gameshark.gui.components.GuiToggleButton;
import de.waterdu.gameshark.helper.Resources;
import de.waterdu.gameshark.helper.ScreenLocation;
import de.waterdu.gameshark.network.PacketHandler;
import de.waterdu.gameshark.network.packets.RequestUserDefinedSearchPacket;
import java.awt.Color;
import java.io.IOException;
import java.util.HashSet;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class EditOverlayGui
extends GuiScreen {
    private GuiTextList pokemonList;
    private GuiColouredTextField searchBox;
    private GuiToggleButton[] buttons;
    private GuiToggleButton showOutlineBoxButton;
    private GuiToggleButton showLinesButton;
    private GuiToggleButton editMode;
    private GuiImageButton clearSelectedButton;
    private final boolean debug = Pixelmon.devEnvironment;
    private boolean guiEditMode = false;
    private boolean justEnabledEdit = false;
    private final ResourceLocation backgroundTexture = new ResourceLocation("gameshark", "gui/base-overlay.png");
    private final ResourceLocation searchTexture = new ResourceLocation("gameshark", "gui/search.png");
    private final ResourceLocation buttonClearListTexture = new ResourceLocation("gameshark", "gui/buttonClearList.png");

    public EditOverlayGui() {
        Mouse.getDWheel();
    }

    public void func_73866_w_() {
        DeliveredConfig config = ClientEventHandler.deliveredConfig;
        this.field_146292_n.clear();
        this.guiEditMode = false;
        int xOffset = this.field_146294_l / 2 - 125 + 13;
        int yOffset = this.field_146295_m / 2 - 100 + 13;
        this.pokemonList = new GuiTextList(this.field_146297_k.field_71466_p, xOffset, yOffset + 20, 100, 13);
        for (EnumSpecies pokemon : EnumSpecies.values()) {
            this.pokemonList.addLine(pokemon.name);
        }
        for (String selectedName : FileManager.getConfig().getSearches()) {
            this.pokemonList.selectLine(this.pokemonList.textLines.indexOf(selectedName));
        }
        this.searchBox = new GuiColouredTextField(this.field_146297_k.field_71466_p, xOffset, yOffset + 155, 100, 20, 0xF2F2F2);
        this.searchBox.setTextColor(Color.BLACK.getRGB());
        int togglebuttonWidth = 13;
        int togglebuttonHeight = 13;
        int buttonID = 0;
        this.buttons = new GuiToggleButton[config.getCriteria().size()];
        int gap = 130 / (config.getCriteria().size() - 1 == 0 ? 1 : config.getCriteria().size() - 1);
        for (SearchCriteria criteria : config.getCriteria()) {
            this.buttons[buttonID] = new GuiToggleButton(buttonID, xOffset + 108, yOffset - 6 + gap * buttonID, togglebuttonWidth, togglebuttonHeight, xOffset + 124, yOffset - 3 + gap * buttonID, criteria.getSwitchName(), Color.BLACK.getRGB(), Resources.tButtonOn, Resources.tButtonOff, Resources.tButtonLocked);
            this.field_146292_n.add(this.buttons[buttonID++]);
        }
        this.clearSelectedButton = new GuiImageButton(buttonID++, xOffset + 75, yOffset - 7, 22, 22, I18n.func_74838_a((String)"gameshark.gui.clear"), this.buttonClearListTexture, xOffset, yOffset, Color.BLACK.getRGB());
        this.field_146292_n.add(this.clearSelectedButton);
        this.showLinesButton = new GuiToggleButton(buttonID++, xOffset + 108, yOffset + 139, togglebuttonWidth, togglebuttonHeight, xOffset + 124, yOffset + 142, I18n.func_74838_a((String)"gameshark.gui.lines"), Color.BLACK.getRGB(), Resources.tButtonOn, Resources.tButtonOff, Resources.tButtonLocked);
        this.field_146292_n.add(this.showLinesButton);
        this.showOutlineBoxButton = new GuiToggleButton(buttonID++, xOffset + 108, yOffset + 154, togglebuttonWidth, togglebuttonHeight, xOffset + 124, yOffset + 157, I18n.func_74838_a((String)"gameshark.gui.outlines"), Color.BLACK.getRGB(), Resources.tButtonOn, Resources.tButtonOff, Resources.tButtonLocked);
        this.field_146292_n.add(this.showOutlineBoxButton);
        this.editMode = new GuiToggleButton(buttonID++, xOffset + 108, yOffset + 169, togglebuttonWidth, togglebuttonHeight, xOffset + 124, yOffset + 172, I18n.func_74838_a((String)"gameshark.gui.edit"), Color.BLACK.getRGB(), Resources.tButtonOn, Resources.tButtonOff, Resources.tButtonLocked);
        this.field_146292_n.add(this.editMode);
        this.obeyServer();
    }

    public void func_146281_b() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new RequestUserDefinedSearchPacket(FileManager.getConfig().getSearches()));
    }

    private void obeyServer() {
        DeliveredConfig config = ClientEventHandler.deliveredConfig;
        for (int i = 0; i < config.getCriteria().size(); ++i) {
            GuiToggleButton button = this.buttons[i];
            button.field_146124_l = true;
            button.toggle(!ClientEventHandler.disabledSearches.contains(i));
        }
        this.showLinesButton.field_146124_l = config.isShowLines();
        this.showLinesButton.toggle(config.isShowLines() && FileManager.getConfig().isShowLines());
        this.showOutlineBoxButton.field_146124_l = config.isShowOutlines();
        this.showOutlineBoxButton.toggle(config.isShowOutlines() && FileManager.getConfig().isShowOutlines());
        this.editMode.field_146124_l = true;
        this.editMode.toggle(false);
        if (!this.showOutlineBoxButton.field_146124_l) {
            FileManager.getConfig().setShowOutlines(false);
        }
        if (!this.showLinesButton.field_146124_l) {
            FileManager.getConfig().setShowLines(false);
        }
    }

    public void func_146276_q_() {
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        this.field_146297_k.field_71446_o.func_110577_a(this.backgroundTexture);
        Gui.func_146110_a((int)(this.field_146294_l / 2 - 125), (int)(this.field_146295_m / 2 - 100), (float)0.0f, (float)0.0f, (int)dispWidth, (int)dispHeight, (float)dispWidth, (float)dispHeight);
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        DeliveredConfig config = ClientEventHandler.deliveredConfig;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        this.func_146276_q_();
        int xOffset = this.field_146294_l / 2 - 125 + 13;
        int yOffset = this.field_146295_m / 2 - 100 + 13;
        super.func_73863_a(mouseX, mouseY, f);
        this.pokemonList.drawBackground();
        this.pokemonList.drawText();
        this.searchBox.drawTextBox();
        this.checkMouseWheel();
        if (this.debug) {
            this.field_146289_q.func_78276_b("X: " + (mouseX - xOffset) + " Y: " + (mouseY - yOffset), mouseX, mouseY, Color.red.getRGB());
        }
        this.field_146297_k.field_71446_o.func_110577_a(this.searchTexture);
        GlStateManager.func_179084_k();
    }

    private void checkMouseWheel() {
        int mousewheelDirection = Mouse.getDWheel();
        if (mousewheelDirection == 120) {
            this.pokemonList.scrollDown();
        } else if (mousewheelDirection == -120) {
            this.pokemonList.scrollUp();
        }
    }

    public void func_73869_a(char c, int i) {
        block4: {
            try {
                super.func_73869_a(c, i);
            }
            catch (IOException e) {
                if (!this.debug) break block4;
                Gameshark.log.error(e.getLocalizedMessage());
            }
        }
        DeliveredConfig config = ClientEventHandler.deliveredConfig;
        if (this.searchBox.isFocused()) {
            this.searchBox.textboxKeyTyped(c, i);
            if (this.searchBox.getText().length() != 0) {
                this.pokemonList.gotoFirstLineStartingWith(this.searchBox.getText());
            }
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int k) {
        block23: {
            try {
                super.func_73864_a(mouseX, mouseY, k);
            }
            catch (IOException e) {
                if (!Pixelmon.devEnvironment) break block23;
                Gameshark.log.error(e.getLocalizedMessage());
            }
        }
        int xOffset = this.field_146294_l / 2 - 125 + 13;
        int yOffset = this.field_146295_m / 2 - 100 + 13;
        DeliveredConfig config = ClientEventHandler.deliveredConfig;
        if (!this.guiEditMode) {
            this.searchBox.mouseClicked(mouseX, mouseY, k);
        }
        this.pokemonList.setFocused(mouseX - xOffset > 0 && mouseX - xOffset < 100 && mouseY - yOffset > 20 && mouseY - yOffset < 150);
        if (this.pokemonList.isFocused && !this.guiEditMode) {
            String clickedOnPokemon = this.pokemonList.mouseClicked(mouseX, mouseY, 0, yOffset + 20);
            int lineindex = this.pokemonList.textLines.indexOf(clickedOnPokemon);
            this.pokemonList.selectLine(lineindex);
            FileManager.getConfig().setSearches(new HashSet<String>(this.pokemonList.getSelectedLinesContent()));
            FileManager.writeConfig();
        }
        if (this.guiEditMode) {
            if (this.justEnabledEdit) {
                this.justEnabledEdit = false;
            } else if (mouseX < this.field_146294_l / 3) {
                if (mouseY < this.field_146295_m / 3) {
                    FileManager.getConfig().setScreenLocation(ScreenLocation.TOP_LEFT);
                } else if (mouseY > this.field_146295_m / 3 * 2) {
                    FileManager.getConfig().setScreenLocation(ScreenLocation.BOTTOM_LEFT);
                } else {
                    FileManager.getConfig().setScreenLocation(ScreenLocation.CENTER_LEFT);
                }
            } else if (mouseX > this.field_146294_l / 3 * 2) {
                if (mouseY < this.field_146295_m / 3) {
                    FileManager.getConfig().setScreenLocation(ScreenLocation.TOP_RIGHT);
                } else if (mouseY > this.field_146295_m / 3 * 2) {
                    FileManager.getConfig().setScreenLocation(ScreenLocation.BOTTOM_RIGHT);
                } else {
                    FileManager.getConfig().setScreenLocation(ScreenLocation.CENTER_RIGHT);
                }
            } else if (mouseY < this.field_146295_m / 3) {
                FileManager.getConfig().setScreenLocation(ScreenLocation.TOP_CENTER);
            } else if (mouseY > this.field_146295_m / 3 * 2) {
                FileManager.getConfig().setScreenLocation(ScreenLocation.BOTTOM_CENTER);
            } else {
                FileManager.getConfig().setScreenLocation(ScreenLocation.CENTER_CENTER);
            }
        }
    }

    public void func_73876_c() {
    }

    protected void func_146284_a(GuiButton clicked) {
        DeliveredConfig config = ClientEventHandler.deliveredConfig;
        if (!this.guiEditMode) {
            for (int i = 0; i < config.getCriteria().size(); ++i) {
                GuiToggleButton button = this.buttons[i];
                if (button != clicked) continue;
                if (ClientEventHandler.disabledSearches.contains(i)) {
                    ClientEventHandler.disabledSearches.remove(i);
                    button.toggle(true);
                } else {
                    ClientEventHandler.disabledSearches.add(i);
                    button.toggle(false);
                }
                return;
            }
            if (clicked == this.clearSelectedButton) {
                this.pokemonList.selectedLines.clear();
                FileManager.getConfig().getSearches().clear();
                return;
            }
            if (clicked == this.showLinesButton) {
                FileManager.getConfig().setShowLines(!FileManager.getConfig().isShowLines());
                ((GuiToggleButton)clicked).toggle(FileManager.getConfig().isShowLines());
            }
            if (clicked == this.showOutlineBoxButton) {
                FileManager.getConfig().setShowOutlines(!FileManager.getConfig().isShowOutlines());
                ((GuiToggleButton)clicked).toggle(FileManager.getConfig().isShowOutlines());
            }
        }
        if (clicked == this.editMode) {
            this.guiEditMode = !this.guiEditMode;
            ((GuiToggleButton)clicked).toggle(this.guiEditMode);
            this.justEnabledEdit = true;
        }
    }
}

