/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.gameshark.event;

import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import de.waterdu.gameshark.config.FileManager;
import de.waterdu.gameshark.config.structures.SearchCriteria;
import de.waterdu.gameshark.helper.Position;
import de.waterdu.gameshark.helper.RadarHit;
import de.waterdu.gameshark.network.PacketHandler;
import de.waterdu.gameshark.network.packets.ServerDataPacket;
import de.waterdu.gameshark.network.packets.ServerSettingsPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerEventHandler {
    private List<UUID> playersWith = new ArrayList<UUID>();
    public static HashMap<UUID, Set<String>> playerSearches = new HashMap();
    private int updateCounter = 0;

    public ServerEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onConnect(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        Map mods = NetworkDispatcher.get((NetworkManager)event.getManager()).getModList();
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        if (mods != null && mods.containsKey("gameshark")) {
            this.playersWith.add(player.getPersistentID());
        }
    }

    @SubscribeEvent
    public void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        PacketHandler.INSTANCE.sendTo((IMessage)new ServerSettingsPacket(), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        if (this.playersWith.contains(event.player.getPersistentID())) {
            this.playersWith.remove(event.player.getPersistentID());
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        ++this.updateCounter;
        if (this.updateCounter >= FileManager.getConfig().getUpdateRate()) {
            this.updateCounter = 0;
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            for (EntityPlayerMP p : server.func_184103_al().func_181057_v()) {
                this.handleTick(server, p);
            }
        }
    }

    private void handleTick(MinecraftServer s, EntityPlayerMP p) {
        ArrayList<RadarHit> hits = new ArrayList<RadarHit>();
        boolean active = false;
        for (WorldServer w : s.field_71305_c) {
            active = true;
            if (!FileManager.getConfig().isEnabled() || !this.playersWith.contains(p.getPersistentID())) continue;
            block1: for (Entity e : w.field_72996_f) {
                if (e instanceof EntityPixelmon) {
                    EntityPixelmon pix = (EntityPixelmon)e;
                    if (pix.getPokemonData().getOwnerPlayerUUID() != null || pix.getPokemonData().getOwnerTrainerUUID() != null || !p.field_70170_p.equals(w)) continue;
                    for (int i = 0; i < FileManager.getConfig().getCriteria().size(); ++i) {
                        SearchCriteria criteria = FileManager.getConfig().getCriteria().get(i);
                        if (!criteria.matches(pix, (EntityPlayer)p)) continue;
                        hits.add(new RadarHit(i, criteria.isSendPosition() ? new Position(pix.field_70169_q - 0.5, pix.field_70167_r, pix.field_70166_s - 0.5) : null, criteria.isSendDetails() ? pix.getPokemonName() : ""));
                        continue block1;
                    }
                    continue;
                }
                for (int i = 0; i < FileManager.getConfig().getCriteria().size(); ++i) {
                    SearchCriteria criteria = FileManager.getConfig().getCriteria().get(i);
                    if (!criteria.matches(e, (EntityPlayer)p)) continue;
                    hits.add(new RadarHit(i, criteria.isSendPosition() ? new Position(e.field_70169_q - 0.5, e.field_70167_r, e.field_70166_s - 0.5) : null, criteria.isSendDetails() ? e.func_145748_c_().func_150260_c() : ""));
                    continue block1;
                }
            }
            block4: for (TileEntity te : w.field_147482_g) {
                for (int i = 0; i < FileManager.getConfig().getCriteria().size(); ++i) {
                    SearchCriteria criteria = FileManager.getConfig().getCriteria().get(i);
                    if (!criteria.matches(te, (EntityPlayer)p)) continue;
                    hits.add(new RadarHit(i, criteria.isSendPosition() ? new Position(te.func_174877_v()) : null, criteria.isSendDetails() ? te.func_145838_q().func_149732_F() : ""));
                    continue block4;
                }
            }
        }
        if (active) {
            PacketHandler.INSTANCE.sendTo((IMessage)new ServerDataPacket(hits), p);
        }
    }
}

