/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.gameshark.event;

import com.pixelmonmod.pixelmon.Pixelmon;
import de.waterdu.gameshark.Gameshark;
import de.waterdu.gameshark.config.FileManager;
import de.waterdu.gameshark.config.structures.DeliveredConfig;
import de.waterdu.gameshark.config.structures.SearchCriteria;
import de.waterdu.gameshark.gui.EditOverlayGui;
import de.waterdu.gameshark.helper.DrawHelper;
import de.waterdu.gameshark.helper.RadarHit;
import de.waterdu.gameshark.network.PacketHandler;
import de.waterdu.gameshark.network.packets.RequestUserDefinedSearchPacket;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientEventHandler {
    public static DeliveredConfig deliveredConfig = new DeliveredConfig();
    public static HashSet<Integer> disabledSearches = new HashSet();
    private static KeyBinding openGuiKey;

    public ClientEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        openGuiKey = new KeyBinding("Gameshark GUI", 43, "Gameshark");
        ClientRegistry.registerKeyBinding((KeyBinding)openGuiKey);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        deliveredConfig = new DeliveredConfig();
        deliveredConfig.fromOwnConfig();
        deliveredConfig.setEnabled(true);
        disabledSearches.clear();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        deliveredConfig.getHits().clear();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (openGuiKey.func_151468_f() && deliveredConfig.isEnabled()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new EditOverlayGui());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onJoin(EntityJoinWorldEvent event) {
        MinecraftServer server;
        if (event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new RequestUserDefinedSearchPacket(FileManager.getConfig().getSearches()));
                }
            };
            Timer timer = new Timer();
            timer.schedule(task, 1000L);
        }
        if ((server = FMLClientHandler.instance().getServer()) != null && server.func_71264_H()) {
            FileManager.getConfig().setEnabled(server.field_71305_c[0].func_72912_H().func_76086_u());
        }
    }

    public static RadarHit getNearest(EntityPlayer p) {
        try {
            RadarHit nearest = null;
            for (RadarHit r : deliveredConfig.getHits()) {
                if (r == null || disabledSearches.contains(r.getIndex())) continue;
                if (nearest == null) {
                    nearest = r;
                    continue;
                }
                SearchCriteria hitCriteria = deliveredConfig.getCriteria(r.getIndex());
                SearchCriteria nearestCriteria = deliveredConfig.getCriteria(nearest.getIndex());
                if (nearest.getPos() == null) {
                    if (hitCriteria.getWeight() <= nearestCriteria.getWeight()) continue;
                    nearest = r;
                    continue;
                }
                if (r.getPos() != null && hitCriteria.getWeight() == nearestCriteria.getWeight() && p.func_70011_f(nearest.getPos().getX(), nearest.getPos().getY(), nearest.getPos().getZ()) > p.func_70011_f(r.getPos().getX(), r.getPos().getY(), r.getPos().getZ())) {
                    nearest = r;
                }
                if (hitCriteria.getWeight() <= nearestCriteria.getWeight()) continue;
                nearest = r;
            }
            return nearest;
        }
        catch (Exception e) {
            if (Pixelmon.devEnvironment) {
                Gameshark.log.error(e.getLocalizedMessage());
            }
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        block3: {
            try {
                EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
                for (RadarHit r : deliveredConfig.getHits()) {
                    if (r.getPos() == null) continue;
                    SearchCriteria criteria = deliveredConfig.getCriteria(r.getIndex());
                    if (disabledSearches.contains(r.getIndex())) continue;
                    DrawHelper.drawLineToBlockPos(p, r.getPos(), event.getPartialTicks(), criteria);
                }
            }
            catch (Exception e) {
                if (!Pixelmon.devEnvironment) break block3;
                Gameshark.log.error(e.getLocalizedMessage());
            }
        }
    }
}

