/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.gameshark.config.structures;

import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import de.waterdu.gameshark.event.ServerEventHandler;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class SearchCriteria {
    private Color color;
    private String name;
    private String switchName;
    private int weight;
    private boolean sendDetails;
    private boolean sendPosition;
    private int searchRadius;
    private boolean isPokemon;
    private boolean userSearch;
    private Set<String> validPokemon;
    private boolean shiny;
    private boolean boss;
    private boolean isTileEntity;
    private Set<String> tileEntities;
    private boolean isEntity;
    private Set<String> entities;

    public SearchCriteria(ByteBuf buf) {
        this.fromBuffer(buf);
    }

    public int getWeightNegative() {
        return -this.weight;
    }

    public boolean matches(EntityPixelmon pixelmon, EntityPlayer player) {
        if (!this.isPokemon) {
            return false;
        }
        if (player.func_70011_f(pixelmon.field_70165_t, pixelmon.field_70163_u, pixelmon.field_70161_v) > (double)this.searchRadius) {
            return false;
        }
        boolean valid = true;
        if (this.userSearch) {
            Set<String> userSearch = ServerEventHandler.playerSearches.get(player.getPersistentID());
            if (userSearch != null) {
                if (!userSearch.contains(pixelmon.getPokemonName())) {
                    valid = false;
                }
            } else {
                valid = false;
            }
        }
        if (valid && this.validPokemon.size() != 0 && !this.validPokemon.contains(pixelmon.getPokemonData().getSpecies().getPokemonName())) {
            valid = false;
        }
        if (valid && this.shiny && !pixelmon.getPokemonData().isShiny()) {
            valid = false;
        }
        if (valid && this.boss && pixelmon.getBossMode() == EnumBossMode.NotBoss) {
            valid = false;
        }
        return valid;
    }

    public boolean matches(TileEntity tileEntity, EntityPlayer player) {
        if (!this.isTileEntity) {
            return false;
        }
        if (player.func_70011_f((double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p()) > (double)this.searchRadius) {
            return false;
        }
        boolean valid = true;
        ResourceLocation rl = TileEntity.func_190559_a(tileEntity.getClass());
        if (rl != null) {
            if (this.tileEntities.size() != 0 && !this.tileEntities.contains(rl.toString())) {
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    public boolean matches(Entity entity, EntityPlayer player) {
        if (!this.isEntity) {
            return false;
        }
        if (player.func_70011_f(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) > (double)this.searchRadius) {
            return false;
        }
        boolean valid = true;
        EntityEntry entry = EntityRegistry.getEntry(entity.getClass());
        if (entry != null) {
            ResourceLocation rl = entry.getRegistryName();
            if (rl != null) {
                if (this.entities.size() != 0 && !this.entities.contains(rl.toString())) {
                    valid = false;
                }
            } else {
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    public void toBuffer(ByteBuf buf) {
        buf.writeInt(this.color.getRGB());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.switchName);
        buf.writeInt(this.weight);
        buf.writeBoolean(this.sendDetails);
        buf.writeBoolean(this.sendPosition);
        buf.writeInt(this.searchRadius);
        buf.writeBoolean(this.isPokemon);
        buf.writeBoolean(this.userSearch);
        buf.writeShort(this.validPokemon.size());
        for (String validPokemon : this.validPokemon) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)validPokemon);
        }
        buf.writeBoolean(this.shiny);
        buf.writeBoolean(this.boss);
        buf.writeBoolean(this.isTileEntity);
        buf.writeShort(this.tileEntities.size());
        for (String tileEntity : this.tileEntities) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)tileEntity);
        }
        buf.writeBoolean(this.isEntity);
        buf.writeShort(this.entities.size());
        for (String tileEntity : this.entities) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)tileEntity);
        }
    }

    public void fromBuffer(ByteBuf buf) {
        this.color = new Color(buf.readInt());
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.switchName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.weight = buf.readInt();
        this.sendDetails = buf.readBoolean();
        this.sendPosition = buf.readBoolean();
        this.searchRadius = buf.readInt();
        this.isPokemon = buf.readBoolean();
        this.userSearch = buf.readBoolean();
        this.validPokemon = new HashSet<String>();
        int len1 = buf.readShort();
        for (int i = 0; i < len1; ++i) {
            this.validPokemon.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        this.shiny = buf.readBoolean();
        this.boss = buf.readBoolean();
        this.isTileEntity = buf.readBoolean();
        this.tileEntities = new HashSet<String>();
        int len2 = buf.readShort();
        for (int i = 0; i < len2; ++i) {
            this.tileEntities.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        this.isEntity = buf.readBoolean();
        this.entities = new HashSet<String>();
        int len3 = buf.readShort();
        for (int i = 0; i < len3; ++i) {
            this.entities.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public Color getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public String getSwitchName() {
        return this.switchName;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isSendDetails() {
        return this.sendDetails;
    }

    public boolean isSendPosition() {
        return this.sendPosition;
    }

    public int getSearchRadius() {
        return this.searchRadius;
    }

    public boolean isPokemon() {
        return this.isPokemon;
    }

    public boolean isUserSearch() {
        return this.userSearch;
    }

    public Set<String> getValidPokemon() {
        return this.validPokemon;
    }

    public boolean isShiny() {
        return this.shiny;
    }

    public boolean isBoss() {
        return this.boss;
    }

    public boolean isTileEntity() {
        return this.isTileEntity;
    }

    public Set<String> getTileEntities() {
        return this.tileEntities;
    }

    public boolean isEntity() {
        return this.isEntity;
    }

    public Set<String> getEntities() {
        return this.entities;
    }

    public SearchCriteria(Color color, String name, String switchName, int weight, boolean sendDetails, boolean sendPosition, int searchRadius, boolean isPokemon, boolean userSearch, Set<String> validPokemon, boolean shiny, boolean boss, boolean isTileEntity, Set<String> tileEntities, boolean isEntity, Set<String> entities) {
        this.color = color;
        this.name = name;
        this.switchName = switchName;
        this.weight = weight;
        this.sendDetails = sendDetails;
        this.sendPosition = sendPosition;
        this.searchRadius = searchRadius;
        this.isPokemon = isPokemon;
        this.userSearch = userSearch;
        this.validPokemon = validPokemon;
        this.shiny = shiny;
        this.boss = boss;
        this.isTileEntity = isTileEntity;
        this.tileEntities = tileEntities;
        this.isEntity = isEntity;
        this.entities = entities;
    }
}

