/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.gameshark.config.structures;

import de.waterdu.gameshark.config.FileManager;
import de.waterdu.gameshark.config.structures.SearchCriteria;
import de.waterdu.gameshark.helper.RadarHit;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.CopyOnWriteArrayList;

public class DeliveredConfig {
    private boolean enabled = true;
    private ArrayList<SearchCriteria> criteria = new ArrayList();
    private boolean customSearch = true;
    private boolean showLines = true;
    private boolean showOutlines = true;
    private boolean showInterface = true;
    private CopyOnWriteArrayList<RadarHit> hits = new CopyOnWriteArrayList();

    public void fromBuffer(ByteBuf buf) {
        this.enabled = buf.readBoolean();
        short size = buf.readShort();
        this.criteria = new ArrayList();
        for (short i = 0; i < size; i = (short)(i + 1)) {
            this.criteria.add(new SearchCriteria(buf));
        }
        this.showLines = buf.readBoolean();
        this.showOutlines = buf.readBoolean();
        this.showInterface = buf.readBoolean();
        this.criteria.sort(Comparator.comparing(SearchCriteria::getWeightNegative));
    }

    public void fromOwnConfig() {
        this.enabled = FileManager.getConfig().isEnabled();
        this.criteria = FileManager.getConfig().getCriteria();
        this.customSearch = FileManager.getConfig().isCustomSearch();
        this.showLines = FileManager.getConfig().isShowLines();
        this.showOutlines = FileManager.getConfig().isShowOutlines();
        this.showInterface = FileManager.getConfig().isShowInterface();
        this.hits = new CopyOnWriteArrayList();
    }

    public SearchCriteria getCriteria(int index) {
        return this.criteria.get(index);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ArrayList<SearchCriteria> getCriteria() {
        return this.criteria;
    }

    public boolean isCustomSearch() {
        return this.customSearch;
    }

    public boolean isShowLines() {
        return this.showLines;
    }

    public boolean isShowOutlines() {
        return this.showOutlines;
    }

    public boolean isShowInterface() {
        return this.showInterface;
    }

    public CopyOnWriteArrayList<RadarHit> getHits() {
        return this.hits;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCriteria(ArrayList<SearchCriteria> criteria) {
        this.criteria = criteria;
    }

    public void setCustomSearch(boolean customSearch) {
        this.customSearch = customSearch;
    }

    public void setShowLines(boolean showLines) {
        this.showLines = showLines;
    }

    public void setShowOutlines(boolean showOutlines) {
        this.showOutlines = showOutlines;
    }

    public void setShowInterface(boolean showInterface) {
        this.showInterface = showInterface;
    }

    public void setHits(CopyOnWriteArrayList<RadarHit> hits) {
        this.hits = hits;
    }
}

