/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.gameshark.config.structures;

import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import de.waterdu.gameshark.config.structures.SearchCriteria;
import de.waterdu.gameshark.helper.ScreenLocation;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;

public class Config {
    private boolean enabled = false;
    private ArrayList<SearchCriteria> criteria = new ArrayList();
    private boolean customSearch = true;
    private boolean showLines = true;
    private boolean showOutlines = true;
    private boolean showInterface = true;
    private int updateRate = 1;
    private ScreenLocation screenLocation = ScreenLocation.TOP_CENTER;
    private HashSet<String> searches = new HashSet();

    public Config() {
        this.criteria.add(new SearchCriteria(Color.BLUE, "Boss", "Show Bosses", 7, true, true, 150, true, false, new HashSet<String>(), false, true, false, new HashSet<String>(), false, new HashSet<String>()));
        this.criteria.add(new SearchCriteria(Color.RED, "Legendary", "Show Legendaries", 6, true, true, 150, true, false, new HashSet<String>(EnumSpecies.legendaries), false, false, false, new HashSet<String>(), false, new HashSet<String>()));
        this.criteria.add(new SearchCriteria(Color.CYAN, "Ultra Beast", "Show Ultra Beasts", 5, true, true, 150, true, false, new HashSet<String>(EnumSpecies.ultrabeasts), false, false, false, new HashSet<String>(), false, new HashSet<String>()));
        this.criteria.add(new SearchCriteria(Color.GREEN, "Shiny", "Show Shinies", 4, true, true, 150, true, false, new HashSet<String>(), true, false, false, new HashSet<String>(), false, new HashSet<String>()));
        HashSet<String> entities = new HashSet<String>();
        entities.add("pixelmon:ultra_wormhole");
        this.criteria.add(new SearchCriteria(new Color(0x8800FF), "Ultra Wormhole", "Show Wormholes", 3, true, true, 150, false, false, new HashSet<String>(), false, false, false, new HashSet<String>(), true, entities));
        HashSet<String> shrines = new HashSet<String>();
        shrines.add("pixelmon:bird_shrine");
        shrines.add("pixelmon:timespace_shrine");
        shrines.add("pixelmon:plate_holder");
        this.criteria.add(new SearchCriteria(Color.MAGENTA, "Shrine", "Show Shrines", 2, true, true, 150, false, false, new HashSet<String>(), false, false, true, shrines, false, new HashSet<String>()));
        HashSet<String> loot = new HashSet<String>();
        loot.add("pixelmon:poke_chest");
        this.criteria.add(new SearchCriteria(Color.YELLOW, "Pok\u00e9loot", "Show Pok\u00e9loot", 1, true, true, 150, false, false, new HashSet<String>(), false, false, true, loot, false, new HashSet<String>()));
        this.criteria.add(new SearchCriteria(Color.ORANGE, "Custom", "Show Custom", 0, true, true, 150, true, true, new HashSet<String>(), false, false, false, new HashSet<String>(), false, new HashSet<String>()));
    }

    public void toBuffer(ByteBuf buf) {
        buf.writeBoolean(this.enabled);
        buf.writeShort(this.criteria.size());
        for (SearchCriteria criterion : this.criteria) {
            criterion.toBuffer(buf);
        }
        buf.writeBoolean(this.showLines);
        buf.writeBoolean(this.showOutlines);
        buf.writeBoolean(this.showInterface);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ArrayList<SearchCriteria> getCriteria() {
        return this.criteria;
    }

    public boolean isCustomSearch() {
        return this.customSearch;
    }

    public boolean isShowLines() {
        return this.showLines;
    }

    public boolean isShowOutlines() {
        return this.showOutlines;
    }

    public boolean isShowInterface() {
        return this.showInterface;
    }

    public int getUpdateRate() {
        return this.updateRate;
    }

    public ScreenLocation getScreenLocation() {
        return this.screenLocation;
    }

    public HashSet<String> getSearches() {
        return this.searches;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCriteria(ArrayList<SearchCriteria> criteria) {
        this.criteria = criteria;
    }

    public void setCustomSearch(boolean customSearch) {
        this.customSearch = customSearch;
    }

    public void setShowLines(boolean showLines) {
        this.showLines = showLines;
    }

    public void setShowOutlines(boolean showOutlines) {
        this.showOutlines = showOutlines;
    }

    public void setShowInterface(boolean showInterface) {
        this.showInterface = showInterface;
    }

    public void setUpdateRate(int updateRate) {
        this.updateRate = updateRate;
    }

    public void setScreenLocation(ScreenLocation screenLocation) {
        this.screenLocation = screenLocation;
    }

    public void setSearches(HashSet<String> searches) {
        this.searches = searches;
    }
}

