/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.gameshark.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.waterdu.gameshark.Gameshark;
import de.waterdu.gameshark.config.structures.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;

public class FileManager {
    private static Config config = new Config();

    public static void ensureNotNull() {
        if (config == null) {
            config = new Config();
        }
    }

    private static void loadFromFile(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            Gson gson = new Gson();
            BufferedReader br = new BufferedReader(new FileReader(file));
            config = (Config)gson.fromJson((Reader)br, Config.class);
            br.close();
            Gameshark.log.info("Successfully read config.");
        }
        catch (Exception e) {
            Gameshark.log.error("Failed to read config.\r\n" + e.getMessage());
        }
    }

    private static void writeToFile(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((Object)config);
            FileWriter writer = new FileWriter(file);
            writer.write(json);
            writer.close();
            Gameshark.log.info("Successfully saved config.");
        }
        catch (Exception e) {
            Gameshark.log.error("Failed to save config.\r\n" + e.getMessage());
        }
    }

    public static Config getConfig() {
        return config;
    }

    public static void readConfig() {
        FileManager.loadFromFile(Gameshark.configFile);
    }

    public static void writeConfig() {
        FileManager.writeToFile(Gameshark.configFile);
    }
}

