/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.gameshark;

import de.waterdu.gameshark.CommonProxy;
import de.waterdu.gameshark.command.GamesharkCommand;
import de.waterdu.gameshark.config.FileManager;
import de.waterdu.gameshark.helper.Rares;
import de.waterdu.gameshark.network.PacketHandler;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(name="Gameshark", version="6.0.4", modid="gameshark", acceptableRemoteVersions="*", dependencies="required-after:pixelmon", acceptedMinecraftVersions="[1.12.2]")
public class Gameshark {
    public static final String MODNAME = "Gameshark";
    public static final String MODVERSION = "6.0.4";
    public static final String MODID = "gameshark";
    @Mod.Instance(value="gameshark")
    public static Gameshark instance;
    public static File configFile;
    public static Logger log;
    @SidedProxy(clientSide="de.waterdu.gameshark.ClientProxy", serverSide="de.waterdu.gameshark.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File rootDirectory = new File(event.getModConfigurationDirectory().getParent());
        File modDirectory = new File(rootDirectory + "/config/gameshark");
        if (modDirectory.mkdir()) {
            log.info("Created directory.");
        }
        configFile = new File(modDirectory, "gameshark.json");
        FileManager.readConfig();
        FileManager.ensureNotNull();
        FileManager.writeConfig();
        Rares.init();
        this.addMeta(event);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PacketHandler.init();
        proxy.init(event);
        log.info("initializing Gameshark v6.0.4");
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new GamesharkCommand());
    }

    private void addMeta(FMLPreInitializationEvent event) {
        ModMetadata m = event.getModMetadata();
        m.autogenerated = false;
        m.modId = MODID;
        m.version = MODVERSION;
        m.name = MODNAME;
        m.url = "http://reforged.gg/";
        m.description = "Find Pixelmon with ease, now with unbreakable server security!";
        m.credits = "Waterdude";
    }

    static {
        log = LogManager.getLogger((String)MODNAME);
    }
}

