/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.functions.BlockPosFunctions;
import com.natamus.collective.functions.CompareBlockFunctions;
import com.natamus.collective.functions.CompareItemFunctions;
import com.natamus.collective.functions.DataFunctions;
import com.natamus.collective.functions.ToolFunctions;
import com.natamus.treeharvester.config.ConfigHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.MyceliumBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class Util {
    private static String dirpath = DataFunctions.getConfigDirectory() + File.separator + "treeharvester";
    private static File dir = new File(dirpath);
    private static File file = new File(dirpath + File.separator + "harvestable_axe_blacklist.txt");
    public static List<Item> allowedAxes = new ArrayList<Item>();
    public static HashMap<BlockPos, Integer> highestleaf = new HashMap();
    public static CopyOnWriteArrayList<Pair<BlockPos, CopyOnWriteArrayList<BlockPos>>> lowerlogs = new CopyOnWriteArrayList();

    public static void setupAxeBlacklist() throws IOException {
        ArrayList<String> blacklist = new ArrayList<String>();
        PrintWriter writer = null;
        if (!dir.isDirectory() || !file.isFile()) {
            boolean ignored = dir.mkdirs();
            writer = new PrintWriter(dirpath + File.separator + "harvestable_axe_blacklist.txt", "UTF-8");
        } else {
            String blcontent = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "harvestable_axe_blacklist.txt", new String[0])));
            for (String axerl : blcontent.split(",")) {
                String name = axerl.replace("\n", "").trim();
                if (name.startsWith("//") || !name.startsWith("!")) continue;
                blacklist.add(name.replace("!", ""));
            }
        }
        if (writer != null) {
            writer.println("// To disable a certain axe from being able to harvest trees, add an exclamation mark (!) in front of the line,");
        }
        for (Item item : ForgeRegistries.ITEMS) {
            ResourceLocation rl;
            if (!ToolFunctions.isAxe((ItemStack)new ItemStack((IItemProvider)item)).booleanValue() || (rl = item.getRegistryName()) == null) continue;
            String name = rl.toString();
            if (writer != null) {
                writer.println(name + ",");
            }
            if (blacklist.contains(name)) continue;
            allowedAxes.add(item);
        }
        if (writer != null) {
            writer.close();
        }
    }

    public static int isTreeAndReturnLogAmount(World world, BlockPos pos) {
        highestleaf.put(pos, 0);
        int leafcount = 9;
        int logcount = 0;
        int prevleafcount = -1;
        int prevlogcount = -1;
        int highesty = 0;
        for (int y = 1; y <= 30 && (prevleafcount != leafcount || prevlogcount != logcount); ++y) {
            prevleafcount = leafcount;
            prevlogcount = logcount;
            Iterator it = BlockPos.func_218287_a((int)(pos.func_177958_n() - 2), (int)(pos.func_177956_o() + (y - 1)), (int)(pos.func_177952_p() - 2), (int)(pos.func_177958_n() + 2), (int)(pos.func_177956_o() + (y - 1)), (int)(pos.func_177952_p() + 2)).iterator();
            while (it.hasNext()) {
                BlockPos npos = (BlockPos)it.next();
                Block nblock = world.func_180495_p(npos).func_177230_c();
                if (CompareBlockFunctions.isTreeLeaf((Block)nblock, (boolean)((Boolean)ConfigHandler.GENERAL.enableNetherTrees.get())) || Util.isGiantMushroomLeafBlock(nblock)) {
                    --leafcount;
                    if (npos.func_177956_o() <= highesty) continue;
                    highesty = npos.func_177956_o();
                    continue;
                }
                if (!CompareBlockFunctions.isTreeLog((Block)nblock) && !Util.isGiantMushroomStemBlock(nblock)) continue;
                ++logcount;
            }
        }
        highestleaf.put(pos.func_185334_h(), highesty);
        if (leafcount < 0) {
            return logcount;
        }
        return -1;
    }

    public static List<BlockPos> getAllLogsToBreak(World world, BlockPos pos, int logcount, Block logtype) {
        Block blockbelow;
        CopyOnWriteArrayList<BlockPos> bottomlogs = new CopyOnWriteArrayList<BlockPos>();
        if (((Boolean)ConfigHandler.GENERAL.replaceSaplingOnTreeHarvest.get()).booleanValue() && (CompareBlockFunctions.isDirtBlock((Block)(blockbelow = world.func_180495_p(pos.func_177977_b()).func_177230_c())) || blockbelow instanceof MyceliumBlock)) {
            Iterator it = BlockPos.func_218287_a((int)(pos.func_177958_n() - 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() + 1)).iterator();
            while (it.hasNext()) {
                BlockPos npos = (BlockPos)it.next();
                Block block = world.func_180495_p(npos).func_177230_c();
                if (!block.equals(logtype)) continue;
                bottomlogs.add(npos.func_185334_h());
            }
        }
        if (((Boolean)ConfigHandler.GENERAL.replaceSaplingOnTreeHarvest.get()).booleanValue()) {
            if (((Boolean)ConfigHandler.GENERAL.instantBreakLeavesAround.get()).booleanValue()) {
                Util.replaceSapling(world, pos, bottomlogs, 1, null);
            } else if (((Boolean)ConfigHandler.GENERAL.enableFastLeafDecay.get()).booleanValue()) {
                lowerlogs.add((Pair<BlockPos, CopyOnWriteArrayList<BlockPos>>)new Pair((Object)pos.func_185334_h(), bottomlogs));
            }
        }
        return Util.getLogsToBreak(world, pos, new ArrayList<BlockPos>(), logcount, logtype);
    }

    public static void replaceSapling(World world, BlockPos pos, CopyOnWriteArrayList<BlockPos> bottomlogs, int radius, Item saplingitem) {
        int rc = bottomlogs.size();
        if (rc == 0) {
            return;
        }
        ItemStack sapling = null;
        for (Entity ea : world.func_72839_b(null, new AxisAlignedBB((double)(pos.func_177958_n() - radius), (double)(pos.func_177956_o() - 2), (double)(pos.func_177952_p() - radius), (double)(pos.func_177958_n() + radius), (double)(pos.func_177956_o() + 30), (double)(pos.func_177952_p() + radius)))) {
            int count;
            if (!(ea instanceof ItemEntity)) continue;
            ItemEntity eia = (ItemEntity)ea;
            ItemStack eisa = eia.func_92059_d();
            Item eisaitem = eisa.func_77973_b();
            if (saplingitem != null && !eisaitem.equals(saplingitem) || !CompareItemFunctions.isSapling((ItemStack)eisa) && (!((Boolean)ConfigHandler.GENERAL.replaceMushroomOnMushroomHarvest.get()).booleanValue() || !(Block.func_149634_a((Item)eisaitem) instanceof MushroomBlock))) continue;
            if (sapling == null) {
                sapling = eisa.func_77946_l();
                saplingitem = eisaitem;
            }
            if ((count = eisa.func_190916_E()) > 1) {
                for (int n = 0; n < count; ++n) {
                    eisa.func_190918_g(1);
                    if (--rc == 0) break;
                }
                eia.func_92058_a(eisa);
            } else {
                --rc;
                eia.func_70106_y();
            }
            if (rc != 0) continue;
            break;
        }
        int setsaplings = bottomlogs.size() - rc;
        for (BlockPos bottompos : bottomlogs) {
            if (setsaplings == 0) break;
            Block belowblock = world.func_180495_p(bottompos.func_177977_b()).func_177230_c();
            if (CompareBlockFunctions.isDirtBlock((Block)belowblock) || belowblock instanceof MyceliumBlock) {
                world.func_175656_a(bottompos, Block.func_149634_a((Item)sapling.func_77973_b()).func_176223_P());
                ForgeEventFactory.onBlockPlace(null, (BlockSnapshot)BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)bottompos), (Direction)Direction.UP);
            }
            --setsaplings;
            bottomlogs.remove(bottompos);
        }
        if (bottomlogs.size() > 0) {
            if (radius >= 5) {
                return;
            }
            Util.replaceSapling(world, pos, bottomlogs, radius + 2, saplingitem);
        }
    }

    private static List<BlockPos> getLogsToBreak(World world, BlockPos pos, List<BlockPos> logstobreak, int logcount, Block logtype) {
        ArrayList<Object> checkaround = new ArrayList<Object>();
        Iterator aroundlogs = BlockPos.func_218287_a((int)(pos.func_177958_n() - 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)(pos.func_177956_o() + 1), (int)(pos.func_177952_p() + 1)).iterator();
        while (aroundlogs.hasNext()) {
            BlockState blockState;
            Block logblock;
            BlockPos nalogpos = ((BlockPos)aroundlogs.next()).func_185334_h();
            if (logstobreak.contains(nalogpos) || !(logblock = (blockState = world.func_180495_p(nalogpos)).func_177230_c()).equals(logtype)) continue;
            checkaround.add(nalogpos);
            logstobreak.add(nalogpos);
            if (!((Boolean)ConfigHandler.GENERAL.instantBreakLeavesAround.get()).booleanValue()) continue;
            Pair<Integer, Integer> hv = Util.getHorizontalAndVerticalValue(world, pos, logtype, logcount);
            int h = (Integer)hv.getFirst();
            int v = (Integer)hv.getSecond();
            Iterator aroundleaves = BlockPos.func_218287_a((int)(pos.func_177958_n() - h), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - h), (int)(pos.func_177958_n() + h), (int)(pos.func_177956_o() + v), (int)(pos.func_177952_p() + h)).iterator();
            while (aroundleaves.hasNext()) {
                BlockPos naleafpos = (BlockPos)aroundleaves.next();
                Block leafblock = world.func_180495_p(naleafpos).func_177230_c();
                if (!CompareBlockFunctions.isTreeLeaf((Block)leafblock, (boolean)((Boolean)ConfigHandler.GENERAL.enableNetherTrees.get())) && !Util.isGiantMushroomLeafBlock(leafblock)) continue;
                world.func_175655_b(naleafpos, true);
            }
        }
        if (checkaround.size() == 0) {
            return logstobreak;
        }
        for (BlockPos blockPos : checkaround) {
            for (BlockPos logpos : Util.getLogsToBreak(world, blockPos, logstobreak, logcount, logtype)) {
                if (logstobreak.contains(logpos)) continue;
                logstobreak.add(logpos.func_185334_h());
            }
        }
        BlockPos up = pos.func_177981_b(2);
        return Util.getLogsToBreak(world, up.func_185334_h(), logstobreak, logcount, logtype);
    }

    public static Pair<Integer, Integer> getHorizontalAndVerticalValue(World world, BlockPos startpos, Block logtype, int logcount) {
        int h = 4;
        int v = 4;
        if (logtype.equals(Blocks.field_196621_O)) {
            h = 5;
            v = 5;
        } else if (Util.isGiantMushroomStemBlock(logtype)) {
            BlockPos temppos = startpos.func_185334_h();
            while (!Util.isGiantMushroomLeafBlock(world.func_180495_p(temppos.func_177984_a()).func_177230_c()) && temppos.func_177956_o() <= world.func_217301_I()) {
                temppos = temppos.func_177984_a().func_185334_h();
            }
            if (world.func_180495_p(temppos.func_177984_a()).func_177230_c().func_235697_s_().equals(MaterialColor.field_151645_D)) {
                h = 2;
                v = 2;
            } else {
                h = 3;
                v = 3;
            }
        } else if (logcount >= 20) {
            h = 5;
            v = 5;
        } else if (logcount >= 15) {
            h = 6;
            v = 7;
        } else if (logcount >= 10) {
            h = 4;
            v = 5;
        }
        return new Pair((Object)h, (Object)v);
    }

    public static boolean isGiantMushroomStemBlock(Block block) {
        if (!((Boolean)ConfigHandler.GENERAL.enableHugeMushrooms.get()).booleanValue()) {
            return false;
        }
        MaterialColor materialcolour = block.func_235697_s_();
        return block instanceof HugeMushroomBlock && materialcolour.equals(MaterialColor.field_151659_e);
    }

    public static boolean isGiantMushroomLeafBlock(Block block) {
        if (!((Boolean)ConfigHandler.GENERAL.enableHugeMushrooms.get()).booleanValue()) {
            return false;
        }
        MaterialColor materialcolour = block.func_235697_s_();
        return block instanceof HugeMushroomBlock && (materialcolour.equals(MaterialColor.field_151664_l) || materialcolour.equals(MaterialColor.field_151645_D));
    }

    public static Pair<Boolean, List<BlockPos>> isConnectedToLogs(World world, BlockPos startpos) {
        List recursiveList = BlockPosFunctions.getBlocksNextToEachOtherMaterial((World)world, (BlockPos)startpos, Arrays.asList(Material.field_151575_d, Material.field_151584_j), (int)6);
        for (BlockPos connectedpos : recursiveList) {
            Block connectedblock = world.func_180495_p(connectedpos).func_177230_c();
            if (!CompareBlockFunctions.isTreeLog((Block)connectedblock) && !Util.isGiantMushroomStemBlock(connectedblock)) continue;
            return new Pair((Object)true, (Object)recursiveList);
        }
        return new Pair((Object)false, (Object)recursiveList);
    }
}

