/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.functions.BlockFunctions;
import com.natamus.collective.functions.BlockPosFunctions;
import com.natamus.collective.functions.CompareBlockFunctions;
import com.natamus.collective.functions.ItemFunctions;
import com.natamus.collective.functions.ToolFunctions;
import com.natamus.collective.functions.WorldFunctions;
import com.natamus.treeharvester.config.ConfigHandler;
import com.natamus.treeharvester.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;

@Mod.EventBusSubscriber
public class TreeEvent {
    private static boolean setupBlacklistRan = false;
    private static HashMap<World, CopyOnWriteArrayList<List<BlockPos>>> processleaves = new HashMap();
    private static HashMap<Pair<World, BlockPos>, Pair<Date, Integer>> harvestSpeedCache = new HashMap();

    @SubscribeEvent
    public void onServerStart(FMLServerStartedEvent e) {
        if (setupBlacklistRan) {
            return;
        }
        setupBlacklistRan = true;
        try {
            Util.setupAxeBlacklist();
        }
        catch (Exception ex) {
            System.out.println("[Tree Harvester] Something went wrong setting up the axe blacklist file.");
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        processleaves.put(world, new CopyOnWriteArrayList());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        World world = e.world;
        if (world.field_72995_K || !e.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (processleaves.get(world).size() == 0) {
            return;
        }
        block0: for (List<BlockPos> leaves : processleaves.get(world)) {
            BlockPos lasttr = null;
            int size = leaves.size();
            if (size > 0) {
                for (int i = 0; i < (Integer)ConfigHandler.GENERAL.amountOfLeavesBrokenPerTick.get() && !leaves.isEmpty(); ++i) {
                    BlockPos tr = leaves.get(0);
                    BlockFunctions.dropBlock((World)world, (BlockPos)tr);
                    leaves.remove(0);
                    lasttr = tr.func_185334_h();
                }
            }
            if (leaves.size() != 0) continue;
            processleaves.get(world).remove(leaves);
            if (lasttr == null || !((Boolean)ConfigHandler.GENERAL.replaceSaplingOnTreeHarvest.get()).booleanValue() || Util.lowerlogs.size() <= 0) continue;
            BlockPos lowerlasttrpos = new BlockPos(lasttr.func_177958_n(), 1, lasttr.func_177952_p());
            for (Pair<BlockPos, CopyOnWriteArrayList<BlockPos>> pair : Util.lowerlogs) {
                BlockPos breakpos = (BlockPos)pair.getFirst();
                if (!BlockPosFunctions.withinDistance((BlockPos)lowerlasttrpos, (BlockPos)new BlockPos(breakpos.func_177958_n(), 1, breakpos.func_177952_p()), (int)5).booleanValue()) continue;
                Util.replaceSapling(world, breakpos, (CopyOnWriteArrayList)pair.getSecond(), 1, null);
                Util.lowerlogs.remove(pair);
                continue block0;
            }
        }
    }

    @SubscribeEvent
    public void onTreeHarvest(BlockEvent.BreakEvent e) {
        int logcount;
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        BlockPos bpos = e.getPos();
        Block block = world.func_180495_p(bpos).func_177230_c();
        if (!CompareBlockFunctions.isTreeLog((Block)block) && !Util.isGiantMushroomStemBlock(block)) {
            return;
        }
        PlayerEntity player = e.getPlayer();
        if ((Boolean)ConfigHandler.GENERAL.treeHarvestWithoutSneak.get() != false ? player.func_225608_bj_() : !player.func_225608_bj_()) {
            return;
        }
        ItemStack hand = player.func_184586_b(Hand.MAIN_HAND);
        Item handitem = hand.func_77973_b();
        if (((Boolean)ConfigHandler.GENERAL.mustHoldAxeForTreeHarvest.get()).booleanValue()) {
            if (!ToolFunctions.isAxe((ItemStack)hand).booleanValue()) {
                return;
            }
            if (!Util.allowedAxes.contains(handitem)) {
                return;
            }
        }
        if (((Boolean)ConfigHandler.GENERAL.automaticallyFindBottomBlock.get()).booleanValue()) {
            BlockPos temppos = bpos.func_185334_h();
            while (world.func_180495_p(temppos.func_177977_b()).func_177230_c().equals(block)) {
                temppos = temppos.func_177977_b().func_185334_h();
            }
            for (BlockPos belowpos : BlockPos.func_191531_b((int)(temppos.func_177958_n() - 1), (int)(temppos.func_177956_o() - 1), (int)(temppos.func_177952_p() - 1), (int)(temppos.func_177958_n() + 1), (int)(temppos.func_177956_o() - 1), (int)(temppos.func_177952_p() + 1))) {
                if (!world.func_180495_p(belowpos).func_177230_c().equals(block)) continue;
                temppos = belowpos.func_185334_h();
                while (world.func_180495_p(temppos.func_177977_b()).func_177230_c().equals(block)) {
                    temppos = temppos.func_177977_b().func_185334_h();
                }
                break block1;
            }
            bpos = temppos.func_185334_h();
        }
        if ((logcount = Util.isTreeAndReturnLogAmount(world, bpos)) < 0) {
            return;
        }
        int durabilitylosecount = (int)Math.ceil(1.0 / (Double)ConfigHandler.GENERAL.loseDurabilityModifier.get());
        int durabilitystartcount = -1;
        ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
        BlockPos highestlog = bpos.func_185334_h();
        List<BlockPos> logstobreak = Util.getAllLogsToBreak(world, bpos, logcount, block);
        for (BlockPos logpos : logstobreak) {
            Object logstate;
            Block log;
            if (logpos.func_177956_o() > highestlog.func_177956_o()) {
                highestlog = logpos.func_185334_h();
            }
            if (!(log = (logstate = world.func_180495_p(logpos)).func_177230_c()).canHarvestBlock((BlockState)logstate, (IBlockReader)world, logpos, player)) continue;
            BlockFunctions.dropBlock((World)world, (BlockPos)logpos);
            ForgeEventFactory.onEntityDestroyBlock((LivingEntity)player, (BlockPos)logpos, (BlockState)logstate);
            if (player.func_184812_l_()) continue;
            if (((Boolean)ConfigHandler.GENERAL.loseDurabilityPerHarvestedLog.get()).booleanValue()) {
                if (durabilitystartcount == -1) {
                    durabilitystartcount = durabilitylosecount;
                    ItemFunctions.itemHurtBreakAndEvent((ItemStack)hand, (ServerPlayerEntity)serverPlayerEntity, (Hand)Hand.MAIN_HAND, (int)1);
                } else if (--durabilitylosecount == 0) {
                    ItemFunctions.itemHurtBreakAndEvent((ItemStack)hand, (ServerPlayerEntity)serverPlayerEntity, (Hand)Hand.MAIN_HAND, (int)1);
                    durabilitylosecount = durabilitystartcount;
                }
            }
            if (!((Boolean)ConfigHandler.GENERAL.increaseExhaustionPerHarvestedLog.get()).booleanValue()) continue;
            player.func_71020_j(0.025f * ((Double)ConfigHandler.GENERAL.increaseExhaustionModifier.get()).floatValue());
        }
        if (logstobreak.size() == 0) {
            return;
        }
        e.setCanceled(true);
        if (((Boolean)ConfigHandler.GENERAL.enableFastLeafDecay.get()).booleanValue() && !((Boolean)ConfigHandler.GENERAL.instantBreakLeavesAround.get()).booleanValue()) {
            ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
            ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
            for (BlockPos next : BlockPos.func_191531_b((int)(bpos.func_177958_n() - 8), (int)bpos.func_177956_o(), (int)(bpos.func_177952_p() - 8), (int)(bpos.func_177958_n() + 8), (int)Util.highestleaf.get(bpos), (int)(bpos.func_177952_p() + 8))) {
                Block nextblock = world.func_180495_p(next).func_177230_c();
                if (!CompareBlockFunctions.isTreeLog((Block)nextblock) && !Util.isGiantMushroomStemBlock(nextblock) || !nextblock.equals(block)) continue;
                logs.add(next.func_185334_h());
            }
            Pair<Integer, Integer> hv = Util.getHorizontalAndVerticalValue(world, bpos, block, logcount);
            int h = (Integer)hv.getFirst();
            CopyOnWriteArrayList<BlockPos> leftoverleaves = new CopyOnWriteArrayList<BlockPos>();
            Block leafblock = world.func_180495_p(highestlog.func_177984_a()).func_177230_c();
            for (BlockPos next : BlockPos.func_191531_b((int)(bpos.func_177958_n() - h), (int)bpos.func_177956_o(), (int)(bpos.func_177952_p() - h), (int)(bpos.func_177958_n() + h), (int)Util.highestleaf.get(bpos), (int)(bpos.func_177952_p() + h))) {
                Block nextblock = world.func_180495_p(next).func_177230_c();
                if (!leafblock.equals(nextblock) && (!((Boolean)ConfigHandler.GENERAL.enableNetherTrees.get()).booleanValue() || !nextblock.equals(Blocks.field_235383_mw_)) || !CompareBlockFunctions.isTreeLeaf((Block)nextblock, (boolean)((Boolean)ConfigHandler.GENERAL.enableNetherTrees.get())) && !Util.isGiantMushroomLeafBlock(nextblock)) continue;
                boolean logclose = false;
                for (BlockPos log : logs) {
                    double distance = log.func_177951_i((Vector3i)next);
                    if (!BlockPosFunctions.withinDistance((BlockPos)log, (BlockPos)next, (int)3).booleanValue()) continue;
                    logclose = true;
                    break;
                }
                if (!logclose) {
                    leaves.add(next.func_185334_h());
                    continue;
                }
                leftoverleaves.add(next.func_185334_h());
            }
            for (BlockPos leftoverleaf : leftoverleaves) {
                if (leftoverleaves.isEmpty()) break;
                Pair<Boolean, List<BlockPos>> connectedpair = Util.isConnectedToLogs(world, leftoverleaf);
                if (((Boolean)connectedpair.getFirst()).booleanValue()) {
                    for (BlockPos connectedpos : (List)connectedpair.getSecond()) {
                        leftoverleaves.remove(connectedpos);
                    }
                    continue;
                }
                for (BlockPos connectedpos : (List)connectedpair.getSecond()) {
                    if (!leaves.contains(connectedpos)) {
                        leaves.add(connectedpos.func_185334_h());
                    }
                    leftoverleaves.remove(connectedpos);
                }
            }
            Collections.shuffle(leaves);
            processleaves.get(world).add(leaves);
            Util.highestleaf.remove(bpos);
            if (((Boolean)ConfigHandler.GENERAL.increaseHarvestingTimePerLog.get()).booleanValue()) {
                Pair keypair = new Pair((Object)world, (Object)bpos);
                harvestSpeedCache.remove(keypair);
            }
        }
    }

    @SubscribeEvent
    public void onHarvestBreakSpeed(PlayerEvent.BreakSpeed e) {
        BlockPos bpos;
        if (!((Boolean)ConfigHandler.GENERAL.increaseHarvestingTimePerLog.get()).booleanValue()) {
            return;
        }
        PlayerEntity player = e.getPlayer();
        World world = player.func_130014_f_();
        Block block = world.func_180495_p(bpos = e.getPos()).func_177230_c();
        if (!CompareBlockFunctions.isTreeLog((Block)block) && !Util.isGiantMushroomStemBlock(block)) {
            return;
        }
        if ((Boolean)ConfigHandler.GENERAL.treeHarvestWithoutSneak.get() != false ? player.func_225608_bj_() : !player.func_225608_bj_()) {
            return;
        }
        ItemStack hand = player.func_184586_b(Hand.MAIN_HAND);
        Item handitem = hand.func_77973_b();
        if (((Boolean)ConfigHandler.GENERAL.mustHoldAxeForTreeHarvest.get()).booleanValue()) {
            if (!ToolFunctions.isAxe((ItemStack)hand).booleanValue()) {
                return;
            }
            if (!Util.allowedAxes.contains(handitem)) {
                return;
            }
        }
        int logcount = -1;
        Date now = new Date();
        Pair keypair = new Pair((Object)world, (Object)bpos);
        if (harvestSpeedCache.containsKey(keypair)) {
            Pair<Date, Integer> valuepair = harvestSpeedCache.get(keypair);
            long ms = now.getTime() - ((Date)valuepair.getFirst()).getTime();
            if (ms < 5000L) {
                logcount = (Integer)valuepair.getSecond();
            } else {
                harvestSpeedCache.remove(keypair);
            }
        }
        if (logcount < 0) {
            if (Util.isTreeAndReturnLogAmount(world, bpos) < 0) {
                return;
            }
            logcount = BlockPosFunctions.getBlocksNextToEachOtherMaterial((World)world, (BlockPos)bpos, Arrays.asList(Material.field_151575_d), (int)30).size();
            if (logcount <= 0) {
                return;
            }
            harvestSpeedCache.put((Pair<World, BlockPos>)keypair, (Pair<Date, Integer>)new Pair((Object)now, (Object)logcount));
        }
        e.setNewSpeed(e.getOriginalSpeed() / (1.0f + (float)logcount * ((Double)ConfigHandler.GENERAL.increasedHarvestingTimePerLogModifier.get()).floatValue()));
    }
}

