/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.schematic;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.schematic.ParsedSchematicObject;
import com.natamus.collective.schematic.Schematic;
import com.natamus.collective.schematic.SchematicBlockObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ParseSchematicFile {
    public static ParsedSchematicObject getParsedSchematicObject(InputStream schematicInputStream, World level, BlockPos centerPos, int extraYOffset, boolean skipAir) {
        return ParseSchematicFile.getParsedSchematicObject(schematicInputStream, level, centerPos, extraYOffset, skipAir, true);
    }

    public static ParsedSchematicObject getParsedSchematicObject(InputStream schematicInputStream, World level, BlockPos centerPos, int extraYOffset, boolean skipAir, boolean automaticCenter) {
        Schematic schematic = new Schematic(schematicInputStream);
        int maxBuildHeight = level.func_217301_I();
        short length = schematic.getLength();
        short width = schematic.getWidth();
        short height = schematic.getHeight();
        int xoffset = schematic.getOffsetX();
        int yoffset = centerPos.func_177956_o() + extraYOffset;
        int zoffset = schematic.getOffsetZ();
        if (automaticCenter) {
            xoffset = -(width / 2);
            if (yoffset + height > maxBuildHeight) {
                yoffset = maxBuildHeight - height;
            }
            zoffset = -(length / 2);
        } else {
            yoffset += schematic.getOffsetY();
        }
        ArrayList<Pair<BlockPos, BlockState>> blocks = new ArrayList<Pair<BlockPos, BlockState>>();
        for (SchematicBlockObject blockObject : schematic.getBlocks()) {
            if (blockObject == null) continue;
            BlockState blockState = blockObject.getState();
            if (skipAir && blockState.func_177230_c().equals(Blocks.field_150350_a)) continue;
            blocks.add(new Pair((Object)blockObject.getPosition().func_177982_a(centerPos.func_177958_n() + xoffset, yoffset, centerPos.func_177952_p() + zoffset).func_185334_h(), (Object)blockState));
        }
        ArrayList<Pair<BlockPos, Entity>> entities = new ArrayList<Pair<BlockPos, Entity>>();
        for (Pair<BlockPos, CompoundNBT> rawEntityPair : schematic.getEntityRelativePosPairs()) {
            Optional optionalNewEntity = EntityType.func_220330_a((CompoundNBT)((CompoundNBT)rawEntityPair.getSecond()), (World)level);
            if (!optionalNewEntity.isPresent()) continue;
            BlockPos actualEntityPosition = ((BlockPos)rawEntityPair.getFirst()).func_177982_a(centerPos.func_177958_n() + xoffset, yoffset, centerPos.func_177952_p() + zoffset).func_185334_h();
            Entity newEntity = (Entity)optionalNewEntity.get();
            newEntity.func_70107_b((double)actualEntityPosition.func_177958_n() + 0.5, (double)actualEntityPosition.func_177956_o(), (double)actualEntityPosition.func_177952_p() + 0.5);
            entities.add((Pair<BlockPos, Entity>)new Pair((Object)actualEntityPosition, (Object)newEntity));
        }
        ArrayList<BlockPos> blockEntityPositions = new ArrayList<BlockPos>();
        for (CompoundNBT blockEntityCompoundTag : schematic.getBlockEntities()) {
            blockEntityPositions.add(schematic.getBlockPosFromCompoundTag(blockEntityCompoundTag).func_177982_a(centerPos.func_177958_n() + xoffset, yoffset, centerPos.func_177952_p() + zoffset));
        }
        return new ParsedSchematicObject(schematic, blocks, entities, blockEntityPositions, "Parsed successfully.", true);
    }
}

