/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.config.ConfigHandler;
import com.natamus.collective.data.GlobalVariables;
import com.natamus.collective.functions.BlockFunctions;
import com.natamus.collective.functions.ToolFunctions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemFunctions {
    public static void generateEntityDropsFromLootTable(World world) {
        MinecraftServer server = world.func_73046_m();
        if (server == null) {
            return;
        }
        GlobalVariables.entitydrops = new HashMap();
        FakePlayer fakeplayer = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        Vector3d vec = new Vector3d(0.0, 0.0, 0.0);
        ItemStack lootingsword = new ItemStack((IItemProvider)Items.field_151048_u, 1);
        lootingsword.func_77966_a(Enchantments.field_185304_p, 10);
        fakeplayer.func_184201_a(EquipmentSlotType.MAINHAND, lootingsword);
        Collection entitytypes = ForgeRegistries.ENTITIES.getValues();
        for (EntityType type : entitytypes) {
            Entity entity;
            if (type == null || !((entity = type.func_200721_a(world)) instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)entity;
            ResourceLocation lootlocation = le.func_200600_R().func_220348_g();
            LootTable loottable = server.func_200249_aQ().func_186521_a(lootlocation);
            LootContext context = new LootContext.Builder((ServerWorld)world).func_216023_a(world.func_201674_k()).func_186469_a(1000000.0f).func_216015_a(LootParameters.field_216281_a, (Object)entity).func_216015_a(LootParameters.field_237457_g_, (Object)vec).func_216015_a(LootParameters.field_216284_d, (Object)fakeplayer).func_216015_a(LootParameters.field_216283_c, (Object)DamageSource.func_76365_a((PlayerEntity)fakeplayer)).func_216022_a(LootParameterSets.field_216263_d);
            ArrayList<Item> alldrops = new ArrayList<Item>();
            for (int n = 0; n < (Integer)ConfigHandler.COLLECTIVE.loopsAmountUsedToGetAllEntityDrops.get(); ++n) {
                List newdrops = loottable.func_216113_a(context);
                for (ItemStack newdrop : newdrops) {
                    Item newitem = newdrop.func_77973_b();
                    if (alldrops.contains(newitem) || newitem.equals(Items.field_190931_a)) continue;
                    alldrops.add(newitem);
                }
            }
            GlobalVariables.entitydrops.put(type, alldrops);
        }
    }

    public static Boolean isTool(ItemStack itemstack) {
        return ToolFunctions.isTool(itemstack);
    }

    public static void shrinkGiveOrDropItemStack(PlayerEntity player, Hand hand, ItemStack used, ItemStack give) {
        used.func_190918_g(1);
        if (used.func_190926_b()) {
            Item giveitem = give.func_77973_b();
            int maxstacksize = give.func_77976_d();
            NonNullList inventory = player.field_71071_by.field_70462_a;
            boolean increased = false;
            for (ItemStack slot : inventory) {
                int slotcount;
                if (!slot.func_77973_b().equals(giveitem) || (slotcount = slot.func_190916_E()) >= maxstacksize) continue;
                slot.func_190920_e(slotcount + 1);
                increased = true;
                break;
            }
            if (!increased) {
                player.func_184611_a(hand, give);
            }
        } else if (!player.field_71071_by.func_70441_a(give)) {
            player.func_71019_a(give, false);
        }
    }

    public static void giveOrDropItemStack(PlayerEntity player, ItemStack give) {
        if (!player.field_71071_by.func_70441_a(give)) {
            player.func_71019_a(give, false);
        }
    }

    public static void itemHurtBreakAndEvent(ItemStack itemStack, ServerPlayerEntity player, Hand hand, int damage) {
        if (!player.field_71075_bZ.field_75098_d && itemStack.func_77984_f() && itemStack.func_96631_a(damage = itemStack.func_77973_b().damageItem(itemStack, damage, (LivingEntity)player, player1 -> player1.func_213334_d(hand)), player.func_70681_au(), player)) {
            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)itemStack, (Hand)hand);
            Item item = itemStack.func_77973_b();
            itemStack.func_190918_g(1);
            itemStack.func_196085_b(0);
            player.func_71029_a(Stats.field_199088_e.func_199076_b((Object)item));
        }
    }

    public static boolean isStoneTypeItem(Item item) {
        return GlobalVariables.stoneblockitems.contains(item);
    }

    public static String itemToReadableString(Item item, int amount) {
        String translationkey = item.func_77658_a();
        if (translationkey.contains("block.")) {
            return BlockFunctions.blockToReadableString(Block.func_149634_a((Item)item), amount);
        }
        String[] itemspl = translationkey.replace("item.", "").split("\\.");
        String itemstring = itemspl.length > 1 ? itemspl[1] : itemspl[0];
        itemstring = itemstring.replace("_", " ");
        if (amount > 1) {
            itemstring = itemstring + "s";
        }
        return itemstring;
    }

    public static String itemToReadableString(Item item) {
        return ItemFunctions.itemToReadableString(item, 1);
    }

    public static String getNBTStringFromItemStack(ItemStack itemStack) {
        return ItemFunctions.getNBTStringFromItemStack(itemStack, true);
    }

    public static String getNBTStringFromItemStack(ItemStack itemStack, boolean shouldSanitize) {
        CompoundNBT nbt = new CompoundNBT();
        nbt = itemStack.func_77955_b(nbt);
        String nbtstring = nbt.toString();
        if (shouldSanitize) {
            nbtstring = nbtstring.replace(" : ", ": ");
        }
        return nbtstring;
    }
}

