/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.util;

import com.mrcrayfish.backpacked.Config;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class PickpocketUtil {
    public static Vector3d getEntityPos(Entity entity, float partialTick) {
        double x = MathHelper.func_219803_d((double)partialTick, (double)entity.field_70169_q, (double)entity.func_226277_ct_());
        double y = MathHelper.func_219803_d((double)partialTick, (double)entity.field_70167_r, (double)entity.func_226278_cu_());
        double z = MathHelper.func_219803_d((double)partialTick, (double)entity.field_70166_s, (double)entity.func_226281_cx_());
        return new Vector3d(x, y, z);
    }

    public static AxisAlignedBB getBackpackBox(LivingEntity entity, float partialTick) {
        AxisAlignedBB backpackBox = new AxisAlignedBB(-0.25, 0.0, -0.25, 0.25, 0.5625, 0.25);
        backpackBox = backpackBox.func_191194_a(PickpocketUtil.getEntityPos((Entity)entity, partialTick));
        backpackBox = backpackBox.func_72317_d(0.0, entity.func_213283_Z() != Pose.SWIMMING ? 0.875 : 0.3125, 0.0);
        if (entity.func_213283_Z() == Pose.CROUCHING) {
            backpackBox = backpackBox.func_72317_d(0.0, -0.1875, 0.0);
        }
        float bodyRotation = MathHelper.func_219799_g((float)partialTick, (float)entity.field_70760_ar, (float)entity.field_70761_aq);
        backpackBox = backpackBox.func_191194_a(Vector3d.func_189986_a((float)0.0f, (float)(bodyRotation + 180.0f)).func_186678_a(entity.func_213283_Z() != Pose.SWIMMING ? 0.3125 : -0.125));
        return backpackBox;
    }

    public static boolean canPickpocketEntity(LivingEntity targetEntity, PlayerEntity thiefPlayer) {
        return PickpocketUtil.canPickpocketEntity(targetEntity, thiefPlayer, (Double)Config.SERVER.pickpocketMaxReachDistance.get());
    }

    public static boolean canPickpocketEntity(LivingEntity targetEntity, PlayerEntity thiefPlayer, double range) {
        return PickpocketUtil.inRangeOfBackpack(targetEntity, thiefPlayer) && PickpocketUtil.inReachOfBackpack(targetEntity, thiefPlayer, range);
    }

    public static boolean inRangeOfBackpack(LivingEntity targetEntity, PlayerEntity thiefPlayer) {
        if (targetEntity.func_213283_Z() == Pose.SWIMMING) {
            return true;
        }
        Vector3d between = PickpocketUtil.getEntityPos((Entity)thiefPlayer, 1.0f).func_178788_d(PickpocketUtil.getEntityPos((Entity)targetEntity, 1.0f));
        float angle = (float)Math.toDegrees(Math.atan2(between.field_72449_c, between.field_72450_a)) - 90.0f;
        float difference = MathHelper.func_203301_d((float)(targetEntity.field_70761_aq + 180.0f), (float)angle);
        return (double)difference <= (Double)Config.SERVER.pickpocketMaxRangeAngle.get();
    }

    public static boolean inReachOfBackpack(LivingEntity targetPlayer, PlayerEntity thiefPlayer, double reachDistance) {
        Vector3d pos = PickpocketUtil.getEntityPos((Entity)targetPlayer, 1.0f);
        pos = pos.func_178787_e(Vector3d.func_189986_a((float)0.0f, (float)(targetPlayer.field_70761_aq + 180.0f)).func_186678_a(targetPlayer.func_213283_Z() != Pose.SWIMMING ? 0.3125 : -0.125));
        return pos.func_72438_d(PickpocketUtil.getEntityPos((Entity)thiefPlayer, 1.0f)) <= reachDistance;
    }

    public static boolean canSeeBackpack(LivingEntity targetEntity, PlayerEntity thiefPlayer) {
        Vector3d end;
        Vector3d start;
        if ((double)targetEntity.func_70032_d((Entity)targetEntity) > 4.0) {
            return false;
        }
        AxisAlignedBB backpackBox = PickpocketUtil.getBackpackBox(targetEntity, 1.0f);
        Optional hitPos = backpackBox.func_216365_b(start = thiefPlayer.func_174824_e(1.0f), end = thiefPlayer.func_70676_i(1.0f).func_186678_a(((Double)Config.SERVER.pickpocketMaxReachDistance.get()).doubleValue()).func_178787_e(start));
        if (!hitPos.isPresent()) {
            return false;
        }
        BlockRayTraceResult result = thiefPlayer.field_70170_p.func_217299_a(new RayTraceContext(start, (Vector3d)hitPos.get(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)thiefPlayer));
        if (result.func_216346_c() == RayTraceResult.Type.MISS) {
            return true;
        }
        return start.func_72438_d((Vector3d)hitPos.get()) < start.func_72438_d(result.func_216347_e());
    }
}

