/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.message;

import com.mrcrayfish.backpacked.network.message.IMessage;
import com.mrcrayfish.backpacked.network.play.ClientPlayHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageOpenCustomisation
implements IMessage<MessageOpenCustomisation> {
    private Map<ResourceLocation, ITextComponent> map;

    public MessageOpenCustomisation() {
    }

    public MessageOpenCustomisation(Map<ResourceLocation, ITextComponent> map) {
        this.map = map;
    }

    @Override
    public void encode(MessageOpenCustomisation message, PacketBuffer buffer) {
        buffer.writeInt(message.map.size());
        message.map.forEach((location, formattedProgress) -> {
            buffer.func_192572_a(location);
            buffer.func_179256_a(formattedProgress);
        });
    }

    @Override
    public MessageOpenCustomisation decode(PacketBuffer buffer) {
        HashMap<ResourceLocation, ITextComponent> map = new HashMap<ResourceLocation, ITextComponent>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buffer.func_192575_l();
            ITextComponent formattedProgress = buffer.func_179258_d();
            map.put(id, formattedProgress);
        }
        return new MessageOpenCustomisation(map);
    }

    @Override
    public void handle(MessageOpenCustomisation message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> ClientPlayHandler.handleOpenCustomisation(message));
        supplier.get().setPacketHandled(true);
    }

    public Map<ResourceLocation, ITextComponent> getProgressMap() {
        return this.map;
    }
}

