/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.mixin.common;

import com.mrcrayfish.backpacked.common.UnlockTracker;
import com.mrcrayfish.backpacked.common.backpack.SheepPlushBackpack;
import com.mrcrayfish.backpacked.common.tracker.CountProgressTracker;
import java.util.List;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SheepEntity.class})
public class SheepEntityMixin {
    @Inject(method={"onSheared"}, at={@At(value="HEAD")}, remap=false)
    public void trackShearProgress(PlayerEntity player, ItemStack item, World world, BlockPos pos, int fortune, CallbackInfoReturnable<List<ItemStack>> cir) {
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        UnlockTracker.get(player).ifPresent(unlockTracker -> unlockTracker.getProgressTracker(SheepPlushBackpack.ID).ifPresent(progressTracker -> {
            CountProgressTracker tracker = (CountProgressTracker)progressTracker;
            tracker.increment((ServerPlayerEntity)player);
        }));
    }
}

