/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory.container;

import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.inventory.container.slot.BackpackSlot;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class BackpackContainer
extends Container {
    public static final int MAX_COLUMNS = 13;
    public static final int MAX_ROWS = 7;
    private final IInventory backpackInventory;
    private final int cols;
    private final int rows;
    private final boolean owner;

    public BackpackContainer(int id, PlayerInventory playerInventory, int cols, int rows, boolean owner) {
        this(id, playerInventory, (IInventory)new Inventory(MathHelper.func_76125_a((int)cols, (int)1, (int)13) * MathHelper.func_76125_a((int)rows, (int)1, (int)7)), cols, rows, owner);
    }

    public BackpackContainer(int id, PlayerInventory playerInventory, IInventory backpackInventory, int cols, int rows, boolean owner) {
        super((ContainerType)ModContainers.BACKPACK.get(), id);
        int i;
        this.backpackInventory = backpackInventory;
        this.cols = MathHelper.func_76125_a((int)cols, (int)1, (int)13);
        this.rows = MathHelper.func_76125_a((int)rows, (int)1, (int)7);
        this.owner = owner;
        BackpackContainer.func_216962_a((IInventory)backpackInventory, (int)(this.cols * this.rows));
        backpackInventory.func_174889_b(playerInventory.field_70458_d);
        int playerInventoryOffset = this.rows * 18 + 17 + 14 + 1;
        int backpackSlotWidth = this.cols * 18;
        int minSlotWidth = 162;
        int backpackStartX = Math.max((minSlotWidth - backpackSlotWidth) / 2, 0);
        int inventoryStartX = Math.max((backpackSlotWidth - minSlotWidth) / 2, 0);
        for (int j = 0; j < rows; ++j) {
            for (int i2 = 0; i2 < cols; ++i2) {
                this.func_75146_a(new BackpackSlot(backpackInventory, i2 + j * cols, 8 + backpackStartX + i2 * 18, 18 + j * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + inventoryStartX + j * 18, i * 18 + playerInventoryOffset));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, 8 + inventoryStartX + i * 18, playerInventoryOffset + 58));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.backpackInventory.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack copy = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            copy = slotStack.func_77946_l();
            if (index < this.rows * this.cols ? !this.func_75135_a(slotStack, this.rows * this.cols, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, this.rows * this.cols, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return copy;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.backpackInventory.func_174886_c(playerIn);
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isOwner() {
        return this.owner;
    }
}

