/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.tracker;

import com.mrcrayfish.backpacked.common.IProgressTracker;
import com.mrcrayfish.backpacked.common.ProgressFormatters;
import java.util.function.Predicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="backpacked")
public class CraftingProgressTracker
implements IProgressTracker {
    protected int count;
    protected final int totalCount;
    protected final Predicate<ItemStack> predicate;

    public CraftingProgressTracker(int totalCount, Predicate<ItemStack> predicate) {
        this.totalCount = totalCount;
        this.predicate = predicate;
    }

    public void processCrafted(ItemStack stack, ServerPlayerEntity player) {
        if (this.predicate.test(stack)) {
            this.count += stack.func_190916_E();
            this.markForCompletionTest(player);
        }
    }

    @Override
    public boolean isComplete() {
        return this.count >= this.totalCount;
    }

    @Override
    public void read(CompoundNBT tag) {
        this.count = tag.func_74762_e("Count");
    }

    @Override
    public void write(CompoundNBT tag) {
        tag.func_74768_a("Count", this.count);
    }

    @Override
    public ITextComponent getDisplayComponent() {
        return ProgressFormatters.CRAFT_X_OF_X.apply(this.count, this.totalCount);
    }
}

