/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.tracker;

import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.backpacked.common.IProgressTracker;
import com.mrcrayfish.backpacked.common.ProgressFormatters;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.biome.Biome;

public class BiomeExploreProgressTracker
implements IProgressTracker {
    private final ImmutableSet<RegistryKey<Biome>> biomes;
    private final Set<ResourceLocation> exploredBiomes = new HashSet<ResourceLocation>();

    @SafeVarargs
    public BiomeExploreProgressTracker(RegistryKey<Biome> ... biomes) {
        this.biomes = ImmutableSet.copyOf(Arrays.asList(biomes));
    }

    public void explore(RegistryKey<Biome> biome, ServerPlayerEntity player) {
        if (this.biomes.contains(biome)) {
            this.exploredBiomes.add(biome.func_240901_a_());
            this.markForCompletionTest(player);
        }
    }

    @Override
    public boolean isComplete() {
        return this.exploredBiomes.size() >= this.biomes.size();
    }

    @Override
    public void read(CompoundNBT tag) {
        this.exploredBiomes.clear();
        ListNBT list = tag.func_150295_c("ExploredBiomes", 8);
        list.forEach(nbt -> {
            ResourceLocation id = ResourceLocation.func_208304_a((String)nbt.func_150285_a_());
            if (id != null && this.biomes.stream().anyMatch(key -> key.func_240901_a_().equals((Object)id))) {
                this.exploredBiomes.add(id);
            }
        });
    }

    @Override
    public void write(CompoundNBT tag) {
        ListNBT list = new ListNBT();
        this.exploredBiomes.forEach(location -> list.add((Object)StringNBT.func_229705_a_((String)location.toString())));
        tag.func_218657_a("ExploredBiomes", (INBT)list);
    }

    @Override
    public ITextComponent getDisplayComponent() {
        return ProgressFormatters.EXPLORED_X_OF_X.apply(this.exploredBiomes.size(), this.biomes.size());
    }
}

