/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="backpacked")
public class PickpocketChallenge {
    @CapabilityInject(value=PickpocketChallenge.class)
    public static final Capability<PickpocketChallenge> PICKPOCKET_CAPABILITY = null;
    private boolean initialized = false;
    private boolean backpack = false;
    private boolean spawnedLoot = false;
    private final Map<PlayerEntity, Long> detectedPlayers = new HashMap<PlayerEntity, Long>();
    private final Map<UUID, Long> dislikedPlayers = new HashMap<UUID, Long>();

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized() {
        this.initialized = true;
    }

    public void setBackpackEquipped(boolean equipped) {
        this.backpack = equipped;
    }

    public boolean isBackpackEquipped() {
        return this.backpack;
    }

    public boolean isLootSpawned() {
        return this.spawnedLoot;
    }

    public void setLootSpawned() {
        this.spawnedLoot = true;
    }

    public Map<PlayerEntity, Long> getDetectedPlayers() {
        return this.detectedPlayers;
    }

    public boolean isDislikedPlayer(PlayerEntity player) {
        return this.dislikedPlayers.containsKey(player.func_110124_au());
    }

    public void addDislikedPlayer(PlayerEntity player, long time) {
        this.dislikedPlayers.put(player.func_110124_au(), time);
    }

    public Map<UUID, Long> getDislikedPlayers() {
        return this.dislikedPlayers;
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(PickpocketChallenge.class, (Capability.IStorage)new Storage(), PickpocketChallenge::new);
    }

    public static Optional<PickpocketChallenge> get(LivingEntity entity) {
        return entity.getCapability(PICKPOCKET_CAPABILITY).resolve();
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof WanderingTraderEntity) {
            Provider provider = new Provider();
            event.addCapability(new ResourceLocation("backpacked", "pickpocket_challenge"), (ICapabilityProvider)provider);
            event.addListener(provider::invalidate);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        private final PickpocketChallenge instance = new PickpocketChallenge();
        private final LazyOptional<PickpocketChallenge> optional = LazyOptional.of(() -> this.instance);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PICKPOCKET_CAPABILITY.orEmpty(cap, this.optional.cast());
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)PICKPOCKET_CAPABILITY.writeNBT((Object)this.instance, null);
        }

        public void deserializeNBT(CompoundNBT tag) {
            PICKPOCKET_CAPABILITY.readNBT((Object)this.instance, null, (INBT)tag);
        }

        public void invalidate() {
            this.optional.invalidate();
        }
    }

    public static class Storage
    implements Capability.IStorage<PickpocketChallenge> {
        @Nullable
        public INBT writeNBT(Capability<PickpocketChallenge> capability, PickpocketChallenge instance, Direction side) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("Initialized", instance.initialized);
            tag.func_74757_a("EquippedBackpack", instance.backpack);
            tag.func_74757_a("SpawnedLoot", instance.spawnedLoot);
            return tag;
        }

        public void readNBT(Capability<PickpocketChallenge> capability, PickpocketChallenge instance, Direction side, INBT nbt) {
            CompoundNBT tag = (CompoundNBT)nbt;
            instance.initialized = tag.func_74767_n("Initialized");
            instance.backpack = tag.func_74767_n("EquippedBackpack");
            instance.spawnedLoot = tag.func_74767_n("SpawnedLoot");
        }
    }
}

