/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.mrcrayfish.backpacked.client.ModelInstances;
import com.mrcrayfish.backpacked.common.Backpack;
import com.mrcrayfish.backpacked.common.IProgressTracker;
import com.mrcrayfish.backpacked.common.ProgressFormatters;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class BambooBasketBackpack
extends Backpack {
    public static final ResourceLocation ID = new ResourceLocation("backpacked", "bamboo_basket");

    public BambooBasketBackpack() {
        super(ID);
    }

    @Override
    public Supplier<Object> getModelSupplier() {
        return () -> ModelInstances.BAMBOO_BASKET;
    }

    @Override
    @Nullable
    protected IProgressTracker createProgressTracker() {
        return new ProgressTracker();
    }

    public static class ProgressTracker
    implements IProgressTracker {
        private static final int COUNT = 10;
        private final Set<UUID> fedPandas = new HashSet<UUID>();

        public void addPanda(PandaEntity panda, ServerPlayerEntity player) {
            this.fedPandas.add(panda.func_110124_au());
            this.markForCompletionTest(player);
        }

        @Override
        public boolean isComplete() {
            return this.fedPandas.size() >= 10;
        }

        @Override
        public void read(CompoundNBT tag) {
            this.fedPandas.clear();
            ListNBT list = tag.func_150295_c("FedPandas", 10);
            list.forEach(t -> {
                CompoundNBT uuidTag = (CompoundNBT)t;
                long mostBits = uuidTag.func_74763_f("Most");
                long leastBits = uuidTag.func_74763_f("Least");
                this.fedPandas.add(new UUID(mostBits, leastBits));
            });
        }

        @Override
        public void write(CompoundNBT tag) {
            ListNBT list = new ListNBT();
            this.fedPandas.forEach(uuid -> {
                CompoundNBT uuidTag = new CompoundNBT();
                uuidTag.func_74772_a("Most", uuid.getMostSignificantBits());
                uuidTag.func_74772_a("Least", uuid.getLeastSignificantBits());
                list.add((Object)uuidTag);
            });
            tag.func_218657_a("FedPandas", (INBT)list);
        }

        @Override
        public ITextComponent getDisplayComponent() {
            return ProgressFormatters.FED_X_OF_X.apply(this.fedPandas.size(), 10);
        }
    }
}

