/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.UnlockTracker;
import com.mrcrayfish.backpacked.common.tracker.BiomeExploreProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.CraftingProgressTracker;
import com.mrcrayfish.backpacked.item.BackpackItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SCollectItemPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="backpacked")
public class CommonEvents {
    @SubscribeEvent
    public static void onPickupItem(EntityItemPickupEvent event) {
        if (((Boolean)Config.SERVER.autoEquipBackpackOnPickup.get()).booleanValue() && event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            ItemEntity entity = event.getItem();
            ItemStack stack = entity.func_92059_d();
            if (!(stack.func_77973_b() instanceof BackpackItem)) {
                return;
            }
            if (Backpacked.getBackpackStack((PlayerEntity)player).func_190926_b()) {
                event.setCanceled(true);
                if (Backpacked.setBackpackStack((PlayerEntity)player, stack)) {
                    ((ServerWorld)entity.field_70170_p).func_72863_F().func_217218_b((Entity)entity, (IPacket)new SCollectItemPacket(entity.func_145782_y(), player.func_145782_y(), stack.func_190916_E()));
                    event.setCanceled(true);
                    event.getItem().func_174812_G();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onCraftedItem(PlayerEvent.ItemCraftedEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        ItemStack craftedItem = event.getCrafting();
        UnlockTracker.get(event.getPlayer()).ifPresent(unlockTracker -> unlockTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
            if (progressTracker instanceof CraftingProgressTracker && !progressTracker.isComplete()) {
                ((CraftingProgressTracker)progressTracker).processCrafted(craftedItem, player);
            }
        }));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.player.field_70170_p.func_201670_d()) {
            return;
        }
        if (event.player.field_70173_aa % 20 != 0) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.player;
        ServerWorld world = player.func_71121_q();
        BlockPos playerPosition = player.func_233580_cy_();
        world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)world.func_226691_t_(playerPosition)).ifPresent(key -> UnlockTracker.get((PlayerEntity)player).ifPresent(unlockTracker -> unlockTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
            if (progressTracker instanceof BiomeExploreProgressTracker && !progressTracker.isComplete()) {
                ((BiomeExploreProgressTracker)progressTracker).explore((RegistryKey<Biome>)key, player);
            }
        })));
    }
}

