/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.entity.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.backpacked.client.model.BackpackModel;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.tileentity.ShelfTileEntity;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class ShelfRenderer
extends TileEntityRenderer<ShelfTileEntity> {
    public ShelfRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(ShelfTileEntity entity, float partialTick, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        ItemStack stack = entity.getBackpack();
        if (stack.func_77973_b() != ModItems.BACKPACK.get()) {
            return;
        }
        CompoundNBT tag = stack.func_196082_o();
        String modelName = tag.func_74779_i("BackpackModel");
        BackpackModel model = BackpackLayer.getModel(modelName);
        Direction facing = entity.getDirection();
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        matrixStack.func_227861_a_(0.0, 0.3125, 0.0);
        matrixStack.func_227861_a_(0.0, 0.001, 0.0);
        matrixStack.func_227863_a_(facing.func_229384_a_());
        Vector3d offset = model.getShelfOffset();
        matrixStack.func_227861_a_(offset.field_72450_a * 0.0625, offset.field_72449_c * 0.0625, -offset.field_72448_b * 0.0625);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        int animationTick = Optional.ofNullable(Minecraft.func_71410_x().field_71439_g).map(player -> player.field_70173_aa).orElse(0);
        IVertexBuilder builder = buffer.getBuffer(model.func_228282_a_(model.getTextureLocation()));
        model.setupAngles(null, animationTick, partialTick);
        model.getStraps().field_78806_j = false;
        model.getBag().func_78793_a(0.0f, 0.0f, 0.0f);
        model.getBag().func_228308_a_(matrixStack, builder, light, overlay);
    }
}

