/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.gui.ButtonAlignment;
import com.mrcrayfish.backpacked.client.gui.screen.CustomiseBackpackScreen;
import com.mrcrayfish.backpacked.client.gui.screen.widget.MiniButton;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainer;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;

public class BackpackScreen
extends ContainerScreen<BackpackContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("backpacked", "textures/gui/backpack.png");
    private static final ITextComponent CUSTOMISE_TOOLTIP = new TranslationTextComponent("backpacked.button.customise.tooltip");
    private static final ITextComponent CONFIG_TOOLTIP = new TranslationTextComponent("backpacked.button.config.tooltip");
    private final int cols;
    private final int rows;
    private final boolean owner;
    private boolean opened;

    public BackpackScreen(BackpackContainer backpackContainer, PlayerInventory playerInventory, ITextComponent titleIn) {
        super((Container)backpackContainer, playerInventory, titleIn);
        this.cols = backpackContainer.getCols();
        this.rows = backpackContainer.getRows();
        this.owner = backpackContainer.isOwner();
        this.field_146999_f = 14 + Math.max(this.cols, 9) * 18;
        this.field_147000_g = 114 + this.rows * 18;
        this.field_238744_r_ = Math.max((this.cols * 18 - 162) / 2, 0) + 7;
        this.field_238745_s_ = this.rows * 18 + 17 + 4;
    }

    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
        if (!this.opened) {
            minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187728_s, (float)0.75f, (float)1.0f));
            this.opened = true;
        }
        List<MiniButton> buttons = this.gatherButtons();
        for (int i = 0; i < buttons.size(); ++i) {
            MiniButton button = buttons.get(i);
            switch ((ButtonAlignment)((Object)Config.CLIENT.buttonAlignment.get())) {
                case LEFT: {
                    int titleWidth = this.field_230706_i_.field_71466_p.func_238414_a_((ITextProperties)this.field_230704_d_);
                    button.field_230690_l_ = this.field_147003_i + titleWidth + 8 + 3 + i * 13;
                    break;
                }
                case RIGHT: {
                    button.field_230690_l_ = this.field_147003_i + this.field_146999_f - 7 - 10 - (buttons.size() - 1 - i) * 13;
                }
            }
            button.field_230691_m_ = this.field_147009_r + 5;
            this.func_230480_a_((Widget)button);
        }
    }

    private List<MiniButton> gatherButtons() {
        boolean canCustomise;
        ArrayList<MiniButton> buttons = new ArrayList<MiniButton>();
        boolean bl = canCustomise = this.owner && (Boolean)Config.SERVER.disableCustomisation.get() == false;
        if (canCustomise) {
            buttons.add(new MiniButton(0, 0, 225, 0, CustomiseBackpackScreen.GUI_TEXTURE, onPress -> Network.getPlayChannel().sendToServer((Object)new MessageRequestCustomisation()), (button, matrixStack, mouseX, mouseY) -> this.func_238652_a_(matrixStack, CUSTOMISE_TOOLTIP, mouseX, mouseY)));
        }
        if (!((Boolean)Config.CLIENT.hideConfigButton.get()).booleanValue()) {
            buttons.add(new MiniButton(0, 0, 235, 0, CustomiseBackpackScreen.GUI_TEXTURE, onPress -> this.openConfigScreen(), (button, matrixStack, mouseX, mouseY) -> this.func_238652_a_(matrixStack, CONFIG_TOOLTIP, mouseX, mouseY)));
        }
        return buttons;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        this.field_230710_m_.forEach(widget -> {
            if (widget.func_230449_g_()) {
                widget.func_230443_a_(matrixStack, mouseX, mouseY);
            }
        });
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.drawBackgroundWindow(matrixStack, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_145748_c_(), (float)this.field_238744_r_, (float)this.field_238745_s_, 0x404040);
    }

    private void drawBackgroundWindow(MatrixStack matrixStack, int x, int y, int width, int height) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
        int backpackHeight = 17 + this.rows * 18;
        BackpackScreen.func_238466_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)7, (int)backpackHeight, (float)0.0f, (float)0.0f, (int)7, (int)backpackHeight, (int)256, (int)256);
        BackpackScreen.func_238466_a_((MatrixStack)matrixStack, (int)(x + width - 7), (int)y, (int)7, (int)backpackHeight, (float)8.0f, (float)0.0f, (int)7, (int)backpackHeight, (int)256, (int)256);
        BackpackScreen.func_238466_a_((MatrixStack)matrixStack, (int)(x + 7), (int)y, (int)(width - 14), (int)backpackHeight, (float)7.0f, (float)0.0f, (int)1, (int)backpackHeight, (int)256, (int)256);
        int slotWidth = this.cols * 18;
        int slotHeight = this.rows * 18;
        int minSlotWidth = 162;
        int backpackStartX = Math.max((minSlotWidth - slotWidth) / 2, 0);
        BackpackScreen.func_238466_a_((MatrixStack)matrixStack, (int)(backpackStartX + x + 7), (int)(y + 17), (int)slotWidth, (int)slotHeight, (float)15.0f, (float)0.0f, (int)slotWidth, (int)slotHeight, (int)256, (int)256);
        BackpackScreen.func_238466_a_((MatrixStack)matrixStack, (int)x, (int)(y + backpackHeight), (int)7, (int)97, (float)0.0f, (float)143.0f, (int)7, (int)97, (int)256, (int)256);
        BackpackScreen.func_238466_a_((MatrixStack)matrixStack, (int)(x + width - 7), (int)(y + backpackHeight), (int)7, (int)97, (float)8.0f, (float)143.0f, (int)7, (int)97, (int)256, (int)256);
        BackpackScreen.func_238466_a_((MatrixStack)matrixStack, (int)(x + 7), (int)(y + backpackHeight), (int)(width - 14), (int)97, (float)7.0f, (float)143.0f, (int)1, (int)97, (int)256, (int)256);
        int inventoryStartX = Math.max((slotWidth - minSlotWidth) / 2, 0);
        BackpackScreen.func_238466_a_((MatrixStack)matrixStack, (int)(x + inventoryStartX + 7), (int)(y + backpackHeight + 14), (int)163, (int)76, (float)15.0f, (float)157.0f, (int)163, (int)76, (int)256, (int)256);
    }

    private void openConfigScreen() {
        ModList.get().getModContainerById("backpacked").ifPresent(container -> {
            Screen screen = container.getCustomExtension(ExtensionPoint.CONFIGGUIFACTORY).map(function -> (Screen)function.apply(this.field_230706_i_, null)).orElse(null);
            if (screen != null) {
                this.field_230706_i_.func_147108_a(screen);
            } else if (this.field_230706_i_ != null && this.field_230706_i_.field_71439_g != null) {
                StringTextComponent modName = new StringTextComponent("Configured");
                modName.func_230530_a_(modName.func_150256_b().func_240712_a_(TextFormatting.YELLOW).func_244282_c(Boolean.valueOf(true)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("backpacked.chat.open_curseforge_page"))).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured")));
                TranslationTextComponent message = new TranslationTextComponent("backpacked.chat.install_configured", new Object[]{modName});
                this.field_230706_i_.field_71439_g.func_146105_b((ITextComponent)message, false);
            }
        });
    }
}

