/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.client.ClientEvents;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CheckBox;
import com.mrcrayfish.backpacked.client.model.BackpackModel;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.common.Backpack;
import com.mrcrayfish.backpacked.common.BackpackManager;
import com.mrcrayfish.backpacked.common.BackpackModelProperty;
import com.mrcrayfish.backpacked.common.backpack.StandardBackpack;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.animation.Animation;
import org.lwjgl.opengl.GL11;

public class CustomiseBackpackScreen
extends Screen {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("backpacked", "textures/gui/customise_backpack.png");
    private static final ITextComponent SHOW_EFFECTS_TOOLTIP = new TranslationTextComponent("backpacked.button.show_effects.tooltip");
    private static final ITextComponent SHOW_WITH_ELYTRA_TOOLTIP = new TranslationTextComponent("backpacked.button.show_with_elytra.tooltip");
    private static final ITextComponent SHOW_ENCHANTMENT_GLINT = new TranslationTextComponent("backpacked.button.show_enchantment_glint.tooltip");
    private static final ITextComponent LOCKED = new TranslationTextComponent("backpacked.gui.locked").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD});
    private final int windowWidth;
    private final int windowHeight;
    private int windowLeft;
    private int windowTop;
    private float windowRotationX = -35.0f;
    private float windowRotationY = 10.0f;
    private boolean windowGrabbed;
    private boolean scrollGrabbed;
    private int mouseClickedX;
    private int mouseClickedY;
    private Button resetButton;
    private Button saveButton;
    private CheckBox showEnchantmentGlintButton;
    private CheckBox showWithElytraButton;
    private CheckBox showEffectsButton;
    private String displayBackpackModel = null;
    private boolean displayShowEnchantmentGlint;
    private boolean displayShowWithElytra;
    private boolean displayShowEffects;
    private final List<BackpackModelEntry> models;
    private int scroll;
    private int animationTick;

    public CustomiseBackpackScreen(Map<ResourceLocation, ITextComponent> progressMap) {
        super((ITextComponent)new TranslationTextComponent("backpacked.title.customise_backpack"));
        this.windowWidth = 201;
        this.windowHeight = 166;
        Comparator<BackpackModelEntry> compareUnlock = Comparator.comparing(e -> !((BackpackModelEntry)e).backpack.isUnlocked((PlayerEntity)Minecraft.func_71410_x().field_71439_g));
        Comparator<BackpackModelEntry> compareLabel = Comparator.comparing(e -> ((BackpackModelEntry)e).label.getString());
        List models = BackpackManager.instance().getRegisteredBackpacks().stream().map(backpack -> new BackpackModelEntry((Backpack)backpack, progressMap)).sorted(compareUnlock.thenComparing(compareLabel)).collect(Collectors.toList());
        this.models = ImmutableList.copyOf(models);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        if (this.displayBackpackModel == null) {
            this.displayBackpackModel = this.getBackpackModel();
            this.displayShowWithElytra = this.getLocalBackpackProperty(BackpackModelProperty.SHOW_WITH_ELYTRA);
            this.displayShowEffects = this.getLocalBackpackProperty(BackpackModelProperty.SHOW_EFFECTS);
        }
        this.windowLeft = (this.field_230708_k_ - this.windowWidth) / 2;
        this.windowTop = (this.field_230709_l_ - this.windowHeight) / 2;
        this.resetButton = (Button)this.func_230480_a_((Widget)new Button(this.windowLeft + 7, this.windowTop + 114, 71, 20, (ITextComponent)new TranslationTextComponent("backpacked.button.reset"), onPress -> {
            this.displayBackpackModel = "";
        }));
        this.saveButton = (Button)this.func_230480_a_((Widget)new Button(this.windowLeft + 7, this.windowTop + 137, 71, 20, (ITextComponent)new TranslationTextComponent("backpacked.button.save"), onPress -> Network.getPlayChannel().sendToServer((Object)new MessageBackpackCosmetics(new ResourceLocation(this.displayBackpackModel), this.displayShowEnchantmentGlint, this.displayShowWithElytra, this.displayShowEffects))));
        this.showEnchantmentGlintButton = (CheckBox)this.func_230480_a_((Widget)new CheckBox(this.windowLeft + 133, this.windowTop + 6, StringTextComponent.field_240750_d_, onPress -> {
            this.displayShowEnchantmentGlint = !this.displayShowEnchantmentGlint;
        }, (button, matrixStack, mouseX, mouseY) -> this.func_238652_a_(matrixStack, SHOW_ENCHANTMENT_GLINT, mouseX, mouseY)));
        this.showWithElytraButton = (CheckBox)this.func_230480_a_((Widget)new CheckBox(this.windowLeft + 160, this.windowTop + 6, StringTextComponent.field_240750_d_, onPress -> {
            this.displayShowWithElytra = !this.displayShowWithElytra;
        }, (button, matrixStack, mouseX, mouseY) -> this.func_238652_a_(matrixStack, SHOW_WITH_ELYTRA_TOOLTIP, mouseX, mouseY)));
        this.showEffectsButton = (CheckBox)this.func_230480_a_((Widget)new CheckBox(this.windowLeft + 186, this.windowTop + 6, StringTextComponent.field_240750_d_, onPress -> {
            this.displayShowEffects = !this.displayShowEffects;
        }, (button, matrixStack, mouseX, mouseY) -> this.func_238652_a_(matrixStack, SHOW_EFFECTS_TOOLTIP, mouseX, mouseY)));
        ItemStack backpack = Backpacked.getBackpackStack((PlayerEntity)this.field_230706_i_.field_71439_g);
        if (!backpack.func_190926_b()) {
            this.showEnchantmentGlintButton.setChecked(BackpackLayer.canShowEnchantmentGlint(backpack));
            this.showWithElytraButton.setChecked(BackpackLayer.canRenderWithElytra(backpack));
            this.showEffectsButton.setChecked(ClientEvents.canShowBackpackEffects(backpack));
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.resetButton.field_230693_o_ = !this.getBackpackModel().equals(StandardBackpack.ID.toString());
        this.saveButton.field_230693_o_ = this.needsToSave();
    }

    private boolean needsToSave() {
        if (!this.displayBackpackModel.equals(this.getBackpackModel())) {
            return true;
        }
        if (this.getLocalBackpackProperty(BackpackModelProperty.SHOW_EFFECTS) != this.displayShowEffects) {
            return true;
        }
        if (this.getLocalBackpackProperty(BackpackModelProperty.SHOW_GLINT) != this.displayShowEnchantmentGlint) {
            return true;
        }
        return this.getLocalBackpackProperty(BackpackModelProperty.SHOW_WITH_ELYTRA) != this.displayShowWithElytra;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.updateButtons();
        ++this.animationTick;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        BackpackModelEntry entry;
        int startIndex;
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_238474_b_(matrixStack, this.windowLeft, this.windowTop, 0, 0, this.windowWidth, this.windowHeight);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTick);
        if (this.field_230706_i_.field_71439_g != null) {
            GL11.glEnable((int)3089);
            ScreenUtil.scissor(this.windowLeft + 8, this.windowTop + 18, 69, 92);
            this.renderPlayer(this.windowLeft + 42, this.windowTop + this.windowHeight / 2, mouseX, mouseY, (PlayerEntity)this.field_230706_i_.field_71439_g);
            GL11.glDisable((int)3089);
        }
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, (float)(this.windowLeft + 8), (float)(this.windowTop + 6), 0x404040);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        boolean canScroll = this.models.size() > 7;
        int scroll = (canScroll ? this.scroll : 0) + (this.scrollGrabbed ? mouseY - this.mouseClickedY : 0);
        scroll = MathHelper.func_76125_a((int)scroll, (int)0, (int)123);
        this.func_238474_b_(matrixStack, this.windowLeft + 181, this.windowTop + 18 + scroll, 201 + (!canScroll ? 12 : 0), 0, 12, 15);
        for (int i = startIndex = (int)((double)Math.max(0, this.models.size() - 7) * MathHelper.func_151237_a((double)(((double)scroll + 15.0) / 123.0), (double)0.0, (double)1.0)); i < this.models.size() && i < startIndex + 7; ++i) {
            this.drawBackpackItem(matrixStack, this.windowLeft + 82, this.windowTop + 17 + (i - startIndex) * 20, mouseX, mouseY, partialTick, this.models.get(i));
        }
        int hoveredIndex = this.getHoveredIndex(mouseX, mouseY);
        if (hoveredIndex != -1 && !(entry = this.models.get(hoveredIndex)).getBackpack().isUnlocked((PlayerEntity)this.field_230706_i_.field_71439_g)) {
            this.func_238654_b_(matrixStack, entry.getUnlockTooltip(), mouseX, mouseY);
            return;
        }
        this.field_230710_m_.forEach(widget -> {
            if (widget.func_230449_g_()) {
                widget.func_230443_a_(matrixStack, mouseX, mouseY);
            }
        });
    }

    private void drawBackpackItem(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTick, BackpackModelEntry entry) {
        boolean unlocked = entry.getBackpack().isUnlocked((PlayerEntity)this.field_230706_i_.field_71439_g);
        boolean selected = unlocked && entry.getId().equals(this.displayBackpackModel);
        boolean hovered = unlocked && !selected && ScreenUtil.isPointInArea(mouseX, mouseY, x, y, 97, 20);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        int offset = (unlocked ? 0 : 60) + (selected ? 20 : 0) + (hovered ? 40 : 0);
        this.func_238474_b_(matrixStack, x, y, 0, 166 + offset, 97, 20);
        int color = selected ? 4226832 : (hovered ? 0xFFFF80 : (unlocked ? 6839882 : 5119004));
        this.field_230712_o_.func_243248_b(matrixStack, entry.getLabel(), (float)(x + 20), (float)(y + 6), color);
        CustomiseBackpackScreen.drawBackpackModel(matrixStack, entry.getModel(), x + 8, y + 4, 20.0f, this.animationTick, partialTick);
    }

    public static void drawBackpackModel(MatrixStack matrixStack, BackpackModel model, int x, int y, float scale, int animationTick, float partialTick) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, 50.0);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-10.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(35.0f));
        matrixStack.func_227862_a_(scale, scale, scale);
        RenderHelper.func_227783_c_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.pushMatrix();
        IRenderTypeBuffer.Impl source = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        IVertexBuilder builder = source.getBuffer(model.func_228282_a_(model.getTextureLocation()));
        model.setupAngles(null, animationTick, Animation.getPartialTickTime());
        model.getStraps().field_78806_j = false;
        ModelRenderer bag = model.getBag();
        bag.func_78793_a(0.0f, 0.0f, 0.0f);
        bag.func_228308_a_(matrixStack, builder, 0xF000F0, OverlayTexture.field_229196_a_);
        source.func_228461_a_();
        RenderSystem.popMatrix();
        matrixStack.func_227865_b_();
    }

    private int getHoveredIndex(int mouseX, int mouseY) {
        int displayIndex;
        int startIndex;
        int actualIndex;
        if (ScreenUtil.isPointInArea(mouseX, mouseY, this.windowLeft + 82, this.windowTop + 17, 97, 140) && (actualIndex = (startIndex = (int)((double)Math.max(0, this.models.size() - 7) * MathHelper.func_151237_a((double)(((double)this.scroll + 15.0) / 123.0), (double)0.0, (double)1.0))) + (displayIndex = (mouseY - this.windowTop - 17) / 20)) >= 0 && actualIndex < this.models.size()) {
            return actualIndex;
        }
        return -1;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 82, this.windowTop + 17, 97, 140)) {
            BackpackModelEntry entry;
            int hoveredIndex;
            if (button == 0 && (hoveredIndex = this.getHoveredIndex((int)mouseX, (int)mouseY)) != -1 && (entry = this.models.get(hoveredIndex)).getBackpack().isUnlocked((PlayerEntity)this.field_230706_i_.field_71439_g)) {
                this.displayBackpackModel = entry.getId();
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
        } else if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 8, this.windowTop + 18, 69, 92)) {
            if (!this.windowGrabbed && button == 0) {
                this.windowGrabbed = true;
                this.mouseClickedX = (int)mouseX;
                this.mouseClickedY = (int)mouseY;
                return true;
            }
        } else if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 181, this.windowTop + 18 + this.scroll, 12, 15) && !this.scrollGrabbed && button == 0) {
            this.scrollGrabbed = true;
            this.mouseClickedY = (int)mouseY;
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.windowGrabbed && button == 0) {
            this.windowRotationX = (float)((double)this.windowRotationX + (mouseX - (double)this.mouseClickedX));
            this.windowRotationY = (float)((double)this.windowRotationY + (mouseY - (double)this.mouseClickedY));
            this.windowGrabbed = false;
        }
        if (this.scrollGrabbed && button == 0) {
            this.scroll = (int)((double)this.scroll + (mouseY - (double)this.mouseClickedY));
            this.scroll = MathHelper.func_76125_a((int)this.scroll, (int)0, (int)123);
            this.scrollGrabbed = false;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 82, this.windowTop + 17, 112, 140)) {
            int startIndex = (int)((double)Math.max(0, this.models.size() - 7) * MathHelper.func_151237_a((double)(((double)this.scroll + 15.0) / 123.0), (double)0.0, (double)1.0));
            int newIndex = startIndex - (int)Math.signum(scroll);
            this.scrollToIndex(newIndex);
        }
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    private void scrollToIndex(int index) {
        this.scroll = (int)(123.0 * ((double)index / (double)Math.max(this.models.size() - 7, 1)));
        this.scroll = MathHelper.func_76125_a((int)this.scroll, (int)0, (int)123);
    }

    private String getBackpackModel() {
        String model;
        CompoundNBT tag;
        ItemStack stack = Backpacked.getBackpackStack((PlayerEntity)this.field_230706_i_.field_71439_g);
        if (!stack.func_190926_b() && (tag = stack.func_196082_o()).func_150297_b("BackpackModel", 8) && !(model = tag.func_74779_i("BackpackModel")).isEmpty()) {
            return model;
        }
        return StandardBackpack.ID.toString();
    }

    private void setLocalBackpackModel(String model) {
        ItemStack stack = Backpacked.getBackpackStack((PlayerEntity)this.field_230706_i_.field_71439_g);
        if (!stack.func_190926_b()) {
            stack.func_196082_o().func_74778_a("BackpackModel", model);
        }
    }

    private boolean getLocalBackpackProperty(BackpackModelProperty property) {
        CompoundNBT tag;
        ItemStack stack = Backpacked.getBackpackStack((PlayerEntity)this.field_230706_i_.field_71439_g);
        if (!stack.func_190926_b() && (tag = stack.func_196082_o()).func_150297_b(property.getTagName(), 1)) {
            return tag.func_74767_n(property.getTagName());
        }
        return property.getDefaultValue();
    }

    private void setLocalBackpackProperty(BackpackModelProperty property, boolean value) {
        ItemStack stack = Backpacked.getBackpackStack((PlayerEntity)this.field_230706_i_.field_71439_g);
        if (!stack.func_190926_b()) {
            stack.func_196082_o().func_74757_a(property.getTagName(), value);
        }
    }

    private void renderPlayer(int x, int y, int mouseX, int mouseY, PlayerEntity player) {
        float scale = 70.0f;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixStack.func_227861_a_(0.0, -15.0, 0.0);
        Quaternion playerRotation = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion cameraRotation = new Quaternion(0.0f, 0.0f, 0.0f, true);
        cameraRotation.func_195890_a(Vector3f.field_229178_a_.func_229187_a_(this.windowRotationY + (float)(this.windowGrabbed ? mouseY - this.mouseClickedY : 0)));
        cameraRotation.func_195890_a(Vector3f.field_229181_d_.func_229187_a_(this.windowRotationX + (float)(this.windowGrabbed ? mouseX - this.mouseClickedX : 0)));
        playerRotation.func_195890_a(cameraRotation);
        matrixStack.func_227863_a_(playerRotation);
        matrixStack.func_227861_a_(0.0, (double)(-this.windowHeight / 2), 0.0);
        matrixStack.func_227862_a_(scale, scale, scale);
        float origBodyRot = player.field_70761_aq;
        float origYaw = player.field_70177_z;
        float origPitch = player.field_70125_A;
        float origHeadYawOld = player.field_70758_at;
        float origHeadYaw = player.field_70759_as;
        String origBackpackModel = this.getBackpackModel();
        boolean origShowEnchantmentGlint = this.getLocalBackpackProperty(BackpackModelProperty.SHOW_GLINT);
        boolean origShowWithElytra = this.getLocalBackpackProperty(BackpackModelProperty.SHOW_WITH_ELYTRA);
        boolean origShowEffects = this.getLocalBackpackProperty(BackpackModelProperty.SHOW_EFFECTS);
        player.field_70761_aq = 0.0f;
        player.field_70760_ar = 0.0f;
        player.field_70177_z = 0.0f;
        player.field_70126_B = 0.0f;
        player.field_70125_A = 15.0f;
        player.field_70127_C = 15.0f;
        player.field_70759_as = player.field_70177_z;
        player.field_70758_at = player.field_70177_z;
        this.setLocalBackpackModel(this.displayBackpackModel);
        this.setLocalBackpackProperty(BackpackModelProperty.SHOW_GLINT, this.displayShowEnchantmentGlint);
        this.setLocalBackpackProperty(BackpackModelProperty.SHOW_WITH_ELYTRA, this.displayShowWithElytra);
        this.setLocalBackpackProperty(BackpackModelProperty.SHOW_EFFECTS, this.displayShowEffects);
        EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
        cameraRotation.func_195892_e();
        manager.func_229089_a_(cameraRotation);
        manager.func_178633_a(false);
        IRenderTypeBuffer.Impl source = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> manager.func_229084_a_((Entity)player, 0.0, 0.0625, 0.35, 0.0f, Animation.getPartialTickTime(), matrixStack, (IRenderTypeBuffer)source, 0xF000F0));
        source.func_228461_a_();
        manager.func_178633_a(true);
        player.field_70761_aq = origBodyRot;
        player.field_70177_z = origYaw;
        player.field_70125_A = origPitch;
        player.field_70758_at = origHeadYawOld;
        player.field_70759_as = origHeadYaw;
        this.setLocalBackpackModel(origBackpackModel);
        this.setLocalBackpackProperty(BackpackModelProperty.SHOW_GLINT, origShowEnchantmentGlint);
        this.setLocalBackpackProperty(BackpackModelProperty.SHOW_WITH_ELYTRA, origShowWithElytra);
        this.setLocalBackpackProperty(BackpackModelProperty.SHOW_EFFECTS, origShowEffects);
        RenderSystem.popMatrix();
    }

    private static class BackpackModelEntry {
        private final String id;
        private final Backpack backpack;
        private final ITextComponent label;
        private final List<IReorderingProcessor> unlockTooltip;
        private final BackpackModel model;

        public BackpackModelEntry(Backpack backpack, Map<ResourceLocation, ITextComponent> progressMap) {
            this.id = backpack.getId().toString();
            this.backpack = backpack;
            this.label = new TranslationTextComponent(backpack.getId().func_110624_b() + ".backpack." + backpack.getId().func_110623_a());
            TranslationTextComponent unlockMessage = new TranslationTextComponent(backpack.getId().func_110624_b() + ".backpack." + backpack.getId().func_110623_a() + ".unlock");
            ArrayList<IReorderingProcessor> list = new ArrayList<IReorderingProcessor>(Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)unlockMessage, 150));
            list.add(0, LanguageMap.func_74808_a().func_241870_a((ITextProperties)LOCKED));
            if (progressMap.containsKey(backpack.getId())) {
                IFormattableTextComponent component = progressMap.get(backpack.getId()).func_230531_f_().func_240699_a_(TextFormatting.YELLOW);
                list.add(LanguageMap.func_74808_a().func_241870_a((ITextProperties)component));
            }
            this.unlockTooltip = ImmutableList.copyOf(list);
            this.model = (BackpackModel)((Object)backpack.getModelSupplier().get());
        }

        public String getId() {
            return this.id;
        }

        public ITextComponent getLabel() {
            return this.label;
        }

        public List<IReorderingProcessor> getUnlockTooltip() {
            return this.unlockTooltip;
        }

        public Backpack getBackpack() {
            return this.backpack;
        }

        public BackpackModel getModel() {
            return this.model;
        }
    }
}

