/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.BackpackedButtonBindings;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.ClientEvents;
import com.mrcrayfish.backpacked.client.ControllerHandler;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.BackpackScreen;
import com.mrcrayfish.backpacked.client.model.BackpackModel;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.ShelfRenderer;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.VillagerBackpackLayer;
import com.mrcrayfish.backpacked.common.BackpackManager;
import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.core.ModTileEntities;
import com.mrcrayfish.backpacked.item.BackpackItem;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.WanderingTraderRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ClientHandler {
    public static final KeyBinding KEY_BACKPACK = new KeyBinding("key.backpack", 66, "key.categories.inventory");

    public static void setup() {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        ClientHandler.addBackpackLayer((PlayerRenderer)skinMap.get("default"));
        ClientHandler.addBackpackLayer((PlayerRenderer)skinMap.get("slim"));
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_BACKPACK);
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.BACKPACK.get()), BackpackScreen::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.SHELF.get()), ShelfRenderer::new);
        if (Backpacked.isControllableLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)new ControllerHandler());
            BackpackedButtonBindings.register();
        }
        BackpackManager.instance().getRegisteredBackpacks().forEach(backpack -> BackpackLayer.registerModel(backpack.getId(), (BackpackModel)((Object)((Object)backpack.getModelSupplier().get()))));
        EntityRenderer renderer = (EntityRenderer)Minecraft.func_71410_x().func_175598_ae().field_78729_o.get(EntityType.field_220351_aK);
        if (renderer instanceof WanderingTraderRenderer) {
            WanderingTraderRenderer traderRenderer = (WanderingTraderRenderer)renderer;
            traderRenderer.func_177094_a(new VillagerBackpackLayer(traderRenderer));
        }
    }

    private static void addBackpackLayer(PlayerRenderer renderer) {
        renderer.func_177094_a(new BackpackLayer(renderer));
    }

    public static void createBackpackTooltip(ItemStack stack, List<ITextComponent> list) {
        CompoundNBT tag;
        if (!((Boolean)Config.SERVER.lockBackpackIntoSlot.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && Backpacked.getBackpackStack((PlayerEntity)mc.field_71439_g).equals(stack) && (tag = stack.func_77978_p()) != null && !tag.func_150295_c("Items", 10).isEmpty()) {
            mc.field_71466_p.func_238420_b_().func_238362_b_((ITextProperties)BackpackItem.REMOVE_ITEMS_TOOLTIP, 150, Style.field_240709_b_).forEach(formattedText -> list.add((ITextComponent)new StringTextComponent(formattedText.getString()).func_240699_a_(TextFormatting.RED)));
        }
    }
}

