/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.tileentity.ShelfTileEntity;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ShelfBlock
extends HorizontalBlock {
    private static final Map<Direction, VoxelShape> EMPTY_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)2.0, (double)3.0, (double)7.0, (double)14.0, (double)5.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)5.0, (double)9.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)7.0, (double)3.0, (double)2.0, (double)16.0, (double)5.0, (double)14.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)3.0, (double)2.0, (double)9.0, (double)5.0, (double)14.0)));
    private static final Map<Direction, VoxelShape> SHELVED_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)2.0, (double)3.0, (double)7.0, (double)14.0, (double)14.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)14.0, (double)9.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)7.0, (double)3.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)3.0, (double)2.0, (double)9.0, (double)14.0, (double)14.0)));

    public ShelfBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        TileEntity tileEntity;
        if (!world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof ShelfTileEntity) {
            return ((ShelfTileEntity)tileEntity).interact(player);
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        TileEntity tileEntity = reader.func_175625_s(pos);
        if (tileEntity instanceof ShelfTileEntity && !((ShelfTileEntity)tileEntity).getBackpack().func_190926_b()) {
            return SHELVED_SHAPES.get(state.func_177229_b((Property)field_185512_D));
        }
        return EMPTY_SHAPES.get(state.func_177229_b((Property)field_185512_D));
    }

    public boolean func_196260_a(BlockState state, IWorldReader reader, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((Property)field_185512_D);
        BlockPos relativePos = pos.func_177972_a(facing.func_176734_d());
        BlockState relativeState = reader.func_180495_p(relativePos);
        return relativeState.func_224755_d((IBlockReader)reader, relativePos, facing);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState potentialState;
        Direction clickedFace = context.func_196000_l();
        if (clickedFace.func_176740_k().func_176722_c() && this.func_196260_a(potentialState = (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)clickedFace), (IWorldReader)context.func_195991_k(), context.func_195995_a())) {
            return potentialState;
        }
        return null;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ShelfTileEntity) {
            return Container.func_94526_b((IInventory)((IInventory)tileEntity));
        }
        return 0;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean unknown) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof ShelfTileEntity) {
                boolean dropsContents = (Boolean)Config.SERVER.dropContentsFromShelf.get();
                ShelfTileEntity shelf = (ShelfTileEntity)tileEntity;
                ItemStack stack = dropsContents ? shelf.getBackpack() : shelf.getBackpackWithContents();
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
                if (dropsContents) {
                    InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)shelf);
                }
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, unknown);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ShelfTileEntity();
    }
}

