/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked;

import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.ClientEvents;
import com.mrcrayfish.backpacked.client.ClientHandler;
import com.mrcrayfish.backpacked.common.UnlockTracker;
import com.mrcrayfish.backpacked.common.WanderingTraderEvents;
import com.mrcrayfish.backpacked.common.command.arguments.BackpackArgument;
import com.mrcrayfish.backpacked.common.data.PickpocketChallenge;
import com.mrcrayfish.backpacked.core.ModBlocks;
import com.mrcrayfish.backpacked.core.ModCommands;
import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.core.ModEnchantments;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.core.ModSounds;
import com.mrcrayfish.backpacked.core.ModTileEntities;
import com.mrcrayfish.backpacked.datagen.BlockTagGen;
import com.mrcrayfish.backpacked.datagen.LootTableGen;
import com.mrcrayfish.backpacked.datagen.RecipeGen;
import com.mrcrayfish.backpacked.integration.Curios;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageUpdateBackpack;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="backpacked")
public class Backpacked {
    public static final EnchantmentType ENCHANTMENT_TYPE = EnchantmentType.create((String)"backpack", item -> item instanceof BackpackItem);
    private static boolean controllableLoaded = false;
    private static boolean curiosLoaded = false;
    private static Set<ResourceLocation> bannedItemsList;
    public static final ItemGroup TAB;

    public Backpacked() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.serverSpec);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(ClientEvents::onTextureStitch));
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onClientSetup);
        bus.addListener(this::onEnqueueIMC);
        bus.addListener(this::onConfigLoad);
        bus.addListener(this::onConfigReload);
        bus.addListener(this::onGatherData);
        ModContainers.REGISTER.register(bus);
        ModEnchantments.REGISTER.register(bus);
        ModItems.REGISTER.register(bus);
        ModBlocks.REGISTER.register(bus);
        ModTileEntities.REGISTER.register(bus);
        ModSounds.REGISTER.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ModCommands());
        MinecraftForge.EVENT_BUS.register((Object)new WanderingTraderEvents());
        controllableLoaded = ModList.get().isLoaded("controllable");
        curiosLoaded = ModList.get().isLoaded("curios");
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        UnlockTracker.registerCapability();
        PickpocketChallenge.registerCapability();
        Network.init();
        ArgumentTypes.func_218136_a((String)"backpacked:backpack", BackpackArgument.class, (IArgumentSerializer)new ArgumentSerializer(BackpackArgument::backpacks));
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ClientHandler.setup();
    }

    private void onEnqueueIMC(InterModEnqueueEvent event) {
        if (!curiosLoaded) {
            return;
        }
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    private void onGatherData(GatherDataEvent event) {
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        DataGenerator generator = event.getGenerator();
        generator.func_200390_a((IDataProvider)new LootTableGen(generator));
        generator.func_200390_a((IDataProvider)new RecipeGen(generator));
        generator.func_200390_a((IDataProvider)new BlockTagGen(generator, existingFileHelper));
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (curiosLoaded) {
            return;
        }
        PlayerEntity oldPlayer = event.getOriginal();
        if (oldPlayer.field_71071_by instanceof ExtendedPlayerInventory && event.getPlayer().field_71071_by instanceof ExtendedPlayerInventory) {
            ((ExtendedPlayerInventory)event.getPlayer().field_71071_by).copyBackpack((ExtendedPlayerInventory)oldPlayer.field_71071_by);
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        ItemStack backpack;
        if (curiosLoaded) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player.field_71071_by instanceof ExtendedPlayerInventory && !(backpack = (ItemStack)((ExtendedPlayerInventory)player.field_71071_by).getBackpackItems().get(0)).func_190926_b() && backpack.func_77973_b() instanceof BackpackItem) {
            Network.getPlayChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new MessageUpdateBackpack(player.func_145782_y(), backpack));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (curiosLoaded) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K && player.field_71071_by instanceof ExtendedPlayerInventory) {
            ExtendedPlayerInventory inventory = (ExtendedPlayerInventory)player.field_71071_by;
            if (!((ItemStack)inventory.backpackArray.get(0)).equals(inventory.backpackInventory.get(0))) {
                Network.getPlayChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new MessageUpdateBackpack(player.func_145782_y(), (ItemStack)inventory.backpackInventory.get(0)));
                inventory.backpackArray.set(0, inventory.backpackInventory.get(0));
            }
        }
    }

    public static boolean isControllableLoaded() {
        return controllableLoaded;
    }

    public static boolean isCuriosLoaded() {
        return curiosLoaded;
    }

    public static ItemStack getBackStack(PlayerEntity player) {
        ExtendedPlayerInventory inventory;
        ItemStack stack;
        AtomicReference<ItemStack> backpack = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        if (Backpacked.isCuriosLoaded()) {
            backpack.set(Curios.getBackStack(player));
        }
        if (player.field_71071_by instanceof ExtendedPlayerInventory && !(stack = (ItemStack)(inventory = (ExtendedPlayerInventory)player.field_71071_by).getBackpackItems().get(0)).func_190926_b()) {
            backpack.set(stack);
        }
        return backpack.get();
    }

    public static ItemStack getBackpackStack(PlayerEntity player) {
        ExtendedPlayerInventory inventory;
        ItemStack stack;
        AtomicReference<ItemStack> backpack = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        if (Backpacked.isCuriosLoaded()) {
            backpack.set(Curios.getBackpackStack(player));
        }
        if (player.field_71071_by instanceof ExtendedPlayerInventory && (stack = (ItemStack)(inventory = (ExtendedPlayerInventory)player.field_71071_by).getBackpackItems().get(0)).func_77973_b() instanceof BackpackItem) {
            backpack.set(stack);
        }
        return backpack.get();
    }

    public static boolean setBackpackStack(PlayerEntity player, ItemStack stack) {
        if (!(stack.func_77973_b() instanceof BackpackItem) && !stack.func_190926_b()) {
            return false;
        }
        if (Backpacked.isCuriosLoaded()) {
            Curios.setBackpackStack(player, stack);
            return true;
        }
        if (player.field_71071_by instanceof ExtendedPlayerInventory) {
            ((ExtendedPlayerInventory)player.field_71071_by).getBackpackItems().set(0, (Object)stack.func_77946_l());
            return true;
        }
        return false;
    }

    private void onConfigLoad(ModConfig.Loading event) {
        ModConfig config = event.getConfig();
        if (config.getType() == ModConfig.Type.SERVER && config.getModId().equals("backpacked")) {
            Backpacked.updateBannedItemsList();
        }
    }

    private void onConfigReload(ModConfig.Reloading event) {
        ModConfig config = event.getConfig();
        if (config.getType() == ModConfig.Type.SERVER && config.getModId().equals("backpacked")) {
            Backpacked.updateBannedItemsList();
        }
    }

    public static void updateBannedItemsList() {
        bannedItemsList = ImmutableSet.copyOf((Collection)((List)Config.SERVER.bannedItems.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet()));
    }

    public static Set<ResourceLocation> getBannedItemsList() {
        return bannedItemsList;
    }

    static {
        TAB = new ItemGroup("backpacked"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModItems.BACKPACK.get());
            }
        }.func_111229_a(new EnchantmentType[]{ENCHANTMENT_TYPE});
    }
}

