/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class SeparatePerspectiveModel
implements IModelGeometry<SeparatePerspectiveModel> {
    private final BlockModel baseModel;
    private final ImmutableMap<ItemCameraTransforms.TransformType, BlockModel> perspectives;

    public SeparatePerspectiveModel(BlockModel baseModel, ImmutableMap<ItemCameraTransforms.TransformType, BlockModel> perspectives) {
        this.baseModel = baseModel;
        this.perspectives = perspectives;
    }

    @Override
    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        return new BakedModel(owner.useSmoothLighting(), owner.isShadedInGui(), owner.isSideLit(), spriteGetter.apply(owner.resolveTexture("particle")), overrides, this.baseModel.func_228813_a_(bakery, this.baseModel, spriteGetter, modelTransform, modelLocation, owner.isSideLit()), (ImmutableMap<ItemCameraTransforms.TransformType, IBakedModel>)ImmutableMap.copyOf((Map)Maps.transformValues(this.perspectives, value -> value.func_228813_a_(bakery, value, spriteGetter, modelTransform, modelLocation, owner.isSideLit()))));
    }

    @Override
    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        textures.addAll(this.baseModel.func_225614_a_(modelGetter, missingTextureErrors));
        for (BlockModel model : this.perspectives.values()) {
            textures.addAll(model.func_225614_a_(modelGetter, missingTextureErrors));
        }
        return textures;
    }

    public static class Loader
    implements IModelLoader<SeparatePerspectiveModel> {
        public static final Loader INSTANCE = new Loader();
        public static final ImmutableBiMap<String, ItemCameraTransforms.TransformType> PERSPECTIVES = ImmutableBiMap.builder().put((Object)"none", (Object)ItemCameraTransforms.TransformType.NONE).put((Object)"third_person_left_hand", (Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND).put((Object)"third_person_right_hand", (Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).put((Object)"first_person_left_hand", (Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND).put((Object)"first_person_right_hand", (Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND).put((Object)"head", (Object)ItemCameraTransforms.TransformType.HEAD).put((Object)"gui", (Object)ItemCameraTransforms.TransformType.GUI).put((Object)"ground", (Object)ItemCameraTransforms.TransformType.GROUND).put((Object)"fixed", (Object)ItemCameraTransforms.TransformType.FIXED).build();

        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        @Override
        public SeparatePerspectiveModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)modelContents, (String)"base"), BlockModel.class);
            JsonObject perspectiveData = JSONUtils.func_152754_s((JsonObject)modelContents, (String)"perspectives");
            ImmutableMap.Builder perspectives = ImmutableMap.builder();
            for (Map.Entry perspective : PERSPECTIVES.entrySet()) {
                if (!perspectiveData.has((String)perspective.getKey())) continue;
                BlockModel perspectiveModel = (BlockModel)deserializationContext.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)perspectiveData, (String)((String)perspective.getKey())), BlockModel.class);
                perspectives.put(perspective.getValue(), (Object)perspectiveModel);
            }
            return new SeparatePerspectiveModel(baseModel, (ImmutableMap<ItemCameraTransforms.TransformType, BlockModel>)perspectives.build());
        }
    }

    public static class BakedModel
    implements IBakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final TextureAtlasSprite particle;
        private final ItemOverrideList overrides;
        private final IBakedModel baseModel;
        private final ImmutableMap<ItemCameraTransforms.TransformType, IBakedModel> perspectives;

        public BakedModel(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrideList overrides, IBakedModel baseModel, ImmutableMap<ItemCameraTransforms.TransformType, IBakedModel> perspectives) {
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = overrides;
            this.baseModel = baseModel;
            this.perspectives = perspectives;
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            return Collections.emptyList();
        }

        public boolean func_177555_b() {
            return this.isAmbientOcclusion;
        }

        public boolean func_177556_c() {
            return this.isGui3d;
        }

        public boolean func_230044_c_() {
            return this.isSideLit;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            if (this.perspectives.containsKey((Object)cameraTransformType)) {
                IBakedModel p = (IBakedModel)this.perspectives.get((Object)cameraTransformType);
                return p.handlePerspective(cameraTransformType, mat);
            }
            return this.baseModel.handlePerspective(cameraTransformType, mat);
        }
    }
}

