/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;

public interface ITagCollection<T> {
    public Map<ResourceLocation, ITag<T>> func_241833_a();

    @Nullable
    default public ITag<T> func_199910_a(ResourceLocation p_199910_1_) {
        return this.func_241833_a().get(p_199910_1_);
    }

    public ITag<T> func_241834_b(ResourceLocation var1);

    @Nullable
    public ResourceLocation func_232973_a_(ITag<T> var1);

    default public ResourceLocation func_232975_b_(ITag<T> p_232975_1_) {
        ResourceLocation resourcelocation = this.func_232973_a_(p_232975_1_);
        if (resourcelocation == null) {
            throw new IllegalStateException("Unrecognized tag");
        }
        return resourcelocation;
    }

    default public Collection<ResourceLocation> func_199908_a() {
        return this.func_241833_a().keySet();
    }

    default public Collection<ResourceLocation> func_199913_a(T p_199913_1_) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, ITag<T>> entry : this.func_241833_a().entrySet()) {
            if (!entry.getValue().func_230235_a_(p_199913_1_)) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    default public void func_242203_a(PacketBuffer p_242203_1_, DefaultedRegistry<T> p_242203_2_) {
        Map<ResourceLocation, ITag<T>> map = this.func_241833_a();
        p_242203_1_.func_150787_b(map.size());
        for (Map.Entry<ResourceLocation, ITag<T>> entry : map.entrySet()) {
            p_242203_1_.func_192572_a(entry.getKey());
            p_242203_1_.func_150787_b(entry.getValue().func_230236_b_().size());
            for (T t : entry.getValue().func_230236_b_()) {
                p_242203_1_.func_150787_b(p_242203_2_.func_148757_b(t));
            }
        }
    }

    public static <T> ITagCollection<T> func_242204_a(PacketBuffer p_242204_0_, Registry<T> p_242204_1_) {
        HashMap map = Maps.newHashMap();
        int i = p_242204_0_.func_150792_a();
        for (int j = 0; j < i; ++j) {
            ResourceLocation resourcelocation = p_242204_0_.func_192575_l();
            int k = p_242204_0_.func_150792_a();
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int l = 0; l < k; ++l) {
                builder.add(p_242204_1_.func_148745_a(p_242204_0_.func_150792_a()));
            }
            map.put(resourcelocation, ITag.func_232946_a_(builder.build()));
        }
        return ITagCollection.func_242202_a(map);
    }

    public static <T> ITagCollection<T> func_242205_c() {
        return ITagCollection.func_242202_a(ImmutableBiMap.of());
    }

    public static <T> ITagCollection<T> func_242202_a(Map<ResourceLocation, ITag<T>> p_242202_0_) {
        ImmutableBiMap bimap = ImmutableBiMap.copyOf(p_242202_0_);
        return new ITagCollection<T>((BiMap)bimap){
            private final ITag<T> field_242207_b = Tag.func_241284_a_();
            final /* synthetic */ BiMap val$bimap;
            {
                this.val$bimap = biMap;
            }

            @Override
            public ITag<T> func_241834_b(ResourceLocation p_241834_1_) {
                return (ITag)this.val$bimap.getOrDefault((Object)p_241834_1_, this.field_242207_b);
            }

            @Override
            @Nullable
            public ResourceLocation func_232973_a_(ITag<T> p_232973_1_) {
                return p_232973_1_ instanceof ITag.INamedTag ? ((ITag.INamedTag)p_232973_1_).func_230234_a_() : (ResourceLocation)this.val$bimap.inverse().get(p_232973_1_);
            }

            @Override
            public Map<ResourceLocation, ITag<T>> func_241833_a() {
                return this.val$bimap;
            }
        };
    }
}

