/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play;

import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import it.unimi.dsi.fastutil.ints.Int2ShortMap;
import it.unimi.dsi.fastutil.ints.Int2ShortOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.container.BeaconContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.MerchantContainer;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.WritableBookItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ServerRecipeBook;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketThreadUtil;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.client.CAnimateHandPacket;
import net.minecraft.network.play.client.CChatMessagePacket;
import net.minecraft.network.play.client.CClickWindowPacket;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.network.play.client.CCloseWindowPacket;
import net.minecraft.network.play.client.CConfirmTeleportPacket;
import net.minecraft.network.play.client.CConfirmTransactionPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.client.CEditBookPacket;
import net.minecraft.network.play.client.CEnchantItemPacket;
import net.minecraft.network.play.client.CEntityActionPacket;
import net.minecraft.network.play.client.CHeldItemChangePacket;
import net.minecraft.network.play.client.CInputPacket;
import net.minecraft.network.play.client.CJigsawBlockGeneratePacket;
import net.minecraft.network.play.client.CKeepAlivePacket;
import net.minecraft.network.play.client.CLockDifficultyPacket;
import net.minecraft.network.play.client.CMarkRecipeSeenPacket;
import net.minecraft.network.play.client.CMoveVehiclePacket;
import net.minecraft.network.play.client.CPickItemPacket;
import net.minecraft.network.play.client.CPlaceRecipePacket;
import net.minecraft.network.play.client.CPlayerAbilitiesPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemPacket;
import net.minecraft.network.play.client.CQueryEntityNBTPacket;
import net.minecraft.network.play.client.CQueryTileEntityNBTPacket;
import net.minecraft.network.play.client.CRenameItemPacket;
import net.minecraft.network.play.client.CResourcePackStatusPacket;
import net.minecraft.network.play.client.CSeenAdvancementsPacket;
import net.minecraft.network.play.client.CSelectTradePacket;
import net.minecraft.network.play.client.CSetDifficultyPacket;
import net.minecraft.network.play.client.CSpectatePacket;
import net.minecraft.network.play.client.CSteerBoatPacket;
import net.minecraft.network.play.client.CTabCompletePacket;
import net.minecraft.network.play.client.CUpdateBeaconPacket;
import net.minecraft.network.play.client.CUpdateCommandBlockPacket;
import net.minecraft.network.play.client.CUpdateJigsawBlockPacket;
import net.minecraft.network.play.client.CUpdateMinecartCommandBlockPacket;
import net.minecraft.network.play.client.CUpdateRecipeBookStatusPacket;
import net.minecraft.network.play.client.CUpdateSignPacket;
import net.minecraft.network.play.client.CUpdateStructureBlockPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SConfirmTransactionPacket;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.network.play.server.SKeepAlivePacket;
import net.minecraft.network.play.server.SMoveVehiclePacket;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.network.play.server.SQueryNBTResponsePacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.STabCompletePacket;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.JigsawTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.filter.IChatFilter;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPlayNetHandler
implements IServerPlayNetHandler {
    private static final Logger field_147370_c = LogManager.getLogger();
    public final NetworkManager field_147371_a;
    private final MinecraftServer field_147367_d;
    public ServerPlayerEntity field_147369_b;
    private int field_147368_e;
    private long field_194402_f;
    private boolean field_194403_g;
    private long field_194404_h;
    private int field_147374_l;
    private int field_147375_m;
    private final Int2ShortMap field_147372_n = new Int2ShortOpenHashMap();
    private double field_184349_l;
    private double field_184350_m;
    private double field_184351_n;
    private double field_184352_o;
    private double field_184353_p;
    private double field_184354_q;
    private Entity field_184355_r;
    private double field_184356_s;
    private double field_184357_t;
    private double field_184358_u;
    private double field_184359_v;
    private double field_184360_w;
    private double field_184361_x;
    private Vector3d field_184362_y;
    private int field_184363_z;
    private int field_184343_A;
    private boolean field_184344_B;
    private int field_147365_f;
    private boolean field_184345_D;
    private int field_184346_E;
    private int field_184347_F;
    private int field_184348_G;

    public ServerPlayNetHandler(MinecraftServer p_i1530_1_, NetworkManager p_i1530_2_, ServerPlayerEntity p_i1530_3_) {
        this.field_147367_d = p_i1530_1_;
        this.field_147371_a = p_i1530_2_;
        p_i1530_2_.func_150719_a((INetHandler)this);
        this.field_147369_b = p_i1530_3_;
        p_i1530_3_.field_71135_a = this;
        IChatFilter ichatfilter = p_i1530_3_.func_244529_Q();
        if (ichatfilter != null) {
            ichatfilter.func_244800_a();
        }
    }

    public void func_73660_a() {
        this.func_184342_d();
        this.field_147369_b.field_70169_q = this.field_147369_b.func_226277_ct_();
        this.field_147369_b.field_70167_r = this.field_147369_b.func_226278_cu_();
        this.field_147369_b.field_70166_s = this.field_147369_b.func_226281_cx_();
        this.field_147369_b.func_71127_g();
        this.field_147369_b.func_70080_a(this.field_184349_l, this.field_184350_m, this.field_184351_n, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
        ++this.field_147368_e;
        this.field_184348_G = this.field_184347_F;
        if (this.field_184344_B && !this.field_147369_b.func_70608_bn()) {
            if (++this.field_147365_f > 80) {
                field_147370_c.warn("{} was kicked for floating too long!", (Object)this.field_147369_b.func_200200_C_().getString());
                this.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.flying"));
                return;
            }
        } else {
            this.field_184344_B = false;
            this.field_147365_f = 0;
        }
        this.field_184355_r = this.field_147369_b.func_184208_bv();
        if (this.field_184355_r != this.field_147369_b && this.field_184355_r.func_184179_bs() == this.field_147369_b) {
            this.field_184356_s = this.field_184355_r.func_226277_ct_();
            this.field_184357_t = this.field_184355_r.func_226278_cu_();
            this.field_184358_u = this.field_184355_r.func_226281_cx_();
            this.field_184359_v = this.field_184355_r.func_226277_ct_();
            this.field_184360_w = this.field_184355_r.func_226278_cu_();
            this.field_184361_x = this.field_184355_r.func_226281_cx_();
            if (this.field_184345_D && this.field_147369_b.func_184208_bv().func_184179_bs() == this.field_147369_b) {
                if (++this.field_184346_E > 80) {
                    field_147370_c.warn("{} was kicked for floating a vehicle too long!", (Object)this.field_147369_b.func_200200_C_().getString());
                    this.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.flying"));
                    return;
                }
            } else {
                this.field_184345_D = false;
                this.field_184346_E = 0;
            }
        } else {
            this.field_184355_r = null;
            this.field_184345_D = false;
            this.field_184346_E = 0;
        }
        this.field_147367_d.func_213185_aS().func_76320_a("keepAlive");
        long i = Util.func_211177_b();
        if (i - this.field_194402_f >= 15000L) {
            if (this.field_194403_g) {
                this.func_194028_b((ITextComponent)new TranslationTextComponent("disconnect.timeout"));
            } else {
                this.field_194403_g = true;
                this.field_194402_f = i;
                this.field_194404_h = i;
                this.func_147359_a((IPacket<?>)new SKeepAlivePacket(this.field_194404_h));
            }
        }
        this.field_147367_d.func_213185_aS().func_76319_b();
        if (this.field_147374_l > 0) {
            --this.field_147374_l;
        }
        if (this.field_147375_m > 0) {
            --this.field_147375_m;
        }
        if (this.field_147369_b.func_154331_x() > 0L && this.field_147367_d.func_143007_ar() > 0 && Util.func_211177_b() - this.field_147369_b.func_154331_x() > (long)(this.field_147367_d.func_143007_ar() * 1000 * 60)) {
            this.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.idling"));
        }
    }

    public void func_184342_d() {
        this.field_184349_l = this.field_147369_b.func_226277_ct_();
        this.field_184350_m = this.field_147369_b.func_226278_cu_();
        this.field_184351_n = this.field_147369_b.func_226281_cx_();
        this.field_184352_o = this.field_147369_b.func_226277_ct_();
        this.field_184353_p = this.field_147369_b.func_226278_cu_();
        this.field_184354_q = this.field_147369_b.func_226281_cx_();
    }

    public NetworkManager func_147298_b() {
        return this.field_147371_a;
    }

    private boolean func_217264_d() {
        return this.field_147367_d.func_213199_b(this.field_147369_b.func_146103_bH());
    }

    public void func_194028_b(ITextComponent p_194028_1_) {
        this.field_147371_a.func_201058_a((IPacket<?>)new SDisconnectPacket(p_194028_1_), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_210161_2_ -> this.field_147371_a.func_150718_a(p_194028_1_)));
        this.field_147371_a.func_150721_g();
        this.field_147367_d.func_213167_f(this.field_147371_a::func_179293_l);
    }

    private <T> void func_244533_a(T p_244533_1_, Consumer<T> p_244533_2_, BiFunction<IChatFilter, T, CompletableFuture<Optional<T>>> p_244533_3_) {
        MinecraftServer threadtaskexecutor = this.field_147369_b.func_71121_q().func_73046_m();
        Consumer<Object> consumer = p_244545_2_ -> {
            if (this.func_147298_b().func_150724_d()) {
                p_244533_2_.accept(p_244545_2_);
            } else {
                field_147370_c.debug("Ignoring packet due to disconnection");
            }
        };
        IChatFilter ichatfilter = this.field_147369_b.func_244529_Q();
        if (ichatfilter != null) {
            p_244533_3_.apply(ichatfilter, (IChatFilter)p_244533_1_).thenAcceptAsync(p_244539_1_ -> p_244539_1_.ifPresent(consumer), (Executor)((Object)threadtaskexecutor));
        } else {
            threadtaskexecutor.execute(() -> consumer.accept(p_244533_1_));
        }
    }

    private void func_244535_a(String p_244535_1_, Consumer<String> p_244535_2_) {
        this.func_244533_a(p_244535_1_, p_244535_2_, IChatFilter::func_244432_a);
    }

    private void func_244537_a(List<String> p_244537_1_, Consumer<List<String>> p_244537_2_) {
        this.func_244533_a(p_244537_1_, p_244537_2_, IChatFilter::func_244433_a);
    }

    public void func_147358_a(CInputPacket p_147358_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147358_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_110430_a(p_147358_1_.func_149620_c(), p_147358_1_.func_192620_b(), p_147358_1_.func_149618_e(), p_147358_1_.func_229755_e_());
    }

    private static boolean func_183006_b(CPlayerPacket p_183006_0_) {
        if (Doubles.isFinite((double)p_183006_0_.func_186997_a(0.0)) && Doubles.isFinite((double)p_183006_0_.func_186996_b(0.0)) && Doubles.isFinite((double)p_183006_0_.func_187000_c(0.0)) && Floats.isFinite((float)p_183006_0_.func_186998_b(0.0f)) && Floats.isFinite((float)p_183006_0_.func_186999_a(0.0f))) {
            return Math.abs(p_183006_0_.func_186997_a(0.0)) > 3.0E7 || Math.abs(p_183006_0_.func_186996_b(0.0)) > 3.0E7 || Math.abs(p_183006_0_.func_187000_c(0.0)) > 3.0E7;
        }
        return true;
    }

    private static boolean func_184341_b(CMoveVehiclePacket p_184341_0_) {
        return !Doubles.isFinite((double)p_184341_0_.func_187004_a()) || !Doubles.isFinite((double)p_184341_0_.func_187002_b()) || !Doubles.isFinite((double)p_184341_0_.func_187003_c()) || !Floats.isFinite((float)p_184341_0_.func_187005_e()) || !Floats.isFinite((float)p_184341_0_.func_187006_d());
    }

    public void func_184338_a(CMoveVehiclePacket p_184338_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_184338_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (ServerPlayNetHandler.func_184341_b(p_184338_1_)) {
            this.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.invalid_vehicle_movement"));
        } else {
            Entity entity = this.field_147369_b.func_184208_bv();
            if (entity != this.field_147369_b && entity.func_184179_bs() == this.field_147369_b && entity == this.field_184355_r) {
                ServerWorld serverworld = this.field_147369_b.func_71121_q();
                double d0 = entity.func_226277_ct_();
                double d1 = entity.func_226278_cu_();
                double d2 = entity.func_226281_cx_();
                double d3 = p_184338_1_.func_187004_a();
                double d4 = p_184338_1_.func_187002_b();
                double d5 = p_184338_1_.func_187003_c();
                float f = p_184338_1_.func_187006_d();
                float f1 = p_184338_1_.func_187005_e();
                double d6 = d3 - this.field_184356_s;
                double d7 = d4 - this.field_184357_t;
                double d8 = d5 - this.field_184358_u;
                double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                double d9 = entity.func_213322_ci().func_189985_c();
                if (d10 - d9 > 100.0 && !this.func_217264_d()) {
                    field_147370_c.warn("{} (vehicle of {}) moved too quickly! {},{},{}", (Object)entity.func_200200_C_().getString(), (Object)this.field_147369_b.func_200200_C_().getString(), (Object)d6, (Object)d7, (Object)d8);
                    this.field_147371_a.func_179290_a((IPacket<?>)new SMoveVehiclePacket(entity));
                    return;
                }
                boolean flag = serverworld.func_226665_a__(entity, entity.func_174813_aQ().func_186664_h(0.0625));
                d6 = d3 - this.field_184359_v;
                d7 = d4 - this.field_184360_w - 1.0E-6;
                d8 = d5 - this.field_184361_x;
                entity.func_213315_a(MoverType.PLAYER, new Vector3d(d6, d7, d8));
                d6 = d3 - entity.func_226277_ct_();
                d7 = d4 - entity.func_226278_cu_();
                if (d7 > -0.5 || d7 < 0.5) {
                    d7 = 0.0;
                }
                d8 = d5 - entity.func_226281_cx_();
                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                boolean flag1 = false;
                if (d10 > 0.0625) {
                    flag1 = true;
                    field_147370_c.warn("{} (vehicle of {}) moved wrongly! {}", (Object)entity.func_200200_C_().getString(), (Object)this.field_147369_b.func_200200_C_().getString(), (Object)Math.sqrt(d10));
                }
                entity.func_70080_a(d3, d4, d5, f, f1);
                this.field_147369_b.func_70080_a(d3, d4, d5, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                boolean flag2 = serverworld.func_226665_a__(entity, entity.func_174813_aQ().func_186664_h(0.0625));
                if (flag && (flag1 || !flag2)) {
                    entity.func_70080_a(d0, d1, d2, f, f1);
                    this.field_147369_b.func_70080_a(d3, d4, d5, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                    this.field_147371_a.func_179290_a((IPacket<?>)new SMoveVehiclePacket(entity));
                    return;
                }
                this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
                this.field_147369_b.func_71000_j(this.field_147369_b.func_226277_ct_() - d0, this.field_147369_b.func_226278_cu_() - d1, this.field_147369_b.func_226281_cx_() - d2);
                this.field_184345_D = d7 >= -0.03125 && !this.field_147367_d.func_71231_X() && this.func_241162_a_(entity);
                this.field_184359_v = entity.func_226277_ct_();
                this.field_184360_w = entity.func_226278_cu_();
                this.field_184361_x = entity.func_226281_cx_();
            }
        }
    }

    private boolean func_241162_a_(Entity p_241162_1_) {
        return BlockPos.func_239581_a_((AxisAlignedBB)p_241162_1_.func_174813_aQ().func_186662_g(0.0625).func_72321_a(0.0, -0.55, 0.0)).allMatch(b -> p_241162_1_.field_70170_p.func_180495_p((BlockPos)b).isAir((IBlockReader)((Object)p_241162_1_.field_70170_p), (BlockPos)b));
    }

    public void func_184339_a(CConfirmTeleportPacket p_184339_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_184339_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (p_184339_1_.func_186987_a() == this.field_184363_z) {
            this.field_147369_b.func_70080_a(this.field_184362_y.field_72450_a, this.field_184362_y.field_72448_b, this.field_184362_y.field_72449_c, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
            this.field_184352_o = this.field_184362_y.field_72450_a;
            this.field_184353_p = this.field_184362_y.field_72448_b;
            this.field_184354_q = this.field_184362_y.field_72449_c;
            if (this.field_147369_b.func_184850_K()) {
                this.field_147369_b.func_184846_L();
            }
            this.field_184362_y = null;
        }
    }

    public void func_191984_a(CMarkRecipeSeenPacket p_191984_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_191984_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        this.field_147367_d.func_199529_aN().func_215367_a(p_191984_1_.func_244321_b()).ifPresent(arg_0 -> ((ServerRecipeBook)this.field_147369_b.func_192037_E()).func_194074_f(arg_0));
    }

    public void func_241831_a(CUpdateRecipeBookStatusPacket p_241831_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_241831_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_192037_E().func_242144_a(p_241831_1_.func_244317_b(), p_241831_1_.func_244318_c(), p_241831_1_.func_244319_d());
    }

    public void func_194027_a(CSeenAdvancementsPacket p_194027_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_194027_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (p_194027_1_.func_194162_b() == CSeenAdvancementsPacket.Action.OPENED_TAB) {
            ResourceLocation resourcelocation = p_194027_1_.func_194165_c();
            Advancement advancement = this.field_147367_d.func_191949_aK().func_192778_a(resourcelocation);
            if (advancement != null) {
                this.field_147369_b.func_192039_O().func_194220_a(advancement);
            }
        }
    }

    public void func_195518_a(CTabCompletePacket p_195518_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_195518_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        StringReader stringreader = new StringReader(p_195518_1_.func_197707_b());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        ParseResults parseresults = this.field_147367_d.func_195571_aL().func_197054_a().parse(stringreader, (Object)this.field_147369_b.func_195051_bN());
        this.field_147367_d.func_195571_aL().func_197054_a().getCompletionSuggestions(parseresults).thenAccept(p_195519_2_ -> this.field_147371_a.func_179290_a((IPacket<?>)new STabCompletePacket(p_195518_1_.func_197709_a(), p_195519_2_)));
    }

    public void func_210153_a(CUpdateCommandBlockPacket p_210153_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_210153_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (!this.field_147367_d.func_82356_Z()) {
            this.field_147369_b.func_145747_a((ITextComponent)new TranslationTextComponent("advMode.notEnabled"), Util.field_240973_b_);
        } else if (!this.field_147369_b.func_195070_dx()) {
            this.field_147369_b.func_145747_a((ITextComponent)new TranslationTextComponent("advMode.notAllowed"), Util.field_240973_b_);
        } else {
            CommandBlockLogic commandblocklogic = null;
            CommandBlockTileEntity commandblocktileentity = null;
            BlockPos blockpos = p_210153_1_.func_210361_a();
            TileEntity tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos);
            if (tileentity instanceof CommandBlockTileEntity) {
                commandblocktileentity = (CommandBlockTileEntity)tileentity;
                commandblocklogic = commandblocktileentity.func_145993_a();
            }
            String s = p_210153_1_.func_210359_b();
            boolean flag = p_210153_1_.func_210363_c();
            if (commandblocklogic != null) {
                CommandBlockTileEntity.Mode commandblocktileentity$mode = commandblocktileentity.func_184251_i();
                Direction direction = (Direction)((Object)this.field_147369_b.field_70170_p.func_180495_p(blockpos).func_177229_b((Property)CommandBlockBlock.field_185564_a));
                switch (p_210153_1_.func_210360_f()) {
                    case SEQUENCE: {
                        BlockState blockstate1 = Blocks.field_185777_dd.func_176223_P();
                        this.field_147369_b.field_70170_p.func_180501_a(blockpos, (BlockState)((Object)((BlockState)((Object)blockstate1.func_206870_a((Property)CommandBlockBlock.field_185564_a, (Comparable)((Object)direction)))).func_206870_a((Property)CommandBlockBlock.field_185565_b, Boolean.valueOf(p_210153_1_.func_210364_d()))), 2);
                        break;
                    }
                    case AUTO: {
                        BlockState blockstate = Blocks.field_185776_dc.func_176223_P();
                        this.field_147369_b.field_70170_p.func_180501_a(blockpos, (BlockState)((Object)((BlockState)((Object)blockstate.func_206870_a((Property)CommandBlockBlock.field_185564_a, (Comparable)((Object)direction)))).func_206870_a((Property)CommandBlockBlock.field_185565_b, Boolean.valueOf(p_210153_1_.func_210364_d()))), 2);
                        break;
                    }
                    default: {
                        BlockState blockstate2 = Blocks.field_150483_bI.func_176223_P();
                        this.field_147369_b.field_70170_p.func_180501_a(blockpos, (BlockState)((Object)((BlockState)((Object)blockstate2.func_206870_a((Property)CommandBlockBlock.field_185564_a, (Comparable)((Object)direction)))).func_206870_a((Property)CommandBlockBlock.field_185565_b, Boolean.valueOf(p_210153_1_.func_210364_d()))), 2);
                    }
                }
                tileentity.func_145829_t();
                this.field_147369_b.field_70170_p.func_175690_a(blockpos, tileentity);
                commandblocklogic.func_145752_a(s);
                commandblocklogic.func_175573_a(flag);
                if (!flag) {
                    commandblocklogic.func_145750_b((ITextComponent)null);
                }
                commandblocktileentity.func_184253_b(p_210153_1_.func_210362_e());
                if (commandblocktileentity$mode != p_210153_1_.func_210360_f()) {
                    commandblocktileentity.func_226987_h_();
                }
                commandblocklogic.func_145756_e();
                if (!StringUtils.func_151246_b((String)s)) {
                    this.field_147369_b.func_145747_a((ITextComponent)new TranslationTextComponent("advMode.setCommand.success", s), Util.field_240973_b_);
                }
            }
        }
    }

    public void func_210158_a(CUpdateMinecartCommandBlockPacket p_210158_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_210158_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (!this.field_147367_d.func_82356_Z()) {
            this.field_147369_b.func_145747_a((ITextComponent)new TranslationTextComponent("advMode.notEnabled"), Util.field_240973_b_);
        } else if (!this.field_147369_b.func_195070_dx()) {
            this.field_147369_b.func_145747_a((ITextComponent)new TranslationTextComponent("advMode.notAllowed"), Util.field_240973_b_);
        } else {
            CommandBlockLogic commandblocklogic = p_210158_1_.func_210371_a(this.field_147369_b.field_70170_p);
            if (commandblocklogic != null) {
                commandblocklogic.func_145752_a(p_210158_1_.func_210372_a());
                commandblocklogic.func_175573_a(p_210158_1_.func_210373_b());
                if (!p_210158_1_.func_210373_b()) {
                    commandblocklogic.func_145750_b((ITextComponent)null);
                }
                commandblocklogic.func_145756_e();
                this.field_147369_b.func_145747_a((ITextComponent)new TranslationTextComponent("advMode.setCommand.success", p_210158_1_.func_210372_a()), Util.field_240973_b_);
            }
        }
    }

    public void func_210152_a(CPickItemPacket p_210152_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_210152_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        this.field_147369_b.field_71071_by.func_184430_d(p_210152_1_.func_210349_a());
        this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(-2, this.field_147369_b.field_71071_by.field_70461_c, this.field_147369_b.field_71071_by.func_70301_a(this.field_147369_b.field_71071_by.field_70461_c)));
        this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(-2, p_210152_1_.func_210349_a(), this.field_147369_b.field_71071_by.func_70301_a(p_210152_1_.func_210349_a())));
        this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SHeldItemChangePacket(this.field_147369_b.field_71071_by.field_70461_c));
    }

    public void func_210155_a(CRenameItemPacket p_210155_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_210155_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71070_bA instanceof RepairContainer) {
            RepairContainer repaircontainer = (RepairContainer)((Object)this.field_147369_b.field_71070_bA);
            String s = SharedConstants.func_71565_a(p_210155_1_.func_210351_a());
            if (s.length() <= 35) {
                repaircontainer.func_82850_a(s);
            }
        }
    }

    public void func_210154_a(CUpdateBeaconPacket p_210154_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_210154_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71070_bA instanceof BeaconContainer) {
            ((BeaconContainer)this.field_147369_b.field_71070_bA).func_216966_c(p_210154_1_.func_210355_a(), p_210154_1_.func_210356_b());
        }
    }

    public void func_210157_a(CUpdateStructureBlockPacket p_210157_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_210157_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_195070_dx()) {
            BlockPos blockpos = p_210157_1_.func_210380_a();
            BlockState blockstate = this.field_147369_b.field_70170_p.func_180495_p(blockpos);
            TileEntity tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos);
            if (tileentity instanceof StructureBlockTileEntity) {
                StructureBlockTileEntity structureblocktileentity = (StructureBlockTileEntity)tileentity;
                structureblocktileentity.func_184405_a(p_210157_1_.func_210378_c());
                structureblocktileentity.func_184404_a(p_210157_1_.func_210377_d());
                structureblocktileentity.func_184414_b(p_210157_1_.func_210383_e());
                structureblocktileentity.func_184409_c(p_210157_1_.func_210385_f());
                structureblocktileentity.func_184411_a(p_210157_1_.func_210386_g());
                structureblocktileentity.func_184408_a(p_210157_1_.func_210379_h());
                structureblocktileentity.func_184410_b(p_210157_1_.func_210388_i());
                structureblocktileentity.func_184406_a(p_210157_1_.func_210389_j());
                structureblocktileentity.func_189703_e(p_210157_1_.func_210390_k());
                structureblocktileentity.func_189710_f(p_210157_1_.func_210387_l());
                structureblocktileentity.func_189718_a(p_210157_1_.func_210382_m());
                structureblocktileentity.func_189725_a(p_210157_1_.func_210381_n());
                if (structureblocktileentity.func_208404_d()) {
                    String s = structureblocktileentity.func_189715_d();
                    if (p_210157_1_.func_210384_b() == StructureBlockTileEntity.UpdateCommand.SAVE_AREA) {
                        if (structureblocktileentity.func_184419_m()) {
                            this.field_147369_b.func_146105_b((ITextComponent)new TranslationTextComponent("structure_block.save_success", s), false);
                        } else {
                            this.field_147369_b.func_146105_b((ITextComponent)new TranslationTextComponent("structure_block.save_failure", s), false);
                        }
                    } else if (p_210157_1_.func_210384_b() == StructureBlockTileEntity.UpdateCommand.LOAD_AREA) {
                        if (!structureblocktileentity.func_189709_F()) {
                            this.field_147369_b.func_146105_b((ITextComponent)new TranslationTextComponent("structure_block.load_not_found", s), false);
                        } else if (structureblocktileentity.func_242687_a(this.field_147369_b.func_71121_q())) {
                            this.field_147369_b.func_146105_b((ITextComponent)new TranslationTextComponent("structure_block.load_success", s), false);
                        } else {
                            this.field_147369_b.func_146105_b((ITextComponent)new TranslationTextComponent("structure_block.load_prepare", s), false);
                        }
                    } else if (p_210157_1_.func_210384_b() == StructureBlockTileEntity.UpdateCommand.SCAN_AREA) {
                        if (structureblocktileentity.func_184417_l()) {
                            this.field_147369_b.func_146105_b((ITextComponent)new TranslationTextComponent("structure_block.size_success", s), false);
                        } else {
                            this.field_147369_b.func_146105_b((ITextComponent)new TranslationTextComponent("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.field_147369_b.func_146105_b((ITextComponent)new TranslationTextComponent("structure_block.invalid_structure_name", p_210157_1_.func_210377_d()), false);
                }
                structureblocktileentity.func_70296_d();
                this.field_147369_b.field_70170_p.func_184138_a(blockpos, blockstate, blockstate, 3);
            }
        }
    }

    public void func_217262_a(CUpdateJigsawBlockPacket p_217262_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_217262_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_195070_dx()) {
            BlockPos blockpos = p_217262_1_.func_218789_b();
            BlockState blockstate = this.field_147369_b.field_70170_p.func_180495_p(blockpos);
            TileEntity tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos);
            if (tileentity instanceof JigsawTileEntity) {
                JigsawTileEntity jigsawtileentity = (JigsawTileEntity)tileentity;
                jigsawtileentity.func_235664_a_(p_217262_1_.func_240851_c_());
                jigsawtileentity.func_235666_b_(p_217262_1_.func_240852_d_());
                jigsawtileentity.func_235667_c_(p_217262_1_.func_240853_e_());
                jigsawtileentity.func_214055_a(p_217262_1_.func_218788_e());
                jigsawtileentity.func_235662_a_(p_217262_1_.func_240854_g_());
                jigsawtileentity.func_70296_d();
                this.field_147369_b.field_70170_p.func_184138_a(blockpos, blockstate, blockstate, 3);
            }
        }
    }

    public void func_230549_a_(CJigsawBlockGeneratePacket p_230549_1_) {
        BlockPos blockpos;
        TileEntity tileentity;
        PacketThreadUtil.func_218796_a((IPacket)p_230549_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_195070_dx() && (tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos = p_230549_1_.func_240844_b_())) instanceof JigsawTileEntity) {
            JigsawTileEntity jigsawtileentity = (JigsawTileEntity)tileentity;
            jigsawtileentity.func_235665_a_(this.field_147369_b.func_71121_q(), p_230549_1_.func_240845_c_(), p_230549_1_.func_240846_d_());
        }
    }

    public void func_210159_a(CSelectTradePacket p_210159_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_210159_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        int i = p_210159_1_.func_210353_a();
        Container container = this.field_147369_b.field_71070_bA;
        if (container instanceof MerchantContainer) {
            MerchantContainer merchantcontainer = (MerchantContainer)container;
            merchantcontainer.func_75175_c(i);
            merchantcontainer.func_217046_g(i);
        }
    }

    public void func_210156_a(CEditBookPacket p_210156_1_) {
        CompoundNBT compoundnbt;
        ItemStack itemstack = p_210156_1_.func_210346_a();
        if (itemstack.func_77973_b() == Items.field_151099_bA && WritableBookItem.func_150930_a((CompoundNBT)(compoundnbt = itemstack.func_77978_p()))) {
            ArrayList list = Lists.newArrayList();
            boolean flag = p_210156_1_.func_210345_b();
            if (flag) {
                list.add(compoundnbt.func_74779_i("title"));
            }
            ListNBT listnbt = compoundnbt.func_150295_c("pages", 8);
            for (int i = 0; i < listnbt.size(); ++i) {
                list.add(listnbt.func_150307_f(i));
            }
            int j = p_210156_1_.func_244708_d();
            if (PlayerInventory.func_184435_e(j) || j == 40) {
                this.func_244537_a(list, flag ? p_244543_2_ -> this.func_244534_a((String)p_244543_2_.get(0), p_244543_2_.subList(1, p_244543_2_.size()), j) : p_244531_2_ -> this.func_244536_a((List<String>)p_244531_2_, j));
            }
        }
    }

    private void func_244536_a(List<String> p_244536_1_, int p_244536_2_) {
        ItemStack itemstack = this.field_147369_b.field_71071_by.func_70301_a(p_244536_2_);
        if (itemstack.func_77973_b() == Items.field_151099_bA) {
            ListNBT listnbt = new ListNBT();
            p_244536_1_.stream().map(StringNBT::func_229705_a_).forEach(arg_0 -> listnbt.add(arg_0));
            itemstack.func_77983_a("pages", (INBT)listnbt);
        }
    }

    private void func_244534_a(String p_244534_1_, List<String> p_244534_2_, int p_244534_3_) {
        ItemStack itemstack = this.field_147369_b.field_71071_by.func_70301_a(p_244534_3_);
        if (itemstack.func_77973_b() == Items.field_151099_bA) {
            ItemStack itemstack1 = new ItemStack(Items.field_151164_bB);
            CompoundNBT compoundnbt = itemstack.func_77978_p();
            if (compoundnbt != null) {
                itemstack1.func_77982_d(compoundnbt.func_74737_b());
            }
            itemstack1.func_77983_a("author", StringNBT.func_229705_a_(this.field_147369_b.func_200200_C_().getString()));
            itemstack1.func_77983_a("title", StringNBT.func_229705_a_(p_244534_1_));
            ListNBT listnbt = new ListNBT();
            for (String s : p_244534_2_) {
                StringTextComponent itextcomponent = new StringTextComponent(s);
                String s1 = ITextComponent.Serializer.func_150696_a((ITextComponent)itextcomponent);
                listnbt.add((Object)StringNBT.func_229705_a_(s1));
            }
            itemstack1.func_77983_a("pages", (INBT)listnbt);
            this.field_147369_b.field_71071_by.func_70299_a(p_244534_3_, itemstack1);
        }
    }

    public void func_211526_a(CQueryEntityNBTPacket p_211526_1_) {
        Entity entity;
        PacketThreadUtil.func_218796_a((IPacket)p_211526_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_211513_k(2) && (entity = this.field_147369_b.func_71121_q().func_73045_a(p_211526_1_.func_211720_c())) != null) {
            CompoundNBT compoundnbt = entity.func_189511_e(new CompoundNBT());
            this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SQueryNBTResponsePacket(p_211526_1_.func_211721_b(), compoundnbt));
        }
    }

    public void func_211525_a(CQueryTileEntityNBTPacket p_211525_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_211525_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_211513_k(2)) {
            TileEntity tileentity = this.field_147369_b.func_71121_q().func_175625_s(p_211525_1_.func_211717_c());
            CompoundNBT compoundnbt = tileentity != null ? tileentity.func_189515_b(new CompoundNBT()) : null;
            this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SQueryNBTResponsePacket(p_211525_1_.func_211716_b(), compoundnbt));
        }
    }

    public void func_147347_a(CPlayerPacket p_147347_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147347_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (ServerPlayNetHandler.func_183006_b(p_147347_1_)) {
            this.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.invalid_player_movement"));
        } else {
            ServerWorld serverworld = this.field_147369_b.func_71121_q();
            if (!this.field_147369_b.field_71136_j) {
                if (this.field_147368_e == 0) {
                    this.func_184342_d();
                }
                if (this.field_184362_y != null) {
                    if (this.field_147368_e - this.field_184343_A > 20) {
                        this.field_184343_A = this.field_147368_e;
                        this.func_147364_a(this.field_184362_y.field_72450_a, this.field_184362_y.field_72448_b, this.field_184362_y.field_72449_c, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                    }
                } else {
                    this.field_184343_A = this.field_147368_e;
                    if (this.field_147369_b.func_184218_aH()) {
                        this.field_147369_b.func_70080_a(this.field_147369_b.func_226277_ct_(), this.field_147369_b.func_226278_cu_(), this.field_147369_b.func_226281_cx_(), p_147347_1_.func_186999_a(this.field_147369_b.field_70177_z), p_147347_1_.func_186998_b(this.field_147369_b.field_70125_A));
                        this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
                    } else {
                        double d0 = this.field_147369_b.func_226277_ct_();
                        double d1 = this.field_147369_b.func_226278_cu_();
                        double d2 = this.field_147369_b.func_226281_cx_();
                        double d3 = this.field_147369_b.func_226278_cu_();
                        double d4 = p_147347_1_.func_186997_a(this.field_147369_b.func_226277_ct_());
                        double d5 = p_147347_1_.func_186996_b(this.field_147369_b.func_226278_cu_());
                        double d6 = p_147347_1_.func_187000_c(this.field_147369_b.func_226281_cx_());
                        float f = p_147347_1_.func_186999_a(this.field_147369_b.field_70177_z);
                        float f1 = p_147347_1_.func_186998_b(this.field_147369_b.field_70125_A);
                        double d7 = d4 - this.field_184349_l;
                        double d8 = d5 - this.field_184350_m;
                        double d9 = d6 - this.field_184351_n;
                        double d10 = this.field_147369_b.func_213322_ci().func_189985_c();
                        double d11 = d7 * d7 + d8 * d8 + d9 * d9;
                        if (this.field_147369_b.func_70608_bn()) {
                            if (d11 > 1.0) {
                                this.func_147364_a(this.field_147369_b.func_226277_ct_(), this.field_147369_b.func_226278_cu_(), this.field_147369_b.func_226281_cx_(), p_147347_1_.func_186999_a(this.field_147369_b.field_70177_z), p_147347_1_.func_186998_b(this.field_147369_b.field_70125_A));
                            }
                        } else {
                            boolean flag;
                            ++this.field_184347_F;
                            int i = this.field_184347_F - this.field_184348_G;
                            if (i > 5) {
                                field_147370_c.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)i);
                                i = 1;
                            }
                            if (!(this.field_147369_b.func_184850_K() || this.field_147369_b.func_71121_q().func_82736_K().func_223586_b(GameRules.field_223615_r) && this.field_147369_b.func_184613_cA())) {
                                float f2;
                                float f3 = f2 = this.field_147369_b.func_184613_cA() ? 300.0f : 100.0f;
                                if (d11 - d10 > (double)(f2 * (float)i) && !this.func_217264_d()) {
                                    field_147370_c.warn("{} moved too quickly! {},{},{}", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)d7, (Object)d8, (Object)d9);
                                    this.func_147364_a(this.field_147369_b.func_226277_ct_(), this.field_147369_b.func_226278_cu_(), this.field_147369_b.func_226281_cx_(), this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                                    return;
                                }
                            }
                            AxisAlignedBB axisalignedbb = this.field_147369_b.func_174813_aQ();
                            d7 = d4 - this.field_184352_o;
                            d8 = d5 - this.field_184353_p;
                            d9 = d6 - this.field_184354_q;
                            boolean bl = flag = d8 > 0.0;
                            if (this.field_147369_b.func_233570_aj_() && !p_147347_1_.func_149465_i() && flag) {
                                this.field_147369_b.func_70664_aZ();
                            }
                            this.field_147369_b.func_213315_a(MoverType.PLAYER, new Vector3d(d7, d8, d9));
                            d7 = d4 - this.field_147369_b.func_226277_ct_();
                            d8 = d5 - this.field_147369_b.func_226278_cu_();
                            if (d8 > -0.5 || d8 < 0.5) {
                                d8 = 0.0;
                            }
                            d9 = d6 - this.field_147369_b.func_226281_cx_();
                            d11 = d7 * d7 + d8 * d8 + d9 * d9;
                            boolean flag1 = false;
                            if (!this.field_147369_b.func_184850_K() && d11 > 0.0625 && !this.field_147369_b.func_70608_bn() && !this.field_147369_b.field_71134_c.func_73083_d() && this.field_147369_b.field_71134_c.func_73081_b() != GameType.SPECTATOR) {
                                flag1 = true;
                                field_147370_c.warn("{} moved wrongly!", (Object)this.field_147369_b.func_200200_C_().getString());
                            }
                            this.field_147369_b.func_70080_a(d4, d5, d6, f, f1);
                            if (this.field_147369_b.field_70145_X || this.field_147369_b.func_70608_bn() || (!flag1 || !serverworld.func_226665_a__(this.field_147369_b, axisalignedbb)) && !this.func_241163_a_((IWorldReader)((Object)serverworld), axisalignedbb)) {
                                this.field_184344_B = d8 >= -0.03125 && this.field_147369_b.field_71134_c.func_73081_b() != GameType.SPECTATOR && !this.field_147367_d.func_71231_X() && !this.field_147369_b.field_71075_bZ.field_75101_c && !this.field_147369_b.func_70644_a(Effects.field_188424_y) && !this.field_147369_b.func_184613_cA() && this.func_241162_a_(this.field_147369_b);
                                this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
                                this.field_147369_b.func_71122_b(this.field_147369_b.func_226278_cu_() - d3, p_147347_1_.func_149465_i());
                                this.field_147369_b.func_230245_c_(p_147347_1_.func_149465_i());
                                if (flag) {
                                    this.field_147369_b.field_70143_R = 0.0f;
                                }
                                this.field_147369_b.func_71000_j(this.field_147369_b.func_226277_ct_() - d0, this.field_147369_b.func_226278_cu_() - d1, this.field_147369_b.func_226281_cx_() - d2);
                                this.field_184352_o = this.field_147369_b.func_226277_ct_();
                                this.field_184353_p = this.field_147369_b.func_226278_cu_();
                                this.field_184354_q = this.field_147369_b.func_226281_cx_();
                            } else {
                                this.func_147364_a(d0, d1, d2, f, f1);
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean func_241163_a_(IWorldReader p_241163_1_, AxisAlignedBB p_241163_2_) {
        Stream stream = p_241163_1_.func_234867_d_(this.field_147369_b, this.field_147369_b.func_174813_aQ().func_186664_h((double)1.0E-5f), p_241167_0_ -> true);
        VoxelShape voxelshape = VoxelShapes.func_197881_a((AxisAlignedBB)p_241163_2_.func_186664_h((double)1.0E-5f));
        return stream.anyMatch(p_241164_1_ -> !VoxelShapes.func_197879_c((VoxelShape)p_241164_1_, (VoxelShape)voxelshape, (IBooleanFunction)IBooleanFunction.field_223238_i_));
    }

    public void func_147364_a(double p_147364_1_, double p_147364_3_, double p_147364_5_, float p_147364_7_, float p_147364_8_) {
        this.func_175089_a(p_147364_1_, p_147364_3_, p_147364_5_, p_147364_7_, p_147364_8_, Collections.emptySet());
    }

    public void func_175089_a(double p_175089_1_, double p_175089_3_, double p_175089_5_, float p_175089_7_, float p_175089_8_, Set<SPlayerPositionLookPacket.Flags> p_175089_9_) {
        double d0 = p_175089_9_.contains(SPlayerPositionLookPacket.Flags.X) ? this.field_147369_b.func_226277_ct_() : 0.0;
        double d1 = p_175089_9_.contains(SPlayerPositionLookPacket.Flags.Y) ? this.field_147369_b.func_226278_cu_() : 0.0;
        double d2 = p_175089_9_.contains(SPlayerPositionLookPacket.Flags.Z) ? this.field_147369_b.func_226281_cx_() : 0.0;
        float f = p_175089_9_.contains(SPlayerPositionLookPacket.Flags.Y_ROT) ? this.field_147369_b.field_70177_z : 0.0f;
        float f1 = p_175089_9_.contains(SPlayerPositionLookPacket.Flags.X_ROT) ? this.field_147369_b.field_70125_A : 0.0f;
        this.field_184362_y = new Vector3d(p_175089_1_, p_175089_3_, p_175089_5_);
        if (++this.field_184363_z == Integer.MAX_VALUE) {
            this.field_184363_z = 0;
        }
        this.field_184343_A = this.field_147368_e;
        this.field_147369_b.func_70080_a(p_175089_1_, p_175089_3_, p_175089_5_, p_175089_7_, p_175089_8_);
        this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SPlayerPositionLookPacket(p_175089_1_ - d0, p_175089_3_ - d1, p_175089_5_ - d2, p_175089_7_ - f, p_175089_8_ - f1, p_175089_9_, this.field_184363_z));
    }

    public void func_147345_a(CPlayerDiggingPacket p_147345_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147345_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        BlockPos blockpos = p_147345_1_.func_179715_a();
        this.field_147369_b.func_143004_u();
        CPlayerDiggingPacket.Action cplayerdiggingpacket$action = p_147345_1_.func_180762_c();
        switch (cplayerdiggingpacket$action) {
            case SWAP_ITEM_WITH_OFFHAND: {
                if (!this.field_147369_b.func_175149_v()) {
                    ItemStack itemstack = this.field_147369_b.func_184586_b(Hand.OFF_HAND);
                    this.field_147369_b.func_184611_a(Hand.OFF_HAND, this.field_147369_b.func_184586_b(Hand.MAIN_HAND));
                    this.field_147369_b.func_184611_a(Hand.MAIN_HAND, itemstack);
                    this.field_147369_b.func_184602_cy();
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.field_147369_b.func_175149_v()) {
                    this.field_147369_b.func_225609_n_(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.field_147369_b.func_175149_v()) {
                    this.field_147369_b.func_225609_n_(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.field_147369_b.func_184597_cx();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.field_147369_b.field_71134_c.func_225416_a(blockpos, cplayerdiggingpacket$action, p_147345_1_.func_179714_b(), this.field_147367_d.func_71207_Z());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean func_241166_a_(ServerPlayerEntity p_241166_0_, ItemStack p_241166_1_) {
        if (p_241166_1_.func_190926_b()) {
            return false;
        }
        Item item = p_241166_1_.func_77973_b();
        return (item instanceof BlockItem || item instanceof BucketItem) && !p_241166_0_.func_184811_cZ().func_185141_a(item);
    }

    public void func_184337_a(CPlayerTryUseItemOnBlockPacket p_184337_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_184337_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        ServerWorld serverworld = this.field_147369_b.func_71121_q();
        Hand hand = p_184337_1_.func_187022_c();
        ItemStack itemstack = this.field_147369_b.func_184586_b(hand);
        BlockRayTraceResult blockraytraceresult = p_184337_1_.func_218794_c();
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        Direction direction = blockraytraceresult.func_216354_b();
        this.field_147369_b.func_143004_u();
        if (blockpos.func_177956_o() < this.field_147367_d.func_71207_Z()) {
            double dist = this.field_147369_b.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 3.0;
            dist *= dist;
            if (this.field_184362_y == null && this.field_147369_b.func_70092_e((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5) < dist && serverworld.func_175660_a(this.field_147369_b, blockpos)) {
                ActionResultType actionresulttype = this.field_147369_b.field_71134_c.func_219441_a(this.field_147369_b, serverworld, itemstack, hand, blockraytraceresult);
                if (direction == Direction.UP && !actionresulttype.func_226246_a_() && blockpos.func_177956_o() >= this.field_147367_d.func_71207_Z() - 1 && ServerPlayNetHandler.func_241166_a_(this.field_147369_b, itemstack)) {
                    IFormattableTextComponent itextcomponent = new TranslationTextComponent("build.tooHigh", this.field_147367_d.func_71207_Z()).func_240699_a_(TextFormatting.RED);
                    this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SChatPacket((ITextComponent)itextcomponent, ChatType.GAME_INFO, Util.field_240973_b_));
                } else if (actionresulttype.func_226247_b_()) {
                    this.field_147369_b.func_226292_a_(hand, true);
                }
            }
        } else {
            IFormattableTextComponent itextcomponent1 = new TranslationTextComponent("build.tooHigh", this.field_147367_d.func_71207_Z()).func_240699_a_(TextFormatting.RED);
            this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SChatPacket((ITextComponent)itextcomponent1, ChatType.GAME_INFO, Util.field_240973_b_));
        }
        this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SChangeBlockPacket((IBlockReader)((Object)serverworld), blockpos));
        this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SChangeBlockPacket((IBlockReader)((Object)serverworld), blockpos.func_177972_a(direction)));
    }

    public void func_147346_a(CPlayerTryUseItemPacket p_147346_1_) {
        ActionResultType actionresulttype;
        PacketThreadUtil.func_218796_a((IPacket)p_147346_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        ServerWorld serverworld = this.field_147369_b.func_71121_q();
        Hand hand = p_147346_1_.func_187028_a();
        ItemStack itemstack = this.field_147369_b.func_184586_b(hand);
        this.field_147369_b.func_143004_u();
        if (!itemstack.func_190926_b() && (actionresulttype = this.field_147369_b.field_71134_c.func_187250_a(this.field_147369_b, serverworld, itemstack, hand)).func_226247_b_()) {
            this.field_147369_b.func_226292_a_(hand, true);
        }
    }

    public void func_175088_a(CSpectatePacket p_175088_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_175088_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_175149_v()) {
            for (ServerWorld serverworld : this.field_147367_d.func_212370_w()) {
                Entity entity = p_175088_1_.func_179727_a(serverworld);
                if (entity == null) continue;
                this.field_147369_b.func_200619_a(serverworld, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
                return;
            }
        }
    }

    public void func_175086_a(CResourcePackStatusPacket p_175086_1_) {
    }

    public void func_184340_a(CSteerBoatPacket p_184340_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_184340_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        Entity entity = this.field_147369_b.func_184187_bx();
        if (entity instanceof BoatEntity) {
            ((BoatEntity)entity).func_184445_a(p_184340_1_.func_187012_a(), p_184340_1_.func_187014_b());
        }
    }

    public void func_147231_a(ITextComponent p_147231_1_) {
        field_147370_c.info("{} lost connection: {}", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)p_147231_1_.getString());
        this.field_147367_d.func_147132_au();
        this.field_147367_d.func_184103_al().func_232641_a_((ITextComponent)new TranslationTextComponent("multiplayer.player.left", this.field_147369_b.func_145748_c_()).func_240699_a_(TextFormatting.YELLOW), ChatType.SYSTEM, Util.field_240973_b_);
        this.field_147369_b.func_71123_m();
        this.field_147367_d.func_184103_al().func_72367_e(this.field_147369_b);
        IChatFilter ichatfilter = this.field_147369_b.func_244529_Q();
        if (ichatfilter != null) {
            ichatfilter.func_244434_b();
        }
        if (this.func_217264_d()) {
            field_147370_c.info("Stopping singleplayer server as player logged out");
            this.field_147367_d.func_71263_m(false);
        }
    }

    public void func_147359_a(IPacket<?> p_147359_1_) {
        this.func_211148_a(p_147359_1_, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)null));
    }

    public void func_211148_a(IPacket<?> p_211148_1_, @Nullable GenericFutureListener<? extends Future<? super Void>> p_211148_2_) {
        if (p_211148_1_ instanceof SChatPacket) {
            SChatPacket schatpacket = (SChatPacket)p_211148_1_;
            ChatVisibility chatvisibility = this.field_147369_b.func_147096_v();
            if (chatvisibility == ChatVisibility.HIDDEN && schatpacket.func_192590_c() != ChatType.GAME_INFO) {
                return;
            }
            if (chatvisibility == ChatVisibility.SYSTEM && !schatpacket.func_148916_d()) {
                return;
            }
        }
        try {
            this.field_147371_a.func_201058_a(p_211148_1_, p_211148_2_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Sending packet");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Packet being sent");
            crashreportcategory.func_189529_a("Packet class", (ICrashReportDetail<String>)((ICrashReportDetail)() -> p_211148_1_.getClass().getCanonicalName()));
            throw new ReportedException(crashreport);
        }
    }

    public void func_147355_a(CHeldItemChangePacket p_147355_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147355_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (p_147355_1_.func_149614_c() >= 0 && p_147355_1_.func_149614_c() < PlayerInventory.func_70451_h()) {
            if (this.field_147369_b.field_71071_by.field_70461_c != p_147355_1_.func_149614_c() && this.field_147369_b.func_184600_cs() == Hand.MAIN_HAND) {
                this.field_147369_b.func_184602_cy();
            }
            this.field_147369_b.field_71071_by.field_70461_c = p_147355_1_.func_149614_c();
            this.field_147369_b.func_143004_u();
        } else {
            field_147370_c.warn("{} tried to set an invalid carried item", (Object)this.field_147369_b.func_200200_C_().getString());
        }
    }

    public void func_147354_a(CChatMessagePacket p_147354_1_) {
        String s = org.apache.commons.lang3.StringUtils.normalizeSpace((String)p_147354_1_.func_149439_c());
        if (s.startsWith("/")) {
            PacketThreadUtil.func_218796_a((IPacket)p_147354_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
            this.func_244548_c(s);
        } else {
            this.func_244535_a(s, this::func_244548_c);
        }
    }

    private void func_244548_c(String p_244548_1_) {
        if (this.field_147369_b.func_147096_v() == ChatVisibility.HIDDEN) {
            this.func_147359_a((IPacket<?>)new SChatPacket((ITextComponent)new TranslationTextComponent("chat.cannotSend").func_240699_a_(TextFormatting.RED), ChatType.SYSTEM, Util.field_240973_b_));
        } else {
            this.field_147369_b.func_143004_u();
            for (int i = 0; i < p_244548_1_.length(); ++i) {
                if (SharedConstants.func_71566_a(p_244548_1_.charAt(i))) continue;
                this.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.illegal_characters"));
                return;
            }
            if (p_244548_1_.startsWith("/")) {
                this.func_147361_d(p_244548_1_);
            } else {
                TranslationTextComponent itextcomponent = new TranslationTextComponent("chat.type.text", this.field_147369_b.func_145748_c_(), ForgeHooks.newChatWithLinks((String)p_244548_1_));
                if ((itextcomponent = ForgeHooks.onServerChatEvent((ServerPlayNetHandler)this, (String)p_244548_1_, (ITextComponent)itextcomponent)) == null) {
                    return;
                }
                this.field_147367_d.func_184103_al().func_232641_a_((ITextComponent)itextcomponent, ChatType.CHAT, this.field_147369_b.func_110124_au());
            }
            this.field_147374_l += 20;
            if (this.field_147374_l > 200 && !this.field_147367_d.func_184103_al().func_152596_g(this.field_147369_b.func_146103_bH())) {
                this.func_194028_b((ITextComponent)new TranslationTextComponent("disconnect.spam"));
            }
        }
    }

    private void func_147361_d(String p_147361_1_) {
        this.field_147367_d.func_195571_aL().func_197059_a(this.field_147369_b.func_195051_bN(), p_147361_1_);
    }

    public void func_175087_a(CAnimateHandPacket p_175087_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_175087_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        this.field_147369_b.func_184609_a(p_175087_1_.func_187018_a());
    }

    public void func_147357_a(CEntityActionPacket p_147357_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147357_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        switch (p_147357_1_.func_180764_b()) {
            case PRESS_SHIFT_KEY: {
                this.field_147369_b.func_226284_e_(true);
                break;
            }
            case RELEASE_SHIFT_KEY: {
                this.field_147369_b.func_226284_e_(false);
                break;
            }
            case START_SPRINTING: {
                this.field_147369_b.func_70031_b(true);
                break;
            }
            case STOP_SPRINTING: {
                this.field_147369_b.func_70031_b(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.field_147369_b.func_70608_bn()) break;
                this.field_147369_b.func_225652_a_(false, true);
                this.field_184362_y = this.field_147369_b.func_213303_ch();
                break;
            }
            case START_RIDING_JUMP: {
                if (!(this.field_147369_b.func_184187_bx() instanceof IJumpingMount)) break;
                IJumpingMount ijumpingmount1 = (IJumpingMount)this.field_147369_b.func_184187_bx();
                int i = p_147357_1_.func_149512_e();
                if (!ijumpingmount1.func_184776_b() || i <= 0) break;
                ijumpingmount1.func_184775_b(i);
                break;
            }
            case STOP_RIDING_JUMP: {
                if (!(this.field_147369_b.func_184187_bx() instanceof IJumpingMount)) break;
                IJumpingMount ijumpingmount = (IJumpingMount)this.field_147369_b.func_184187_bx();
                ijumpingmount.func_184777_r_();
                break;
            }
            case OPEN_INVENTORY: {
                if (!(this.field_147369_b.func_184187_bx() instanceof AbstractHorseEntity)) break;
                ((AbstractHorseEntity)((Object)this.field_147369_b.func_184187_bx())).func_110199_f(this.field_147369_b);
                break;
            }
            case START_FALL_FLYING: {
                if (this.field_147369_b.func_226566_ei_()) break;
                this.field_147369_b.func_226568_ek_();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    public void func_147340_a(CUseEntityPacket p_147340_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147340_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        ServerWorld serverworld = this.field_147369_b.func_71121_q();
        Entity entity = p_147340_1_.func_149564_a((World)serverworld);
        this.field_147369_b.func_143004_u();
        this.field_147369_b.func_226284_e_(p_147340_1_.func_241792_e_());
        if (entity != null) {
            double d0 = 36.0;
            if (this.field_147369_b.func_70068_e(entity) < 36.0) {
                Hand hand = p_147340_1_.func_186994_b();
                ItemStack itemstack = hand != null ? this.field_147369_b.func_184586_b(hand).func_77946_l() : ItemStack.field_190927_a;
                Optional<Object> optional = Optional.empty();
                if (p_147340_1_.func_149565_c() == CUseEntityPacket.Action.INTERACT) {
                    optional = Optional.of(this.field_147369_b.func_190775_a(entity, hand));
                } else if (p_147340_1_.func_149565_c() == CUseEntityPacket.Action.INTERACT_AT) {
                    if (ForgeHooks.onInteractEntityAt((PlayerEntity)this.field_147369_b, (Entity)entity, (Vector3d)p_147340_1_.func_179712_b(), (Hand)hand) != null) {
                        return;
                    }
                    optional = Optional.of(entity.func_184199_a(this.field_147369_b, p_147340_1_.func_179712_b(), hand));
                } else if (p_147340_1_.func_149565_c() == CUseEntityPacket.Action.ATTACK) {
                    if (entity instanceof ItemEntity || entity instanceof ExperienceOrbEntity || entity instanceof AbstractArrowEntity || entity == this.field_147369_b) {
                        this.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.invalid_entity_attacked"));
                        field_147370_c.warn("Player {} tried to attack an invalid entity", (Object)this.field_147369_b.func_200200_C_().getString());
                        return;
                    }
                    this.field_147369_b.func_71059_n(entity);
                }
                if (optional.isPresent() && ((ActionResultType)optional.get()).func_226246_a_()) {
                    CriteriaTriggers.field_241276_P_.func_241476_a_(this.field_147369_b, itemstack, entity);
                    if (((ActionResultType)optional.get()).func_226247_b_()) {
                        this.field_147369_b.func_226292_a_(hand, true);
                    }
                }
            }
        }
    }

    public void func_147342_a(CClientStatusPacket p_147342_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147342_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        CClientStatusPacket.State cclientstatuspacket$state = p_147342_1_.func_149435_c();
        switch (cclientstatuspacket$state) {
            case PERFORM_RESPAWN: {
                if (this.field_147369_b.field_71136_j) {
                    this.field_147369_b.field_71136_j = false;
                    this.field_147369_b = this.field_147367_d.func_184103_al().func_232644_a_(this.field_147369_b, true);
                    CriteriaTriggers.field_193134_u.func_233551_a_(this.field_147369_b, World.field_234920_i_, World.field_234918_g_);
                    break;
                }
                if (this.field_147369_b.func_110143_aJ() > 0.0f) {
                    return;
                }
                this.field_147369_b = this.field_147367_d.func_184103_al().func_232644_a_(this.field_147369_b, false);
                if (!this.field_147367_d.func_71199_h()) break;
                this.field_147369_b.func_71033_a(GameType.SPECTATOR);
                ((GameRules.BooleanValue)this.field_147369_b.func_71121_q().func_82736_K().func_223585_a(GameRules.field_223613_p)).func_223570_a(false, this.field_147367_d);
                break;
            }
            case REQUEST_STATS: {
                this.field_147369_b.func_147099_x().func_150876_a(this.field_147369_b);
            }
        }
    }

    public void func_147356_a(CCloseWindowPacket p_147356_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147356_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_71128_l();
    }

    public void func_147351_a(CClickWindowPacket p_147351_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147351_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        if (this.field_147369_b.field_71070_bA.field_75152_c == p_147351_1_.func_149548_c() && this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b)) {
            if (this.field_147369_b.func_175149_v()) {
                NonNullList nonnulllist = NonNullList.func_191196_a();
                for (int i = 0; i < this.field_147369_b.field_71070_bA.field_75151_b.size(); ++i) {
                    nonnulllist.add((Object)this.field_147369_b.field_71070_bA.field_75151_b.get(i).func_75211_c());
                }
                this.field_147369_b.func_71110_a(this.field_147369_b.field_71070_bA, (NonNullList<ItemStack>)nonnulllist);
            } else {
                ItemStack itemstack1 = this.field_147369_b.field_71070_bA.func_184996_a(p_147351_1_.func_149544_d(), p_147351_1_.func_149543_e(), p_147351_1_.func_186993_f(), this.field_147369_b);
                if (ItemStack.func_77989_b(p_147351_1_.func_149546_g(), itemstack1)) {
                    this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SConfirmTransactionPacket(p_147351_1_.func_149548_c(), p_147351_1_.func_149547_f(), true));
                    this.field_147369_b.field_71137_h = true;
                    this.field_147369_b.field_71070_bA.func_75142_b();
                    this.field_147369_b.func_71113_k();
                    this.field_147369_b.field_71137_h = false;
                } else {
                    this.field_147372_n.put(this.field_147369_b.field_71070_bA.field_75152_c, p_147351_1_.func_149547_f());
                    this.field_147369_b.field_71135_a.func_147359_a((IPacket<?>)new SConfirmTransactionPacket(p_147351_1_.func_149548_c(), p_147351_1_.func_149547_f(), false));
                    this.field_147369_b.field_71070_bA.func_75128_a(this.field_147369_b, false);
                    NonNullList nonnulllist1 = NonNullList.func_191196_a();
                    for (int j = 0; j < this.field_147369_b.field_71070_bA.field_75151_b.size(); ++j) {
                        ItemStack itemstack = this.field_147369_b.field_71070_bA.field_75151_b.get(j).func_75211_c();
                        nonnulllist1.add((Object)(itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack));
                    }
                    this.field_147369_b.func_71110_a(this.field_147369_b.field_71070_bA, (NonNullList<ItemStack>)nonnulllist1);
                }
            }
        }
    }

    public void func_194308_a(CPlaceRecipePacket p_194308_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_194308_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        if (!this.field_147369_b.func_175149_v() && this.field_147369_b.field_71070_bA.field_75152_c == p_194308_1_.func_194318_a() && this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) && this.field_147369_b.field_71070_bA instanceof RecipeBookContainer) {
            this.field_147367_d.func_199529_aN().func_215367_a(p_194308_1_.func_199618_b()).ifPresent(p_241165_2_ -> ((RecipeBookContainer)this.field_147369_b.field_71070_bA).func_217056_a(p_194308_1_.func_194319_c(), (IRecipe<?>)p_241165_2_, this.field_147369_b));
        }
    }

    public void func_147338_a(CEnchantItemPacket p_147338_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147338_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        if (this.field_147369_b.field_71070_bA.field_75152_c == p_147338_1_.func_149539_c() && this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) && !this.field_147369_b.func_175149_v()) {
            this.field_147369_b.field_71070_bA.func_75140_a(this.field_147369_b, p_147338_1_.func_149537_d());
            this.field_147369_b.field_71070_bA.func_75142_b();
        }
    }

    public void func_147344_a(CCreativeInventoryActionPacket p_147344_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147344_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71134_c.func_73083_d()) {
            boolean flag2;
            BlockPos blockpos;
            TileEntity tileentity;
            boolean flag = p_147344_1_.func_149627_c() < 0;
            ItemStack itemstack = p_147344_1_.func_149625_d();
            CompoundNBT compoundnbt = itemstack.func_179543_a("BlockEntityTag");
            if (!itemstack.func_190926_b() && compoundnbt != null && compoundnbt.func_74764_b("x") && compoundnbt.func_74764_b("y") && compoundnbt.func_74764_b("z") && (tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos = new BlockPos(compoundnbt.func_74762_e("x"), compoundnbt.func_74762_e("y"), compoundnbt.func_74762_e("z")))) != null) {
                CompoundNBT compoundnbt1 = tileentity.func_189515_b(new CompoundNBT());
                compoundnbt1.func_82580_o("x");
                compoundnbt1.func_82580_o("y");
                compoundnbt1.func_82580_o("z");
                itemstack.func_77983_a("BlockEntityTag", compoundnbt1);
            }
            boolean flag1 = p_147344_1_.func_149627_c() >= 1 && p_147344_1_.func_149627_c() <= 45;
            boolean bl = flag2 = itemstack.func_190926_b() || itemstack.func_77952_i() >= 0 && itemstack.func_190916_E() <= 64 && !itemstack.func_190926_b();
            if (flag1 && flag2) {
                if (itemstack.func_190926_b()) {
                    this.field_147369_b.field_71069_bz.func_75141_a(p_147344_1_.func_149627_c(), ItemStack.field_190927_a);
                } else {
                    this.field_147369_b.field_71069_bz.func_75141_a(p_147344_1_.func_149627_c(), itemstack);
                }
                this.field_147369_b.field_71069_bz.func_75128_a(this.field_147369_b, true);
                this.field_147369_b.field_71069_bz.func_75142_b();
            } else if (flag && flag2 && this.field_147375_m < 200) {
                this.field_147375_m += 20;
                this.field_147369_b.func_71019_a(itemstack, true);
            }
        }
    }

    public void func_147339_a(CConfirmTransactionPacket p_147339_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147339_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        int i = this.field_147369_b.field_71070_bA.field_75152_c;
        if (i == p_147339_1_.func_149532_c() && this.field_147372_n.getOrDefault(i, (short)(p_147339_1_.func_149533_d() + 1)) == p_147339_1_.func_149533_d() && !this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) && !this.field_147369_b.func_175149_v()) {
            this.field_147369_b.field_71070_bA.func_75128_a(this.field_147369_b, true);
        }
    }

    public void func_147343_a(CUpdateSignPacket p_147343_1_) {
        List<String> list = Stream.of(p_147343_1_.func_187017_b()).map(TextFormatting::func_110646_a).collect(Collectors.toList());
        this.func_244537_a(list, p_244547_2_ -> this.func_244542_a(p_147343_1_, (List<String>)p_244547_2_));
    }

    private void func_244542_a(CUpdateSignPacket p_244542_1_, List<String> p_244542_2_) {
        this.field_147369_b.func_143004_u();
        ServerWorld serverworld = this.field_147369_b.func_71121_q();
        BlockPos blockpos = p_244542_1_.func_179722_a();
        if (serverworld.func_175667_e(blockpos)) {
            BlockState blockstate = serverworld.func_180495_p(blockpos);
            TileEntity tileentity = serverworld.func_175625_s(blockpos);
            if (!(tileentity instanceof SignTileEntity)) {
                return;
            }
            SignTileEntity signtileentity = (SignTileEntity)tileentity;
            if (!signtileentity.func_145914_a() || signtileentity.func_145911_b() != this.field_147369_b) {
                field_147370_c.warn("Player {} just tried to change non-editable sign", (Object)this.field_147369_b.func_200200_C_().getString());
                return;
            }
            for (int i = 0; i < p_244542_2_.size(); ++i) {
                signtileentity.func_212365_a(i, (ITextComponent)new StringTextComponent(p_244542_2_.get(i)));
            }
            signtileentity.func_70296_d();
            serverworld.func_184138_a(blockpos, blockstate, blockstate, 3);
        }
    }

    public void func_147353_a(CKeepAlivePacket p_147353_1_) {
        if (this.field_194403_g && p_147353_1_.func_149460_c() == this.field_194404_h) {
            int i = (int)(Util.func_211177_b() - this.field_194402_f);
            this.field_147369_b.field_71138_i = (this.field_147369_b.field_71138_i * 3 + i) / 4;
            this.field_194403_g = false;
        } else if (!this.func_217264_d()) {
            this.func_194028_b((ITextComponent)new TranslationTextComponent("disconnect.timeout"));
        }
    }

    public void func_147348_a(CPlayerAbilitiesPacket p_147348_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147348_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        this.field_147369_b.field_71075_bZ.field_75100_b = p_147348_1_.func_149488_d() && this.field_147369_b.field_71075_bZ.field_75101_c;
    }

    public void func_147352_a(CClientSettingsPacket p_147352_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147352_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        this.field_147369_b.func_147100_a(p_147352_1_);
    }

    public void func_147349_a(CCustomPayloadPacket p_147349_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_147349_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        NetworkHooks.onCustomPayload((ICustomPacket)p_147349_1_, (NetworkManager)this.field_147371_a);
    }

    public void func_217263_a(CSetDifficultyPacket p_217263_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_217263_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_211513_k(2) || this.func_217264_d()) {
            this.field_147367_d.func_147139_a(p_217263_1_.func_218773_b(), false);
        }
    }

    public void func_217261_a(CLockDifficultyPacket p_217261_1_) {
        PacketThreadUtil.func_218796_a((IPacket)p_217261_1_, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_211513_k(2) || this.func_217264_d()) {
            this.field_147367_d.func_213209_d(p_217261_1_.func_218776_b());
        }
    }
}

