/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.client.gui.SpectatorGui;
import net.minecraft.client.gui.chat.IChatListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.chat.NormalChatListener;
import net.minecraft.client.gui.chat.OverlayChatListener;
import net.minecraft.client.gui.overlay.BossOverlayGui;
import net.minecraft.client.gui.overlay.DebugOverlayGui;
import net.minecraft.client.gui.overlay.PlayerTabOverlayGui;
import net.minecraft.client.gui.overlay.SubtitleOverlayGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.AttackIndicatorStatus;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.FoodStats;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TextProcessing;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IngameGui
extends AbstractGui {
    protected static final ResourceLocation field_110329_b = new ResourceLocation("textures/misc/vignette.png");
    protected static final ResourceLocation field_110330_c = new ResourceLocation("textures/gui/widgets.png");
    protected static final ResourceLocation field_110328_d = new ResourceLocation("textures/misc/pumpkinblur.png");
    private static final ITextComponent field_243249_e = new TranslationTextComponent("demo.demoExpired");
    protected final Random field_73842_c = new Random();
    protected final Minecraft field_73839_d;
    protected final ItemRenderer field_73841_b;
    protected final NewChatGui field_73840_e;
    protected int field_73837_f;
    @Nullable
    protected ITextComponent field_73838_g;
    protected int field_73845_h;
    protected boolean field_73844_j;
    public float field_73843_a = 1.0f;
    protected int field_92017_k;
    protected ItemStack field_92016_l = ItemStack.field_190927_a;
    protected final DebugOverlayGui field_175198_t;
    protected final SubtitleOverlayGui field_184049_t;
    protected final SpectatorGui field_175197_u;
    protected final PlayerTabOverlayGui field_175196_v;
    protected final BossOverlayGui field_184050_w;
    protected int field_175195_w;
    @Nullable
    protected ITextComponent field_175201_x;
    @Nullable
    protected ITextComponent field_175200_y;
    protected int field_175199_z;
    protected int field_175192_A;
    protected int field_175193_B;
    protected int field_175194_C;
    protected int field_175189_D;
    protected long field_175190_E;
    protected long field_175191_F;
    protected int field_194811_H;
    protected int field_194812_I;
    protected final Map<ChatType, List<IChatListener>> field_191743_I = Maps.newHashMap();

    public IngameGui(Minecraft p_i46325_1_) {
        this.field_73839_d = p_i46325_1_;
        this.field_73841_b = p_i46325_1_.func_175599_af();
        this.field_175198_t = new DebugOverlayGui(p_i46325_1_);
        this.field_175197_u = new SpectatorGui(p_i46325_1_);
        this.field_73840_e = new NewChatGui(p_i46325_1_);
        this.field_175196_v = new PlayerTabOverlayGui(p_i46325_1_, this);
        this.field_184050_w = new BossOverlayGui(p_i46325_1_);
        this.field_184049_t = new SubtitleOverlayGui(p_i46325_1_);
        for (ChatType chattype : ChatType.values()) {
            this.field_191743_I.put(chattype, Lists.newArrayList());
        }
        NarratorChatListener ichatlistener = NarratorChatListener.field_193643_a;
        this.field_191743_I.get(ChatType.CHAT).add((IChatListener)new NormalChatListener(p_i46325_1_));
        this.field_191743_I.get(ChatType.CHAT).add((IChatListener)ichatlistener);
        this.field_191743_I.get(ChatType.SYSTEM).add((IChatListener)new NormalChatListener(p_i46325_1_));
        this.field_191743_I.get(ChatType.SYSTEM).add((IChatListener)ichatlistener);
        this.field_191743_I.get(ChatType.GAME_INFO).add((IChatListener)new OverlayChatListener(p_i46325_1_));
        this.func_175177_a();
    }

    public void func_175177_a() {
        this.field_175199_z = 10;
        this.field_175192_A = 70;
        this.field_175193_B = 20;
    }

    public void func_238445_a_(MatrixStack p_238445_1_, float p_238445_2_) {
        float f;
        this.field_194811_H = this.field_73839_d.func_228018_at_().func_198107_o();
        this.field_194812_I = this.field_73839_d.func_228018_at_().func_198087_p();
        FontRenderer fontrenderer = this.func_175179_f();
        RenderSystem.enableBlend();
        if (Minecraft.func_71375_t()) {
            this.func_212303_b(this.field_73839_d.func_175606_aa());
        } else {
            RenderSystem.enableDepthTest();
            RenderSystem.defaultBlendFunc();
        }
        ItemStack itemstack = this.field_73839_d.field_71439_g.field_71071_by.func_70440_f(3);
        if (this.field_73839_d.field_71474_y.func_243230_g().func_243192_a() && itemstack.func_77973_b() == Blocks.field_196625_cS.func_199767_j()) {
            this.func_194808_p();
        }
        if ((f = MathHelper.func_219799_g((float)p_238445_2_, (float)this.field_73839_d.field_71439_g.field_71080_cy, (float)this.field_73839_d.field_71439_g.field_71086_bY)) > 0.0f && !this.field_73839_d.field_71439_g.func_70644_a(Effects.field_76431_k)) {
            this.func_194805_e(f);
        }
        if (this.field_73839_d.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
            this.field_175197_u.func_238528_a_(p_238445_1_, p_238445_2_);
        } else if (!this.field_73839_d.field_71474_y.field_74319_N) {
            this.func_238443_a_(p_238445_2_, p_238445_1_);
        }
        if (!this.field_73839_d.field_71474_y.field_74319_N) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_73839_d.func_110434_K().func_110577_a(field_230665_h_);
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            this.func_238456_d_(p_238445_1_);
            RenderSystem.defaultBlendFunc();
            this.field_73839_d.func_213239_aq().func_76320_a("bossHealth");
            this.field_184050_w.func_238484_a_(p_238445_1_);
            this.field_73839_d.func_213239_aq().func_76319_b();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_73839_d.func_110434_K().func_110577_a(field_230665_h_);
            if (this.field_73839_d.field_71442_b.func_78755_b()) {
                this.func_238457_e_(p_238445_1_);
            }
            this.func_238458_f_(p_238445_1_);
            RenderSystem.disableBlend();
            int i = this.field_194811_H / 2 - 91;
            if (this.field_73839_d.field_71439_g.func_110317_t()) {
                this.func_238446_a_(p_238445_1_, i);
            } else if (this.field_73839_d.field_71442_b.func_78763_f()) {
                this.func_238454_b_(p_238445_1_, i);
            }
            if (this.field_73839_d.field_71474_y.field_92117_D && this.field_73839_d.field_71442_b.func_178889_l() != GameType.SPECTATOR) {
                this.func_238453_b_(p_238445_1_);
            } else if (this.field_73839_d.field_71439_g.func_175149_v()) {
                this.field_175197_u.func_238527_a_(p_238445_1_);
            }
        }
        if (this.field_73839_d.field_71439_g.func_71060_bI() > 0) {
            this.field_73839_d.func_213239_aq().func_76320_a("sleep");
            RenderSystem.disableDepthTest();
            RenderSystem.disableAlphaTest();
            float f2 = this.field_73839_d.field_71439_g.func_71060_bI();
            float f1 = f2 / 100.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f - (f2 - 100.0f) / 10.0f;
            }
            int j = (int)(220.0f * f1) << 24 | 0x101020;
            IngameGui.func_238467_a_((MatrixStack)p_238445_1_, (int)0, (int)0, (int)this.field_194811_H, (int)this.field_194812_I, (int)j);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableDepthTest();
            this.field_73839_d.func_213239_aq().func_76319_b();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.field_73839_d.func_71355_q()) {
            this.func_238455_c_(p_238445_1_);
        }
        this.func_238444_a_(p_238445_1_);
        if (this.field_73839_d.field_71474_y.field_74330_P) {
            this.field_175198_t.func_194818_a(p_238445_1_);
        }
        if (!this.field_73839_d.field_71474_y.field_74319_N) {
            ScoreObjective scoreobjective1;
            int j2;
            if (this.field_73838_g != null && this.field_73845_h > 0) {
                this.field_73839_d.func_213239_aq().func_76320_a("overlayMessage");
                float f3 = (float)this.field_73845_h - p_238445_2_;
                int i1 = (int)(f3 * 255.0f / 20.0f);
                if (i1 > 255) {
                    i1 = 255;
                }
                if (i1 > 8) {
                    RenderSystem.pushMatrix();
                    RenderSystem.translatef((float)(this.field_194811_H / 2), (float)(this.field_194812_I - 68), (float)0.0f);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    int k1 = 0xFFFFFF;
                    if (this.field_73844_j) {
                        k1 = MathHelper.func_181758_c((float)(f3 / 50.0f), (float)0.7f, (float)0.6f) & 0xFFFFFF;
                    }
                    int k = i1 << 24 & 0xFF000000;
                    int l = fontrenderer.func_238414_a_((ITextProperties)this.field_73838_g);
                    this.func_238448_a_(p_238445_1_, fontrenderer, -4, l, 0xFFFFFF | k);
                    fontrenderer.func_243248_b(p_238445_1_, this.field_73838_g, (float)(-l / 2), -4.0f, k1 | k);
                    RenderSystem.disableBlend();
                    RenderSystem.popMatrix();
                }
                this.field_73839_d.func_213239_aq().func_76319_b();
            }
            if (this.field_175201_x != null && this.field_175195_w > 0) {
                this.field_73839_d.func_213239_aq().func_76320_a("titleAndSubtitle");
                float f4 = (float)this.field_175195_w - p_238445_2_;
                int j1 = 255;
                if (this.field_175195_w > this.field_175193_B + this.field_175192_A) {
                    float f5 = (float)(this.field_175199_z + this.field_175192_A + this.field_175193_B) - f4;
                    j1 = (int)(f5 * 255.0f / (float)this.field_175199_z);
                }
                if (this.field_175195_w <= this.field_175193_B) {
                    j1 = (int)(f4 * 255.0f / (float)this.field_175193_B);
                }
                if ((j1 = MathHelper.func_76125_a((int)j1, (int)0, (int)255)) > 8) {
                    RenderSystem.pushMatrix();
                    RenderSystem.translatef((float)(this.field_194811_H / 2), (float)(this.field_194812_I / 2), (float)0.0f);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.pushMatrix();
                    RenderSystem.scalef((float)4.0f, (float)4.0f, (float)4.0f);
                    int l1 = j1 << 24 & 0xFF000000;
                    int i2 = fontrenderer.func_238414_a_((ITextProperties)this.field_175201_x);
                    this.func_238448_a_(p_238445_1_, fontrenderer, -10, i2, 0xFFFFFF | l1);
                    fontrenderer.func_243246_a(p_238445_1_, this.field_175201_x, (float)(-i2 / 2), -10.0f, 0xFFFFFF | l1);
                    RenderSystem.popMatrix();
                    if (this.field_175200_y != null) {
                        RenderSystem.pushMatrix();
                        RenderSystem.scalef((float)2.0f, (float)2.0f, (float)2.0f);
                        int k2 = fontrenderer.func_238414_a_((ITextProperties)this.field_175200_y);
                        this.func_238448_a_(p_238445_1_, fontrenderer, 5, k2, 0xFFFFFF | l1);
                        fontrenderer.func_243246_a(p_238445_1_, this.field_175200_y, (float)(-k2 / 2), 5.0f, 0xFFFFFF | l1);
                        RenderSystem.popMatrix();
                    }
                    RenderSystem.disableBlend();
                    RenderSystem.popMatrix();
                }
                this.field_73839_d.func_213239_aq().func_76319_b();
            }
            this.field_184049_t.func_195620_a(p_238445_1_);
            Scoreboard scoreboard = this.field_73839_d.field_71441_e.func_96441_U();
            ScoreObjective scoreobjective = null;
            ScorePlayerTeam scoreplayerteam = scoreboard.func_96509_i(this.field_73839_d.field_71439_g.func_195047_I_());
            if (scoreplayerteam != null && (j2 = scoreplayerteam.func_178775_l().func_175746_b()) >= 0) {
                scoreobjective = scoreboard.func_96539_a(3 + j2);
            }
            ScoreObjective scoreObjective = scoreobjective1 = scoreobjective != null ? scoreobjective : scoreboard.func_96539_a(1);
            if (scoreobjective1 != null) {
                this.func_238447_a_(p_238445_1_, scoreobjective1);
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableAlphaTest();
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)(this.field_194812_I - 48), (float)0.0f);
            this.field_73839_d.func_213239_aq().func_76320_a("chat");
            this.field_73840_e.func_238492_a_(p_238445_1_, this.field_73837_f);
            this.field_73839_d.func_213239_aq().func_76319_b();
            RenderSystem.popMatrix();
            scoreobjective1 = scoreboard.func_96539_a(0);
            if (!this.field_73839_d.field_71474_y.field_74321_H.func_151470_d() || this.field_73839_d.func_71387_A() && this.field_73839_d.field_71439_g.field_71174_a.func_175106_d().size() <= 1 && scoreobjective1 == null) {
                this.field_175196_v.func_175246_a(false);
            } else {
                this.field_175196_v.func_175246_a(true);
                this.field_175196_v.func_238523_a_(p_238445_1_, this.field_194811_H, scoreboard, scoreobjective1);
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
    }

    protected void func_238448_a_(MatrixStack p_238448_1_, FontRenderer p_238448_2_, int p_238448_3_, int p_238448_4_, int p_238448_5_) {
        int i = this.field_73839_d.field_71474_y.func_216841_b(0.0f);
        if (i != 0) {
            int j = -p_238448_4_ / 2;
            IngameGui.func_238467_a_((MatrixStack)p_238448_1_, (int)(j - 2), (int)(p_238448_3_ - 2), (int)(j + p_238448_4_ + 2), (int)(p_238448_3_ + 9 + 2), (int)ColorHelper.PackedColor.func_233005_a_((int)i, (int)p_238448_5_));
        }
    }

    protected void func_238456_d_(MatrixStack p_238456_1_) {
        GameSettings gamesettings = this.field_73839_d.field_71474_y;
        if (gamesettings.func_243230_g().func_243192_a() && (this.field_73839_d.field_71442_b.func_178889_l() != GameType.SPECTATOR || this.func_212913_a(this.field_73839_d.field_71476_x))) {
            if (gamesettings.field_74330_P && !gamesettings.field_74319_N && !this.field_73839_d.field_71439_g.func_175140_cp() && !gamesettings.field_178879_v) {
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)(this.field_194811_H / 2), (float)(this.field_194812_I / 2), (float)this.func_230927_p_());
                ActiveRenderInfo activerenderinfo = this.field_73839_d.field_71460_t.func_215316_n();
                RenderSystem.rotatef((float)activerenderinfo.func_216777_e(), (float)-1.0f, (float)0.0f, (float)0.0f);
                RenderSystem.rotatef((float)activerenderinfo.func_216778_f(), (float)0.0f, (float)1.0f, (float)0.0f);
                RenderSystem.scalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                RenderSystem.renderCrosshair((int)10);
                RenderSystem.popMatrix();
            } else {
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int i = 15;
                this.func_238474_b_(p_238456_1_, (this.field_194811_H - 15) / 2, (this.field_194812_I - 15) / 2, 0, 0, 15, 15);
                if (this.field_73839_d.field_71474_y.field_186716_M == AttackIndicatorStatus.CROSSHAIR) {
                    float f = this.field_73839_d.field_71439_g.func_184825_o(0.0f);
                    boolean flag = false;
                    if (this.field_73839_d.field_147125_j != null && this.field_73839_d.field_147125_j instanceof LivingEntity && f >= 1.0f) {
                        flag = this.field_73839_d.field_71439_g.func_184818_cX() > 5.0f;
                        flag &= this.field_73839_d.field_147125_j.func_70089_S();
                    }
                    int j = this.field_194812_I / 2 - 7 + 16;
                    int k = this.field_194811_H / 2 - 8;
                    if (flag) {
                        this.func_238474_b_(p_238456_1_, k, j, 68, 94, 16, 16);
                    } else if (f < 1.0f) {
                        int l = (int)(f * 17.0f);
                        this.func_238474_b_(p_238456_1_, k, j, 36, 94, 16, 4);
                        this.func_238474_b_(p_238456_1_, k, j, 52, 94, l, 4);
                    }
                }
            }
        }
    }

    private boolean func_212913_a(RayTraceResult p_212913_1_) {
        if (p_212913_1_ == null) {
            return false;
        }
        if (p_212913_1_.func_216346_c() == RayTraceResult.Type.ENTITY) {
            return ((EntityRayTraceResult)p_212913_1_).func_216348_a() instanceof INamedContainerProvider;
        }
        if (p_212913_1_.func_216346_c() == RayTraceResult.Type.BLOCK) {
            ClientWorld world = this.field_73839_d.field_71441_e;
            BlockPos blockpos = ((BlockRayTraceResult)p_212913_1_).func_216350_a();
            return world.func_180495_p(blockpos).func_215699_b(world, blockpos) != null;
        }
        return false;
    }

    protected void func_238444_a_(MatrixStack p_238444_1_) {
        Collection<EffectInstance> collection = this.field_73839_d.field_71439_g.func_70651_bq();
        if (!collection.isEmpty()) {
            RenderSystem.enableBlend();
            int i = 0;
            int j = 0;
            PotionSpriteUploader potionspriteuploader = this.field_73839_d.func_213248_ap();
            ArrayList list = Lists.newArrayListWithExpectedSize((int)collection.size());
            this.field_73839_d.func_110434_K().func_110577_a(ContainerScreen.field_147001_a);
            for (EffectInstance effectinstance : Ordering.natural().reverse().sortedCopy(collection)) {
                Effect effect = effectinstance.func_188419_a();
                if (!effectinstance.shouldRenderHUD()) continue;
                this.field_73839_d.func_110434_K().func_110577_a(ContainerScreen.field_147001_a);
                if (!effectinstance.func_205348_f()) continue;
                int k = this.field_194811_H;
                int l = 1;
                if (this.field_73839_d.func_71355_q()) {
                    l += 15;
                }
                if (effect.func_188408_i()) {
                    k -= 25 * ++i;
                } else {
                    k -= 25 * ++j;
                    l += 26;
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float f = 1.0f;
                if (effectinstance.func_82720_e()) {
                    this.func_238474_b_(p_238444_1_, k, l, 165, 166, 24, 24);
                } else {
                    this.func_238474_b_(p_238444_1_, k, l, 141, 166, 24, 24);
                    if (effectinstance.func_76459_b() <= 200) {
                        int i1 = 10 - effectinstance.func_76459_b() / 20;
                        f = MathHelper.func_76131_a((float)((float)effectinstance.func_76459_b() / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + MathHelper.func_76134_b((float)((float)effectinstance.func_76459_b() * (float)Math.PI / 5.0f)) * MathHelper.func_76131_a((float)((float)i1 / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                    }
                }
                TextureAtlasSprite textureatlassprite = potionspriteuploader.func_215288_a(effect);
                int j1 = k;
                int k1 = l;
                float f1 = f;
                list.add(() -> {
                    this.field_73839_d.func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
                    IngameGui.func_238470_a_((MatrixStack)p_238444_1_, (int)(j1 + 3), (int)(k1 + 3), (int)this.func_230927_p_(), (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
                });
                effectinstance.renderHUDEffect(this, p_238444_1_, k, l, this.func_230927_p_(), f);
            }
            list.forEach(Runnable::run);
        }
    }

    protected void func_238443_a_(float p_238443_1_, MatrixStack p_238443_2_) {
        PlayerEntity playerentity = this.func_212304_m();
        if (playerentity != null) {
            float f;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_73839_d.func_110434_K().func_110577_a(field_110330_c);
            ItemStack itemstack = playerentity.func_184592_cb();
            HandSide handside = playerentity.func_184591_cq().func_188468_a();
            int i = this.field_194811_H / 2;
            int j = this.func_230927_p_();
            int k = 182;
            int l = 91;
            this.func_230926_e_(-90);
            this.func_238474_b_(p_238443_2_, i - 91, this.field_194812_I - 22, 0, 0, 182, 22);
            this.func_238474_b_(p_238443_2_, i - 91 - 1 + playerentity.field_71071_by.field_70461_c * 20, this.field_194812_I - 22 - 1, 0, 22, 24, 22);
            if (!itemstack.func_190926_b()) {
                if (handside == HandSide.LEFT) {
                    this.func_238474_b_(p_238443_2_, i - 91 - 29, this.field_194812_I - 23, 24, 22, 29, 24);
                } else {
                    this.func_238474_b_(p_238443_2_, i + 91, this.field_194812_I - 23, 53, 22, 29, 24);
                }
            }
            this.func_230926_e_(j);
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            for (int i1 = 0; i1 < 9; ++i1) {
                int j1 = i - 90 + i1 * 20 + 2;
                int k1 = this.field_194812_I - 16 - 3;
                this.func_184044_a(j1, k1, p_238443_1_, playerentity, (ItemStack)((Object)playerentity.field_71071_by.field_70462_a.get(i1)));
            }
            if (!itemstack.func_190926_b()) {
                int i2 = this.field_194812_I - 16 - 3;
                if (handside == HandSide.LEFT) {
                    this.func_184044_a(i - 91 - 26, i2, p_238443_1_, playerentity, itemstack);
                } else {
                    this.func_184044_a(i + 91 + 10, i2, p_238443_1_, playerentity, itemstack);
                }
            }
            if (this.field_73839_d.field_71474_y.field_186716_M == AttackIndicatorStatus.HOTBAR && (f = this.field_73839_d.field_71439_g.func_184825_o(0.0f)) < 1.0f) {
                int j2 = this.field_194812_I - 20;
                int k2 = i + 91 + 6;
                if (handside == HandSide.RIGHT) {
                    k2 = i - 91 - 22;
                }
                this.field_73839_d.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                int l1 = (int)(f * 19.0f);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_238474_b_(p_238443_2_, k2, j2, 0, 94, 18, 18);
                this.func_238474_b_(p_238443_2_, k2, j2 + 18 - l1, 18, 112 - l1, 18, l1);
            }
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableBlend();
        }
    }

    public void func_238446_a_(MatrixStack p_238446_1_, int p_238446_2_) {
        this.field_73839_d.func_213239_aq().func_76320_a("jumpBar");
        this.field_73839_d.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        float f = this.field_73839_d.field_71439_g.func_110319_bJ();
        int i = 182;
        int j = (int)(f * 183.0f);
        int k = this.field_194812_I - 32 + 3;
        this.func_238474_b_(p_238446_1_, p_238446_2_, k, 0, 84, 182, 5);
        if (j > 0) {
            this.func_238474_b_(p_238446_1_, p_238446_2_, k, 0, 89, j, 5);
        }
        this.field_73839_d.func_213239_aq().func_76319_b();
    }

    public void func_238454_b_(MatrixStack p_238454_1_, int p_238454_2_) {
        this.field_73839_d.func_213239_aq().func_76320_a("expBar");
        this.field_73839_d.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        int i = this.field_73839_d.field_71439_g.func_71050_bK();
        if (i > 0) {
            int j = 182;
            int k = (int)(this.field_73839_d.field_71439_g.field_71106_cc * 183.0f);
            int l = this.field_194812_I - 32 + 3;
            this.func_238474_b_(p_238454_1_, p_238454_2_, l, 0, 64, 182, 5);
            if (k > 0) {
                this.func_238474_b_(p_238454_1_, p_238454_2_, l, 0, 69, k, 5);
            }
        }
        this.field_73839_d.func_213239_aq().func_76319_b();
        if (this.field_73839_d.field_71439_g.field_71068_ca > 0) {
            this.field_73839_d.func_213239_aq().func_76320_a("expLevel");
            String s = "" + this.field_73839_d.field_71439_g.field_71068_ca;
            int i1 = (this.field_194811_H - this.func_175179_f().func_78256_a(s)) / 2;
            int j1 = this.field_194812_I - 31 - 4;
            this.func_175179_f().func_238421_b_(p_238454_1_, s, (float)(i1 + 1), (float)j1, 0);
            this.func_175179_f().func_238421_b_(p_238454_1_, s, (float)(i1 - 1), (float)j1, 0);
            this.func_175179_f().func_238421_b_(p_238454_1_, s, (float)i1, (float)(j1 + 1), 0);
            this.func_175179_f().func_238421_b_(p_238454_1_, s, (float)i1, (float)(j1 - 1), 0);
            this.func_175179_f().func_238421_b_(p_238454_1_, s, (float)i1, (float)j1, 8453920);
            this.field_73839_d.func_213239_aq().func_76319_b();
        }
    }

    public void func_238453_b_(MatrixStack p_238453_1_) {
        this.field_73839_d.func_213239_aq().func_76320_a("selectedItemName");
        if (this.field_92017_k > 0 && !this.field_92016_l.func_190926_b()) {
            int l;
            IFormattableTextComponent iformattabletextcomponent = new StringTextComponent("").func_230529_a_(this.field_92016_l.func_200301_q()).func_240699_a_(this.field_92016_l.func_77953_t().field_77937_e);
            if (this.field_92016_l.func_82837_s()) {
                iformattabletextcomponent.func_240699_a_(TextFormatting.ITALIC);
            }
            ITextComponent highlightTip = this.field_92016_l.getHighlightTip((ITextComponent)iformattabletextcomponent);
            int i = this.func_175179_f().func_238414_a_((ITextProperties)highlightTip);
            int j = (this.field_194811_H - i) / 2;
            int k = this.field_194812_I - 59;
            if (!this.field_73839_d.field_71442_b.func_78755_b()) {
                k += 14;
            }
            if ((l = (int)((float)this.field_92017_k * 256.0f / 10.0f)) > 255) {
                l = 255;
            }
            if (l > 0) {
                RenderSystem.pushMatrix();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                IngameGui.func_238467_a_((MatrixStack)p_238453_1_, (int)(j - 2), (int)(k - 2), (int)(j + i + 2), (int)(k + 9 + 2), (int)this.field_73839_d.field_71474_y.func_216839_a(0));
                FontRenderer font = this.field_92016_l.func_77973_b().getFontRenderer(this.field_92016_l);
                if (font == null) {
                    this.func_175179_f().func_243246_a(p_238453_1_, highlightTip, (float)j, (float)k, 0xFFFFFF + (l << 24));
                } else {
                    j = (this.field_194811_H - font.func_238414_a_((ITextProperties)highlightTip)) / 2;
                    font.func_243246_a(p_238453_1_, highlightTip, (float)j, (float)k, 0xFFFFFF + (l << 24));
                }
                RenderSystem.disableBlend();
                RenderSystem.popMatrix();
            }
        }
        this.field_73839_d.func_213239_aq().func_76319_b();
    }

    public void func_238455_c_(MatrixStack p_238455_1_) {
        this.field_73839_d.func_213239_aq().func_76320_a("demo");
        Object itextcomponent = this.field_73839_d.field_71441_e.func_82737_E() >= 120500L ? field_243249_e : new TranslationTextComponent("demo.remainingTime", StringUtils.func_76337_a((int)((int)(120500L - this.field_73839_d.field_71441_e.func_82737_E()))));
        int i = this.func_175179_f().func_238414_a_((ITextProperties)itextcomponent);
        this.func_175179_f().func_243246_a(p_238455_1_, itextcomponent, (float)(this.field_194811_H - i - 10), 5.0f, 0xFFFFFF);
        this.field_73839_d.func_213239_aq().func_76319_b();
    }

    protected void func_238447_a_(MatrixStack p_238447_1_, ScoreObjective p_238447_2_) {
        int i;
        Scoreboard scoreboard = p_238447_2_.func_96682_a();
        ArrayList collection = scoreboard.func_96534_i(p_238447_2_);
        ArrayList list = collection.stream().filter(p_212911_0_ -> p_212911_0_.func_96653_e() != null && !p_212911_0_.func_96653_e().startsWith("#")).collect(Collectors.toList());
        collection = list.size() > 15 ? Lists.newArrayList((Iterable)Iterables.skip(list, (int)(collection.size() - 15))) : list;
        ArrayList list1 = Lists.newArrayListWithCapacity((int)collection.size());
        ITextComponent itextcomponent = p_238447_2_.func_96678_d();
        int j = i = this.func_175179_f().func_238414_a_((ITextProperties)itextcomponent);
        int k = this.func_175179_f().func_78256_a(": ");
        for (Score score : collection) {
            ScorePlayerTeam scoreplayerteam = scoreboard.func_96509_i(score.func_96653_e());
            IFormattableTextComponent itextcomponent1 = ScorePlayerTeam.func_237500_a_((Team)scoreplayerteam, (ITextComponent)new StringTextComponent(score.func_96653_e()));
            list1.add(Pair.of((Object)score, (Object)itextcomponent1));
            j = Math.max(j, this.func_175179_f().func_238414_a_((ITextProperties)itextcomponent1) + k + this.func_175179_f().func_78256_a(Integer.toString(score.func_96652_c())));
        }
        int i2 = collection.size() * 9;
        int j2 = this.field_194812_I / 2 + i2 / 3;
        int k2 = 3;
        int l2 = this.field_194811_H - j - 3;
        int l = 0;
        int i1 = this.field_73839_d.field_71474_y.func_216841_b(0.3f);
        int j1 = this.field_73839_d.field_71474_y.func_216841_b(0.4f);
        for (Pair pair : list1) {
            Score score1 = (Score)pair.getFirst();
            ITextComponent itextcomponent2 = (ITextComponent)pair.getSecond();
            String s = TextFormatting.RED + "" + score1.func_96652_c();
            int k1 = j2 - ++l * 9;
            int l1 = this.field_194811_H - 3 + 2;
            IngameGui.func_238467_a_((MatrixStack)p_238447_1_, (int)(l2 - 2), (int)k1, (int)l1, (int)(k1 + 9), (int)i1);
            this.func_175179_f().func_243248_b(p_238447_1_, itextcomponent2, (float)l2, (float)k1, -1);
            this.func_175179_f().func_238421_b_(p_238447_1_, s, (float)(l1 - this.func_175179_f().func_78256_a(s)), (float)k1, -1);
            if (l != collection.size()) continue;
            IngameGui.func_238467_a_((MatrixStack)p_238447_1_, (int)(l2 - 2), (int)(k1 - 9 - 1), (int)l1, (int)(k1 - 1), (int)j1);
            IngameGui.func_238467_a_((MatrixStack)p_238447_1_, (int)(l2 - 2), (int)(k1 - 1), (int)l1, (int)k1, (int)i1);
            this.func_175179_f().func_243248_b(p_238447_1_, itextcomponent, (float)(l2 + j / 2 - i / 2), (float)(k1 - 9), -1);
        }
    }

    private PlayerEntity func_212304_m() {
        return !(this.field_73839_d.func_175606_aa() instanceof PlayerEntity) ? null : (PlayerEntity)this.field_73839_d.func_175606_aa();
    }

    private LivingEntity func_212305_n() {
        PlayerEntity playerentity = this.func_212304_m();
        if (playerentity != null) {
            Entity entity = playerentity.func_184187_bx();
            if (entity == null) {
                return null;
            }
            if (entity instanceof LivingEntity) {
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    private int func_212306_a(LivingEntity p_212306_1_) {
        if (p_212306_1_ != null && p_212306_1_.func_203003_aK()) {
            float f = p_212306_1_.func_110138_aP();
            int i = (int)(f + 0.5f) / 2;
            if (i > 30) {
                i = 30;
            }
            return i;
        }
        return 0;
    }

    private int func_212302_c(int p_212302_1_) {
        return (int)Math.ceil((double)p_212302_1_ / 10.0);
    }

    private void func_238457_e_(MatrixStack p_238457_1_) {
        PlayerEntity playerentity = this.func_212304_m();
        if (playerentity != null) {
            int i = MathHelper.func_76123_f((float)playerentity.func_110143_aJ());
            boolean flag = this.field_175191_F > (long)this.field_73837_f && (this.field_175191_F - (long)this.field_73837_f) / 3L % 2L == 1L;
            long j = Util.func_211177_b();
            if (i < this.field_175194_C && playerentity.field_70172_ad > 0) {
                this.field_175190_E = j;
                this.field_175191_F = this.field_73837_f + 20;
            } else if (i > this.field_175194_C && playerentity.field_70172_ad > 0) {
                this.field_175190_E = j;
                this.field_175191_F = this.field_73837_f + 10;
            }
            if (j - this.field_175190_E > 1000L) {
                this.field_175194_C = i;
                this.field_175189_D = i;
                this.field_175190_E = j;
            }
            this.field_175194_C = i;
            int k = this.field_175189_D;
            this.field_73842_c.setSeed(this.field_73837_f * 312871);
            FoodStats foodstats = playerentity.func_71024_bL();
            int l = foodstats.func_75116_a();
            int i1 = this.field_194811_H / 2 - 91;
            int j1 = this.field_194811_H / 2 + 91;
            int k1 = this.field_194812_I - 39;
            float f = (float)playerentity.func_233637_b_(Attributes.field_233818_a_);
            int l1 = MathHelper.func_76123_f((float)playerentity.func_110139_bj());
            int i2 = MathHelper.func_76123_f((float)((f + (float)l1) / 2.0f / 10.0f));
            int j2 = Math.max(10 - (i2 - 2), 3);
            int k2 = k1 - (i2 - 1) * j2 - 10;
            int l2 = k1 - 10;
            int i3 = l1;
            int j3 = playerentity.func_70658_aO();
            int k3 = -1;
            if (playerentity.func_70644_a(Effects.field_76428_l)) {
                k3 = this.field_73837_f % MathHelper.func_76123_f((float)(f + 5.0f));
            }
            this.field_73839_d.func_213239_aq().func_76320_a("armor");
            for (int l3 = 0; l3 < 10; ++l3) {
                if (j3 <= 0) continue;
                int i4 = i1 + l3 * 8;
                if (l3 * 2 + 1 < j3) {
                    this.func_238474_b_(p_238457_1_, i4, k2, 34, 9, 9, 9);
                }
                if (l3 * 2 + 1 == j3) {
                    this.func_238474_b_(p_238457_1_, i4, k2, 25, 9, 9, 9);
                }
                if (l3 * 2 + 1 <= j3) continue;
                this.func_238474_b_(p_238457_1_, i4, k2, 16, 9, 9, 9);
            }
            this.field_73839_d.func_213239_aq().func_219895_b("health");
            for (int l5 = MathHelper.func_76123_f((float)((f + (float)l1) / 2.0f)) - 1; l5 >= 0; --l5) {
                int i6 = 16;
                if (playerentity.func_70644_a(Effects.field_76436_u)) {
                    i6 += 36;
                } else if (playerentity.func_70644_a(Effects.field_82731_v)) {
                    i6 += 72;
                }
                int j4 = 0;
                if (flag) {
                    j4 = 1;
                }
                int k4 = MathHelper.func_76123_f((float)((float)(l5 + 1) / 10.0f)) - 1;
                int l4 = i1 + l5 % 10 * 8;
                int i5 = k1 - k4 * j2;
                if (i <= 4) {
                    i5 += this.field_73842_c.nextInt(2);
                }
                if (i3 <= 0 && l5 == k3) {
                    i5 -= 2;
                }
                int j5 = 0;
                if (playerentity.field_70170_p.func_72912_H().func_76093_s()) {
                    j5 = 5;
                }
                this.func_238474_b_(p_238457_1_, l4, i5, 16 + j4 * 9, 9 * j5, 9, 9);
                if (flag) {
                    if (l5 * 2 + 1 < k) {
                        this.func_238474_b_(p_238457_1_, l4, i5, i6 + 54, 9 * j5, 9, 9);
                    }
                    if (l5 * 2 + 1 == k) {
                        this.func_238474_b_(p_238457_1_, l4, i5, i6 + 63, 9 * j5, 9, 9);
                    }
                }
                if (i3 > 0) {
                    if (i3 == l1 && l1 % 2 == 1) {
                        this.func_238474_b_(p_238457_1_, l4, i5, i6 + 153, 9 * j5, 9, 9);
                        --i3;
                        continue;
                    }
                    this.func_238474_b_(p_238457_1_, l4, i5, i6 + 144, 9 * j5, 9, 9);
                    i3 -= 2;
                    continue;
                }
                if (l5 * 2 + 1 < i) {
                    this.func_238474_b_(p_238457_1_, l4, i5, i6 + 36, 9 * j5, 9, 9);
                }
                if (l5 * 2 + 1 != i) continue;
                this.func_238474_b_(p_238457_1_, l4, i5, i6 + 45, 9 * j5, 9, 9);
            }
            LivingEntity livingentity = this.func_212305_n();
            int j6 = this.func_212306_a(livingentity);
            if (j6 == 0) {
                this.field_73839_d.func_213239_aq().func_219895_b("food");
                for (int k6 = 0; k6 < 10; ++k6) {
                    int i7 = k1;
                    int k7 = 16;
                    int i8 = 0;
                    if (playerentity.func_70644_a(Effects.field_76438_s)) {
                        k7 += 36;
                        i8 = 13;
                    }
                    if (playerentity.func_71024_bL().func_75115_e() <= 0.0f && this.field_73837_f % (l * 3 + 1) == 0) {
                        i7 = k1 + (this.field_73842_c.nextInt(3) - 1);
                    }
                    int k8 = j1 - k6 * 8 - 9;
                    this.func_238474_b_(p_238457_1_, k8, i7, 16 + i8 * 9, 27, 9, 9);
                    if (k6 * 2 + 1 < l) {
                        this.func_238474_b_(p_238457_1_, k8, i7, k7 + 36, 27, 9, 9);
                    }
                    if (k6 * 2 + 1 != l) continue;
                    this.func_238474_b_(p_238457_1_, k8, i7, k7 + 45, 27, 9, 9);
                }
                l2 -= 10;
            }
            this.field_73839_d.func_213239_aq().func_219895_b("air");
            int l6 = playerentity.func_205010_bg();
            int j7 = Math.min(playerentity.func_70086_ai(), l6);
            if (playerentity.func_208600_a(FluidTags.field_206959_a) || j7 < l6) {
                int l7 = this.func_212302_c(j6) - 1;
                l2 -= l7 * 10;
                int j8 = MathHelper.func_76143_f((double)((double)(j7 - 2) * 10.0 / (double)l6));
                int l8 = MathHelper.func_76143_f((double)((double)j7 * 10.0 / (double)l6)) - j8;
                for (int k5 = 0; k5 < j8 + l8; ++k5) {
                    if (k5 < j8) {
                        this.func_238474_b_(p_238457_1_, j1 - k5 * 8 - 9, l2, 16, 18, 9, 9);
                        continue;
                    }
                    this.func_238474_b_(p_238457_1_, j1 - k5 * 8 - 9, l2, 25, 18, 9, 9);
                }
            }
            this.field_73839_d.func_213239_aq().func_76319_b();
        }
    }

    private void func_238458_f_(MatrixStack p_238458_1_) {
        int i;
        LivingEntity livingentity = this.func_212305_n();
        if (livingentity != null && (i = this.func_212306_a(livingentity)) != 0) {
            int j = (int)Math.ceil(livingentity.func_110143_aJ());
            this.field_73839_d.func_213239_aq().func_219895_b("mountHealth");
            int k = this.field_194812_I - 39;
            int l = this.field_194811_H / 2 + 91;
            int i1 = k;
            int j1 = 0;
            boolean flag = false;
            while (i > 0) {
                int k1 = Math.min(i, 10);
                i -= k1;
                for (int l1 = 0; l1 < k1; ++l1) {
                    int i2 = 52;
                    int j2 = 0;
                    int k2 = l - l1 * 8 - 9;
                    this.func_238474_b_(p_238458_1_, k2, i1, 52 + j2 * 9, 9, 9, 9);
                    if (l1 * 2 + 1 + j1 < j) {
                        this.func_238474_b_(p_238458_1_, k2, i1, 88, 9, 9, 9);
                    }
                    if (l1 * 2 + 1 + j1 != j) continue;
                    this.func_238474_b_(p_238458_1_, k2, i1, 97, 9, 9, 9);
                }
                i1 -= 10;
                j1 += 20;
            }
        }
    }

    protected void func_194808_p() {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        this.field_73839_d.func_110434_K().func_110577_a(field_110328_d);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(0.0, this.field_194812_I, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(this.field_194811_H, this.field_194812_I, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(this.field_194811_H, 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void func_212307_a(Entity p_212307_1_) {
        if (p_212307_1_ != null) {
            float f = MathHelper.func_76131_a((float)(1.0f - p_212307_1_.func_70013_c()), (float)0.0f, (float)1.0f);
            this.field_73843_a = (float)((double)this.field_73843_a + (double)(f - this.field_73843_a) * 0.01);
        }
    }

    protected void func_212303_b(Entity p_212303_1_) {
        WorldBorder worldborder = this.field_73839_d.field_71441_e.func_175723_af();
        float f = (float)worldborder.func_177745_a(p_212303_1_);
        double d0 = Math.min(worldborder.func_177749_o() * (double)worldborder.func_177740_p() * 1000.0, Math.abs(worldborder.func_177751_j() - worldborder.func_177741_h()));
        double d1 = Math.max((double)worldborder.func_177748_q(), d0);
        f = (double)f < d1 ? 1.0f - (float)((double)f / d1) : 0.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (f > 0.0f) {
            RenderSystem.color4f((float)0.0f, (float)f, (float)f, (float)1.0f);
        } else {
            RenderSystem.color4f((float)this.field_73843_a, (float)this.field_73843_a, (float)this.field_73843_a, (float)1.0f);
        }
        this.field_73839_d.func_110434_K().func_110577_a(field_110329_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(0.0, this.field_194812_I, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(this.field_194811_H, this.field_194812_I, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(this.field_194811_H, 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    protected void func_194805_e(float p_194805_1_) {
        if (p_194805_1_ < 1.0f) {
            p_194805_1_ *= p_194805_1_;
            p_194805_1_ *= p_194805_1_;
            p_194805_1_ = p_194805_1_ * 0.8f + 0.2f;
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)p_194805_1_);
        this.field_73839_d.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        TextureAtlasSprite textureatlassprite = this.field_73839_d.func_175602_ab().func_175023_a().func_178122_a(Blocks.field_150427_aO.func_176223_P());
        float f = textureatlassprite.func_94209_e();
        float f1 = textureatlassprite.func_94206_g();
        float f2 = textureatlassprite.func_94212_f();
        float f3 = textureatlassprite.func_94210_h();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(0.0, this.field_194812_I, -90.0).func_225583_a_(f, f3).func_181675_d();
        bufferbuilder.func_225582_a_(this.field_194811_H, this.field_194812_I, -90.0).func_225583_a_(f2, f3).func_181675_d();
        bufferbuilder.func_225582_a_(this.field_194811_H, 0.0, -90.0).func_225583_a_(f2, f1).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(f, f1).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void func_184044_a(int p_184044_1_, int p_184044_2_, float p_184044_3_, PlayerEntity p_184044_4_, ItemStack p_184044_5_) {
        if (!p_184044_5_.func_190926_b()) {
            float f = (float)p_184044_5_.func_190921_D() - p_184044_3_;
            if (f > 0.0f) {
                RenderSystem.pushMatrix();
                float f1 = 1.0f + f / 5.0f;
                RenderSystem.translatef((float)(p_184044_1_ + 8), (float)(p_184044_2_ + 12), (float)0.0f);
                RenderSystem.scalef((float)(1.0f / f1), (float)((f1 + 1.0f) / 2.0f), (float)1.0f);
                RenderSystem.translatef((float)(-(p_184044_1_ + 8)), (float)(-(p_184044_2_ + 12)), (float)0.0f);
            }
            this.field_73841_b.func_184391_a(p_184044_4_, p_184044_5_, p_184044_1_, p_184044_2_);
            if (f > 0.0f) {
                RenderSystem.popMatrix();
            }
            this.field_73841_b.func_175030_a(this.field_73839_d.field_71466_p, p_184044_5_, p_184044_1_, p_184044_2_);
        }
    }

    public void func_73831_a() {
        if (this.field_73845_h > 0) {
            --this.field_73845_h;
        }
        if (this.field_175195_w > 0) {
            --this.field_175195_w;
            if (this.field_175195_w <= 0) {
                this.field_175201_x = null;
                this.field_175200_y = null;
            }
        }
        ++this.field_73837_f;
        Entity entity = this.field_73839_d.func_175606_aa();
        if (entity != null) {
            this.func_212307_a(entity);
        }
        if (this.field_73839_d.field_71439_g != null) {
            ItemStack itemstack = this.field_73839_d.field_71439_g.field_71071_by.func_70448_g();
            if (itemstack.func_190926_b()) {
                this.field_92017_k = 0;
            } else if (!this.field_92016_l.func_190926_b() && itemstack.func_77973_b() == this.field_92016_l.func_77973_b() && itemstack.func_200301_q().equals(this.field_92016_l.func_200301_q()) && itemstack.getHighlightTip(itemstack.func_200301_q()).equals(this.field_92016_l.getHighlightTip(this.field_92016_l.func_200301_q()))) {
                if (this.field_92017_k > 0) {
                    --this.field_92017_k;
                }
            } else {
                this.field_92017_k = 40;
            }
            this.field_92016_l = itemstack;
        }
    }

    public void func_238451_a_(ITextComponent p_238451_1_) {
        this.func_175188_a((ITextComponent)new TranslationTextComponent("record.nowPlaying", p_238451_1_), true);
    }

    public void func_175188_a(ITextComponent p_175188_1_, boolean p_175188_2_) {
        this.field_73838_g = p_175188_1_;
        this.field_73845_h = 60;
        this.field_73844_j = p_175188_2_;
    }

    public void func_238452_a_(@Nullable ITextComponent p_238452_1_, @Nullable ITextComponent p_238452_2_, int p_238452_3_, int p_238452_4_, int p_238452_5_) {
        if (p_238452_1_ == null && p_238452_2_ == null && p_238452_3_ < 0 && p_238452_4_ < 0 && p_238452_5_ < 0) {
            this.field_175201_x = null;
            this.field_175200_y = null;
            this.field_175195_w = 0;
        } else if (p_238452_1_ != null) {
            this.field_175201_x = p_238452_1_;
            this.field_175195_w = this.field_175199_z + this.field_175192_A + this.field_175193_B;
        } else if (p_238452_2_ != null) {
            this.field_175200_y = p_238452_2_;
        } else {
            if (p_238452_3_ >= 0) {
                this.field_175199_z = p_238452_3_;
            }
            if (p_238452_4_ >= 0) {
                this.field_175192_A = p_238452_4_;
            }
            if (p_238452_5_ >= 0) {
                this.field_175193_B = p_238452_5_;
            }
            if (this.field_175195_w > 0) {
                this.field_175195_w = this.field_175199_z + this.field_175192_A + this.field_175193_B;
            }
        }
    }

    public UUID func_244795_b(ITextComponent p_244795_1_) {
        String s = TextProcessing.func_244782_a((ITextProperties)p_244795_1_);
        String s1 = org.apache.commons.lang3.StringUtils.substringBetween((String)s, (String)"<", (String)">");
        return s1 == null ? Util.field_240973_b_ : this.field_73839_d.func_244599_aA().func_244797_a(s1);
    }

    public void func_238450_a_(ChatType p_238450_1_, ITextComponent p_238450_2_, UUID p_238450_3_) {
        if (!(this.field_73839_d.func_238198_a_(p_238450_3_) || this.field_73839_d.field_71474_y.field_244794_ae && this.field_73839_d.func_238198_a_(this.func_244795_b(p_238450_2_)))) {
            for (IChatListener ichatlistener : this.field_191743_I.get(p_238450_1_)) {
                ichatlistener.func_192576_a(p_238450_1_, p_238450_2_, p_238450_3_);
            }
        }
    }

    public NewChatGui func_146158_b() {
        return this.field_73840_e;
    }

    public int func_73834_c() {
        return this.field_73837_f;
    }

    public FontRenderer func_175179_f() {
        return this.field_73839_d.field_71466_p;
    }

    public SpectatorGui func_175187_g() {
        return this.field_175197_u;
    }

    public PlayerTabOverlayGui func_175181_h() {
        return this.field_175196_v;
    }

    public void func_181029_i() {
        this.field_175196_v.func_181030_a();
        this.field_184050_w.func_184057_b();
        this.field_73839_d.func_193033_an().func_191788_b();
    }

    public BossOverlayGui func_184046_j() {
        return this.field_184050_w;
    }

    public void func_212910_m() {
        this.field_175198_t.func_212921_a();
    }
}

