/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementTreeNode;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementManager
extends JsonReloadListener {
    private static final Logger field_192782_a = LogManager.getLogger();
    private static final Gson field_192783_b = new GsonBuilder().create();
    private AdvancementList field_223388_c = new AdvancementList();
    private final LootPredicateManager field_240922_d_;

    public AdvancementManager(LootPredicateManager p_i232595_1_) {
        super(field_192783_b, "advancements");
        this.field_240922_d_ = p_i232595_1_;
    }

    protected void func_212853_a_(Map<ResourceLocation, JsonElement> p_212853_1_, IResourceManager p_212853_2_, IProfiler p_212853_3_) {
        HashMap map = Maps.newHashMap();
        p_212853_1_.forEach((p_240923_2_, p_240923_3_) -> {
            try {
                JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)p_240923_3_, (String)"advancement");
                Advancement.Builder advancement$builder = Advancement.Builder.func_241043_a_(jsonobject, new ConditionArrayParser(p_240923_2_, this.field_240922_d_));
                if (advancement$builder == null) {
                    field_192782_a.debug("Skipping loading advancement {} as it's conditions were not met", p_240923_2_);
                    return;
                }
                map.put(p_240923_2_, advancement$builder);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                field_192782_a.error("Parsing error loading custom advancement {}: {}", p_240923_2_, (Object)jsonparseexception.getMessage());
            }
        });
        AdvancementList advancementlist = new AdvancementList();
        advancementlist.func_192083_a(map);
        for (Advancement advancement : advancementlist.func_192088_b()) {
            if (advancement.func_192068_c() == null) continue;
            AdvancementTreeNode.func_192323_a((Advancement)advancement);
        }
        this.field_223388_c = advancementlist;
    }

    @Nullable
    public Advancement func_192778_a(ResourceLocation p_192778_1_) {
        return this.field_223388_c.func_192084_a(p_192778_1_);
    }

    public Collection<Advancement> func_195438_b() {
        return this.field_223388_c.func_195651_c();
    }
}

