/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.jigsaw;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.JigsawBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.EmptyJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JigsawManager {
    private static final Logger field_214892_b = LogManager.getLogger();

    public static void func_242837_a(DynamicRegistries dynamicRegistries, VillageConfig villageConfig, IPieceFactory iPieceFactory, ChunkGenerator chunkGenerator, TemplateManager templateManager, BlockPos blockPos, List<? super AbstractVillagePiece> list, Random random, boolean bl, boolean bl2) {
        Structure.func_236397_g_();
        MutableRegistry<JigsawPattern> mutableRegistry = dynamicRegistries.func_243612_b(Registry.field_243555_ax);
        Rotation \u26032 = Rotation.func_222466_a(random);
        JigsawPattern \u26033 = villageConfig.func_242810_c().get();
        JigsawPiece \u26034 = \u26033.func_214944_a(random);
        AbstractVillagePiece \u26035 = iPieceFactory.create(templateManager, \u26034, blockPos, \u26034.func_214850_d(), \u26032, \u26034.func_214852_a(templateManager, blockPos, \u26032));
        MutableBoundingBox \u26036 = \u26035.func_74874_b();
        int \u26037 = (\u26036.field_78893_d + \u26036.field_78897_a) / 2;
        int \u26038 = (\u26036.field_78892_f + \u26036.field_78896_c) / 2;
        int \u26039 = bl2 ? blockPos.func_177956_o() + chunkGenerator.func_222532_b(\u26037, \u26038, Heightmap.Type.WORLD_SURFACE_WG) : blockPos.func_177956_o();
        int \u260310 = \u26036.field_78895_b + \u26035.func_214830_d();
        \u26035.func_181138_a(0, \u26039 - \u260310, 0);
        list.add(\u26035);
        if (villageConfig.func_236534_a_() <= 0) {
            return;
        }
        int \u260311 = 80;
        AxisAlignedBB \u260312 = new AxisAlignedBB(\u26037 - 80, \u26039 - 80, \u26038 - 80, \u26037 + 80 + 1, \u26039 + 80 + 1, \u26038 + 80 + 1);
        Assembler \u260313 = new Assembler(mutableRegistry, villageConfig.func_236534_a_(), iPieceFactory, chunkGenerator, templateManager, list, random);
        \u260313.field_214888_g.addLast(new Entry(\u26035, new MutableObject((Object)VoxelShapes.func_197878_a(VoxelShapes.func_197881_a(\u260312), VoxelShapes.func_197881_a(AxisAlignedBB.func_216363_a(\u26036)), IBooleanFunction.field_223234_e_)), \u26039 + 80, 0));
        while (!\u260313.field_214888_g.isEmpty()) {
            Entry entry = (Entry)\u260313.field_214888_g.removeFirst();
            \u260313.func_236831_a_(entry.field_214876_a, (MutableObject<VoxelShape>)entry.field_214877_b, entry.field_214878_c, entry.field_214879_d, bl);
        }
    }

    public static void func_242838_a(DynamicRegistries dynamicRegistries, AbstractVillagePiece abstractVillagePiece, int n, IPieceFactory iPieceFactory, ChunkGenerator chunkGenerator, TemplateManager templateManager, List<? super AbstractVillagePiece> list, Random random) {
        MutableRegistry<JigsawPattern> mutableRegistry = dynamicRegistries.func_243612_b(Registry.field_243555_ax);
        Assembler \u26032 = new Assembler(mutableRegistry, n, iPieceFactory, chunkGenerator, templateManager, list, random);
        \u26032.field_214888_g.addLast(new Entry(abstractVillagePiece, new MutableObject((Object)VoxelShapes.field_216389_a), 0, 0));
        while (!\u26032.field_214888_g.isEmpty()) {
            Entry entry = (Entry)\u26032.field_214888_g.removeFirst();
            \u26032.func_236831_a_(entry.field_214876_a, (MutableObject<VoxelShape>)entry.field_214877_b, entry.field_214878_c, entry.field_214879_d, false);
        }
    }

    public static interface IPieceFactory {
        public AbstractVillagePiece create(TemplateManager var1, JigsawPiece var2, BlockPos var3, int var4, Rotation var5, MutableBoundingBox var6);
    }

    static final class Assembler {
        private final Registry<JigsawPattern> field_242839_a;
        private final int field_214882_a;
        private final IPieceFactory field_214883_b;
        private final ChunkGenerator field_214884_c;
        private final TemplateManager field_214885_d;
        private final List<? super AbstractVillagePiece> field_214886_e;
        private final Random field_214887_f;
        private final Deque<Entry> field_214888_g = Queues.newArrayDeque();

        private Assembler(Registry<JigsawPattern> registry, int n, IPieceFactory iPieceFactory, ChunkGenerator chunkGenerator, TemplateManager templateManager, List<? super AbstractVillagePiece> list, Random random) {
            this.field_242839_a = registry;
            this.field_214882_a = n;
            this.field_214883_b = iPieceFactory;
            this.field_214884_c = chunkGenerator;
            this.field_214885_d = templateManager;
            this.field_214886_e = list;
            this.field_214887_f = random;
        }

        private void func_236831_a_(AbstractVillagePiece abstractVillagePiece, MutableObject<VoxelShape> mutableObject, int n, int n2, boolean bl) {
            JigsawPiece jigsawPiece = abstractVillagePiece.func_214826_b();
            BlockPos \u26032 = abstractVillagePiece.func_214828_c();
            Rotation \u26033 = abstractVillagePiece.func_214809_Y_();
            JigsawPattern.PlacementBehaviour \u26034 = jigsawPiece.func_214854_c();
            boolean \u26035 = \u26034 == JigsawPattern.PlacementBehaviour.RIGID;
            MutableObject<VoxelShape> \u26036 = new MutableObject<VoxelShape>();
            MutableBoundingBox \u26037 = abstractVillagePiece.func_74874_b();
            int \u26038 = \u26037.field_78895_b;
            block0: for (Template.BlockInfo blockInfo2 : jigsawPiece.func_214849_a(this.field_214885_d, \u26032, \u26033, this.field_214887_f)) {
                int \u260318;
                Direction direction = JigsawBlock.func_235508_h_(blockInfo2.field_186243_b);
                BlockPos \u26039 = blockInfo2.field_186242_a;
                BlockPos \u260310 = \u26039.func_177972_a(direction);
                int \u260311 = \u26039.func_177956_o() - \u26038;
                int \u260312 = -1;
                ResourceLocation \u260313 = new ResourceLocation(blockInfo2.field_186244_c.func_74779_i("pool"));
                Optional<JigsawPattern> \u260314 = this.field_242839_a.func_241873_b(\u260313);
                if (!\u260314.isPresent() || \u260314.get().func_214946_c() == 0 && !Objects.equals(\u260313, JigsawPatternRegistry.field_244091_a.func_240901_a_())) {
                    field_214892_b.warn("Empty or none existent pool: {}", (Object)\u260313);
                    continue;
                }
                ResourceLocation \u260315 = \u260314.get().func_214948_a();
                Optional<JigsawPattern> \u260316 = this.field_242839_a.func_241873_b(\u260315);
                if (!\u260316.isPresent() || \u260316.get().func_214946_c() == 0 && !Objects.equals(\u260315, JigsawPatternRegistry.field_244091_a.func_240901_a_())) {
                    field_214892_b.warn("Empty or none existent fallback pool: {}", (Object)\u260315);
                    continue;
                }
                boolean \u260317 = \u26037.func_175898_b(\u260310);
                if (\u260317) {
                    MutableObject<VoxelShape> mutableObject2 = \u26036;
                    \u260318 = \u26038;
                    if (\u26036.getValue() == null) {
                        \u26036.setValue((Object)VoxelShapes.func_197881_a(AxisAlignedBB.func_216363_a(\u26037)));
                    }
                } else {
                    mutableObject2 = mutableObject;
                    \u260318 = n;
                }
                ArrayList arrayList = Lists.newArrayList();
                if (n2 != this.field_214882_a) {
                    arrayList.addAll(\u260314.get().func_214943_b(this.field_214887_f));
                }
                arrayList.addAll(\u260316.get().func_214943_b(this.field_214887_f));
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext() && (\u2603 = (JigsawPiece)iterator.next()) != EmptyJigsawPiece.field_214856_a) {
                    for (Rotation rotation : Rotation.func_222467_b(this.field_214887_f)) {
                        List<Template.BlockInfo> list = \u2603.func_214849_a(this.field_214885_d, BlockPos.field_177992_a, rotation, this.field_214887_f);
                        MutableBoundingBox \u260319 = \u2603.func_214852_a(this.field_214885_d, BlockPos.field_177992_a, rotation);
                        int \u260320 = !bl || \u260319.func_78882_c() > 16 ? 0 : list.stream().mapToInt(blockInfo -> {
                            if (!\u260319.func_175898_b(blockInfo.field_186242_a.func_177972_a(JigsawBlock.func_235508_h_(blockInfo.field_186243_b)))) {
                                return 0;
                            }
                            ResourceLocation resourceLocation = new ResourceLocation(blockInfo.field_186244_c.func_74779_i("pool"));
                            Optional<JigsawPattern> \u26032 = this.field_242839_a.func_241873_b(resourceLocation);
                            Optional<Integer> \u26033 = \u26032.flatMap(jigsawPattern -> this.field_242839_a.func_241873_b(jigsawPattern.func_214948_a()));
                            int \u26034 = \u26032.map(jigsawPattern -> jigsawPattern.func_214945_a(this.field_214885_d)).orElse(0);
                            int \u26035 = \u26033.map(jigsawPattern -> jigsawPattern.func_214945_a(this.field_214885_d)).orElse(0);
                            return Math.max(\u26034, \u26035);
                        }).max().orElse(0);
                        for (Template.BlockInfo blockInfo3 : list) {
                            int n3;
                            if (!JigsawBlock.func_220171_a(blockInfo2, blockInfo3)) continue;
                            BlockPos blockPos = blockInfo3.field_186242_a;
                            \u2603 = new BlockPos(\u260310.func_177958_n() - blockPos.func_177958_n(), \u260310.func_177956_o() - blockPos.func_177956_o(), \u260310.func_177952_p() - blockPos.func_177952_p());
                            MutableBoundingBox \u260321 = \u2603.func_214852_a(this.field_214885_d, \u2603, rotation);
                            int \u260322 = \u260321.field_78895_b;
                            JigsawPattern.PlacementBehaviour \u260323 = \u2603.func_214854_c();
                            boolean \u260324 = \u260323 == JigsawPattern.PlacementBehaviour.RIGID;
                            int \u260325 = blockPos.func_177956_o();
                            int \u260326 = \u260311 - \u260325 + JigsawBlock.func_235508_h_(blockInfo2.field_186243_b).func_96559_d();
                            if (\u26035 && \u260324) {
                                n3 = \u26038 + \u260326;
                            } else {
                                if (\u260312 == -1) {
                                    \u260312 = this.field_214884_c.func_222532_b(\u26039.func_177958_n(), \u26039.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                                }
                                n3 = \u260312 - \u260325;
                            }
                            \u2603 = n3 - \u260322;
                            MutableBoundingBox \u260327 = \u260321.func_215127_b(0, \u2603, 0);
                            BlockPos \u260328 = \u2603.func_177982_a(0, \u2603, 0);
                            if (\u260320 > 0) {
                                \u2603 = Math.max(\u260320 + 1, \u260327.field_78894_e - \u260327.field_78895_b);
                                \u260327.field_78894_e = \u260327.field_78895_b + \u2603;
                            }
                            if (VoxelShapes.func_197879_c((VoxelShape)mutableObject2.getValue(), VoxelShapes.func_197881_a(AxisAlignedBB.func_216363_a(\u260327).func_186664_h(0.25)), IBooleanFunction.field_223232_c_)) continue;
                            mutableObject2.setValue((Object)VoxelShapes.func_197882_b((VoxelShape)mutableObject2.getValue(), VoxelShapes.func_197881_a(AxisAlignedBB.func_216363_a(\u260327)), IBooleanFunction.field_223234_e_));
                            \u2603 = abstractVillagePiece.func_214830_d();
                            \u2603 = \u260324 ? \u2603 - \u260326 : \u2603.func_214850_d();
                            AbstractVillagePiece \u260329 = this.field_214883_b.create(this.field_214885_d, \u2603, \u260328, \u2603, rotation, \u260327);
                            if (\u26035) {
                                \u2603 = \u26038 + \u260311;
                            } else if (\u260324) {
                                \u2603 = n3 + \u260325;
                            } else {
                                if (\u260312 == -1) {
                                    \u260312 = this.field_214884_c.func_222532_b(\u26039.func_177958_n(), \u26039.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                                }
                                \u2603 = \u260312 + \u260326 / 2;
                            }
                            abstractVillagePiece.func_214831_a(new JigsawJunction(\u260310.func_177958_n(), \u2603 - \u260311 + \u2603, \u260310.func_177952_p(), \u260326, \u260323));
                            \u260329.func_214831_a(new JigsawJunction(\u26039.func_177958_n(), \u2603 - \u260325 + \u2603, \u26039.func_177952_p(), -\u260326, \u26034));
                            this.field_214886_e.add(\u260329);
                            if (n2 + 1 > this.field_214882_a) continue block0;
                            this.field_214888_g.addLast(new Entry(\u260329, mutableObject2, \u260318, n2 + 1));
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    static final class Entry {
        private final AbstractVillagePiece field_214876_a;
        private final MutableObject<VoxelShape> field_214877_b;
        private final int field_214878_c;
        private final int field_214879_d;

        private Entry(AbstractVillagePiece abstractVillagePiece, MutableObject<VoxelShape> mutableObject, int n, int n2) {
            this.field_214876_a = abstractVillagePiece;
            this.field_214877_b = mutableObject;
            this.field_214878_c = n;
            this.field_214879_d = n2;
        }
    }
}

