/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text.event;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoverEvent {
    private static final Logger field_240660_a_ = LogManager.getLogger();
    private final Action<?> field_150704_a;
    private final Object field_150703_b;

    public <T> HoverEvent(Action<T> action, T t) {
        this.field_150704_a = action;
        this.field_150703_b = t;
    }

    public Action<?> func_150701_a() {
        return this.field_150704_a;
    }

    @Nullable
    public <T> T func_240662_a_(Action<T> action) {
        if (this.field_150704_a == action) {
            return (T)((Action)action).func_240674_b_(this.field_150703_b);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HoverEvent hoverEvent = (HoverEvent)object;
        return this.field_150704_a == hoverEvent.field_150704_a && Objects.equals(this.field_150703_b, hoverEvent.field_150703_b);
    }

    public String toString() {
        return "HoverEvent{action=" + this.field_150704_a + ", value='" + this.field_150703_b + '\'' + '}';
    }

    public int hashCode() {
        int n = this.field_150704_a.hashCode();
        n = 31 * n + (this.field_150703_b != null ? this.field_150703_b.hashCode() : 0);
        return n;
    }

    @Nullable
    public static HoverEvent func_240661_a_(JsonObject jsonObject) {
        String string = JSONUtils.func_151219_a(jsonObject, "action", null);
        if (string == null) {
            return null;
        }
        Action \u26032 = Action.func_150684_a(string);
        if (\u26032 == null) {
            return null;
        }
        JsonElement \u26033 = jsonObject.get("contents");
        if (\u26033 != null) {
            return \u26032.func_240668_a_(\u26033);
        }
        IFormattableTextComponent \u26034 = ITextComponent.Serializer.func_240641_a_(jsonObject.get("value"));
        if (\u26034 != null) {
            return \u26032.func_240670_a_(\u26034);
        }
        return null;
    }

    public JsonObject func_240663_b_() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("action", this.field_150704_a.func_150685_b());
        jsonObject.add("contents", this.field_150704_a.func_240669_a_(this.field_150703_b));
        return jsonObject;
    }

    public static class Action<T> {
        public static final Action<ITextComponent> field_230550_a_ = new Action<ITextComponent>("show_text", true, ITextComponent.Serializer::func_240641_a_, ITextComponent.Serializer::func_200528_b, Function.identity());
        public static final Action<ItemHover> field_230551_b_ = new Action<ItemHover>("show_item", true, jsonElement -> ItemHover.func_240690_a_(jsonElement), object -> ItemHover.func_240692_a_((ItemHover)object), iTextComponent -> ItemHover.func_240691_a_(iTextComponent));
        public static final Action<EntityHover> field_230552_c_ = new Action<EntityHover>("show_entity", true, EntityHover::func_240682_a_, EntityHover::func_240681_a_, EntityHover::func_240683_a_);
        private static final Map<String, Action> field_150690_d = (Map)Stream.of(field_230550_a_, field_230551_b_, field_230552_c_).collect(ImmutableMap.toImmutableMap(Action::func_150685_b, action -> action));
        private final String field_150688_f;
        private final boolean field_150691_e;
        private final Function<JsonElement, T> field_240665_g_;
        private final Function<T, JsonElement> field_240666_h_;
        private final Function<ITextComponent, T> field_240667_i_;

        public Action(String string, boolean bl, Function<JsonElement, T> function, Function<T, JsonElement> function2, Function<ITextComponent, T> function3) {
            this.field_150688_f = string;
            this.field_150691_e = bl;
            this.field_240665_g_ = function;
            this.field_240666_h_ = function2;
            this.field_240667_i_ = function3;
        }

        public boolean func_150686_a() {
            return this.field_150691_e;
        }

        public String func_150685_b() {
            return this.field_150688_f;
        }

        @Nullable
        public static Action func_150684_a(String string) {
            return field_150690_d.get(string);
        }

        private T func_240674_b_(Object object) {
            return (T)object;
        }

        @Nullable
        public HoverEvent func_240668_a_(JsonElement jsonElement) {
            T t = this.field_240665_g_.apply(jsonElement);
            if (t == null) {
                return null;
            }
            return new HoverEvent(this, t);
        }

        @Nullable
        public HoverEvent func_240670_a_(ITextComponent iTextComponent) {
            T t = this.field_240667_i_.apply(iTextComponent);
            if (t == null) {
                return null;
            }
            return new HoverEvent(this, t);
        }

        public JsonElement func_240669_a_(Object object) {
            return this.field_240666_h_.apply(this.func_240674_b_(object));
        }

        public String toString() {
            return "<action " + this.field_150688_f + ">";
        }
    }

    public static class ItemHover {
        private final Item field_240685_a_;
        private final int field_240686_b_;
        @Nullable
        private final CompoundNBT field_240687_c_;

        ItemHover(Item item, int n, @Nullable CompoundNBT compoundNBT) {
            this.field_240685_a_ = item;
            this.field_240686_b_ = n;
            this.field_240687_c_ = compoundNBT;
        }

        public ItemHover(ItemStack itemStack) {
            this(itemStack.func_77973_b(), itemStack.func_190916_E(), itemStack.func_77978_p() != null ? itemStack.func_77978_p().func_74737_b() : null);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ItemHover itemHover = (ItemHover)object;
            return this.field_240686_b_ == itemHover.field_240686_b_ && this.field_240685_a_.equals(itemHover.field_240685_a_) && Objects.equals(this.field_240687_c_, itemHover.field_240687_c_);
        }

        public int hashCode() {
            int n = this.field_240685_a_.hashCode();
            n = 31 * n + this.field_240686_b_;
            n = 31 * n + (this.field_240687_c_ != null ? this.field_240687_c_.hashCode() : 0);
            return n;
        }

        private static ItemHover func_240694_b_(JsonElement jsonElement) {
            if (jsonElement.isJsonPrimitive()) {
                return new ItemHover(Registry.field_212630_s.func_82594_a(new ResourceLocation(jsonElement.getAsString())), 1, null);
            }
            JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "item");
            Item \u26032 = Registry.field_212630_s.func_82594_a(new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "id")));
            int \u26033 = JSONUtils.func_151208_a(jsonObject, "count", 1);
            if (jsonObject.has("tag")) {
                String string = JSONUtils.func_151200_h(jsonObject, "tag");
                try {
                    CompoundNBT compoundNBT = JsonToNBT.func_180713_a(string);
                    return new ItemHover(\u26032, \u26033, compoundNBT);
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    field_240660_a_.warn("Failed to parse tag: {}", (Object)string, (Object)commandSyntaxException);
                }
            }
            return new ItemHover(\u26032, \u26033, null);
        }

        @Nullable
        private static ItemHover func_240695_b_(ITextComponent iTextComponent) {
            try {
                CompoundNBT compoundNBT = JsonToNBT.func_180713_a(iTextComponent.getString());
                return new ItemHover(ItemStack.func_199557_a(compoundNBT));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                field_240660_a_.warn("Failed to parse item tag: {}", (Object)iTextComponent, (Object)commandSyntaxException);
                return null;
            }
        }

        private JsonElement func_240693_b_() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", Registry.field_212630_s.func_177774_c(this.field_240685_a_).toString());
            if (this.field_240686_b_ != 1) {
                jsonObject.addProperty("count", (Number)this.field_240686_b_);
            }
            if (this.field_240687_c_ != null) {
                jsonObject.addProperty("tag", this.field_240687_c_.toString());
            }
            return jsonObject;
        }
    }

    public static class EntityHover {
        public final EntityType<?> field_240677_a_;
        public final UUID field_240678_b_;
        @Nullable
        public final ITextComponent field_240679_c_;

        public EntityHover(EntityType<?> entityType, UUID uUID, @Nullable ITextComponent iTextComponent) {
            this.field_240677_a_ = entityType;
            this.field_240678_b_ = uUID;
            this.field_240679_c_ = iTextComponent;
        }

        @Nullable
        public static EntityHover func_240682_a_(JsonElement jsonElement) {
            if (!jsonElement.isJsonObject()) {
                return null;
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            EntityType<?> \u26032 = Registry.field_212629_r.func_82594_a(new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "type")));
            UUID \u26033 = UUID.fromString(JSONUtils.func_151200_h(jsonObject, "id"));
            IFormattableTextComponent \u26034 = ITextComponent.Serializer.func_240641_a_(jsonObject.get("name"));
            return new EntityHover(\u26032, \u26033, \u26034);
        }

        @Nullable
        public static EntityHover func_240683_a_(ITextComponent iTextComponent) {
            try {
                CompoundNBT compoundNBT = JsonToNBT.func_180713_a(iTextComponent.getString());
                IFormattableTextComponent \u26032 = ITextComponent.Serializer.func_240643_a_(compoundNBT.func_74779_i("name"));
                EntityType<?> \u26033 = Registry.field_212629_r.func_82594_a(new ResourceLocation(compoundNBT.func_74779_i("type")));
                UUID \u26034 = UUID.fromString(compoundNBT.func_74779_i("id"));
                return new EntityHover(\u26033, \u26034, \u26032);
            }
            catch (JsonSyntaxException | CommandSyntaxException throwable) {
                return null;
            }
        }

        public JsonElement func_240681_a_() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", Registry.field_212629_r.func_177774_c(this.field_240677_a_).toString());
            jsonObject.addProperty("id", this.field_240678_b_.toString());
            if (this.field_240679_c_ != null) {
                jsonObject.add("name", ITextComponent.Serializer.func_200528_b(this.field_240679_c_));
            }
            return jsonObject;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            EntityHover entityHover = (EntityHover)object;
            return this.field_240677_a_.equals(entityHover.field_240677_a_) && this.field_240678_b_.equals(entityHover.field_240678_b_) && Objects.equals(this.field_240679_c_, entityHover.field_240679_c_);
        }

        public int hashCode() {
            int n = this.field_240677_a_.hashCode();
            n = 31 * n + this.field_240678_b_.hashCode();
            n = 31 * n + (this.field_240679_c_ != null ? this.field_240679_c_.hashCode() : 0);
            return n;
        }
    }
}

