/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.palette;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Direction8;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.palette.PalettedContainer;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpgradeData {
    private static final Logger field_209162_b = LogManager.getLogger();
    public static final UpgradeData field_196994_a = new UpgradeData();
    private static final Direction8[] field_208832_b = Direction8.values();
    private final EnumSet<Direction8> field_196995_b = EnumSet.noneOf(Direction8.class);
    private final int[][] field_196996_c = new int[16][];
    private static final Map<Block, IBlockFixer> field_196997_d = new IdentityHashMap<Block, IBlockFixer>();
    private static final Set<IBlockFixer> field_208833_f = Sets.newHashSet();

    private UpgradeData() {
    }

    public UpgradeData(CompoundNBT compoundNBT2) {
        this();
        CompoundNBT compoundNBT2;
        if (compoundNBT2.func_150297_b("Indices", 10)) {
            \u2603 = compoundNBT2.func_74775_l("Indices");
            for (int i = 0; i < this.field_196996_c.length; ++i) {
                String string = String.valueOf(i);
                if (!\u2603.func_150297_b(string, 11)) continue;
                this.field_196996_c[i] = \u2603.func_74759_k(string);
            }
        }
        int \u26032 = compoundNBT2.func_74762_e("Sides");
        for (Direction8 direction8 : Direction8.values()) {
            if ((\u26032 & 1 << direction8.ordinal()) == 0) continue;
            this.field_196995_b.add(direction8);
        }
    }

    public void func_196990_a(Chunk chunk2) {
        Chunk chunk2;
        this.func_196989_a(chunk2);
        for (Direction8 direction8 : field_208832_b) {
            UpgradeData.func_196991_a(chunk2, direction8);
        }
        World \u26032 = chunk2.func_177412_p();
        field_208833_f.forEach(iBlockFixer -> iBlockFixer.func_208826_a(\u26032));
    }

    private static void func_196991_a(Chunk chunk, Direction8 direction8) {
        World world = chunk.func_177412_p();
        if (!chunk.func_196966_y().field_196995_b.remove((Object)direction8)) {
            return;
        }
        Set<Direction> \u26032 = direction8.func_197532_a();
        boolean \u26033 = false;
        int \u26034 = 15;
        boolean \u26035 = \u26032.contains(Direction.EAST);
        boolean \u26036 = \u26032.contains(Direction.WEST);
        boolean \u26037 = \u26032.contains(Direction.SOUTH);
        boolean \u26038 = \u26032.contains(Direction.NORTH);
        boolean \u26039 = \u26032.size() == 1;
        ChunkPos \u260310 = chunk.func_76632_l();
        int \u260311 = \u260310.func_180334_c() + (\u26039 && (\u26038 || \u26037) ? 1 : (\u26036 ? 0 : 15));
        int \u260312 = \u260310.func_180334_c() + (\u26039 && (\u26038 || \u26037) ? 14 : (\u26036 ? 0 : 15));
        int \u260313 = \u260310.func_180333_d() + (\u26039 && (\u26035 || \u26036) ? 1 : (\u26038 ? 0 : 15));
        int \u260314 = \u260310.func_180333_d() + (\u26039 && (\u26035 || \u26036) ? 14 : (\u26038 ? 0 : 15));
        Direction[] \u260315 = Direction.values();
        BlockPos.Mutable \u260316 = new BlockPos.Mutable();
        for (BlockPos blockPos : BlockPos.func_191531_b(\u260311, 0, \u260313, \u260312, world.func_217301_I() - 1, \u260314)) {
            BlockState blockState;
            BlockState blockState2 = blockState = world.func_180495_p(blockPos);
            for (Direction direction : \u260315) {
                \u260316.func_239622_a_(blockPos, direction);
                blockState2 = UpgradeData.func_196987_a(blockState2, direction, world, blockPos, \u260316);
            }
            Block.func_196263_a(blockState, blockState2, world, blockPos, 18);
        }
    }

    private static BlockState func_196987_a(BlockState blockState, Direction direction, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        return field_196997_d.getOrDefault(blockState.func_177230_c(), BlockFixers.DEFAULT).func_196982_a(blockState, direction, iWorld.func_180495_p(blockPos2), iWorld, blockPos, blockPos2);
    }

    private void func_196989_a(Chunk chunk) {
        int n;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        \u2603 = new BlockPos.Mutable();
        ChunkPos \u26032 = chunk.func_76632_l();
        World \u26033 = chunk.func_177412_p();
        for (n = 0; n < 16; ++n) {
            ChunkSection chunkSection = chunk.func_76587_i()[n];
            int[] \u26034 = this.field_196996_c[n];
            this.field_196996_c[n] = null;
            if (chunkSection == null || \u26034 == null || \u26034.length <= 0) continue;
            Direction[] \u26035 = Direction.values();
            PalettedContainer<BlockState> \u26036 = chunkSection.func_186049_g();
            for (int n2 : \u26034) {
                BlockState blockState;
                \u2603 = n2 & 0xF;
                \u2603 = n2 >> 8 & 0xF;
                \u2603 = n2 >> 4 & 0xF;
                mutable.func_181079_c(\u26032.func_180334_c() + \u2603, (n << 4) + \u2603, \u26032.func_180333_d() + \u2603);
                BlockState blockState2 = blockState = \u26036.func_186015_a(n2);
                for (Direction direction : \u26035) {
                    \u2603.func_239622_a_(mutable, direction);
                    if (mutable.func_177958_n() >> 4 != \u26032.field_77276_a || mutable.func_177952_p() >> 4 != \u26032.field_77275_b) continue;
                    blockState2 = UpgradeData.func_196987_a(blockState2, direction, \u26033, mutable, \u2603);
                }
                Block.func_196263_a(blockState, blockState2, \u26033, mutable, 18);
            }
        }
        for (n = 0; n < this.field_196996_c.length; ++n) {
            if (this.field_196996_c[n] != null) {
                field_209162_b.warn("Discarding update data for section {} for chunk ({} {})", (Object)n, (Object)\u26032.field_77276_a, (Object)\u26032.field_77275_b);
            }
            this.field_196996_c[n] = null;
        }
    }

    public boolean func_196988_a() {
        for (int[] nArray : this.field_196996_c) {
            if (nArray == null) continue;
            return false;
        }
        return this.field_196995_b.isEmpty();
    }

    public CompoundNBT func_196992_b() {
        CompoundNBT compoundNBT;
        int \u26032;
        CompoundNBT compoundNBT2 = new CompoundNBT();
        compoundNBT = new CompoundNBT();
        for (\u26032 = 0; \u26032 < this.field_196996_c.length; ++\u26032) {
            String string = String.valueOf(\u26032);
            if (this.field_196996_c[\u26032] == null || this.field_196996_c[\u26032].length == 0) continue;
            compoundNBT.func_74783_a(string, this.field_196996_c[\u26032]);
        }
        if (!compoundNBT.isEmpty()) {
            compoundNBT2.func_218657_a("Indices", compoundNBT);
        }
        \u26032 = 0;
        for (Direction8 direction8 : this.field_196995_b) {
            \u26032 |= 1 << direction8.ordinal();
        }
        compoundNBT2.func_74774_a("Sides", (byte)\u26032);
        return compoundNBT2;
    }

    static enum BlockFixers implements IBlockFixer
    {
        BLACKLIST(new Block[]{Blocks.field_190976_dk, Blocks.field_150427_aO, Blocks.field_196860_iS, Blocks.field_196862_iT, Blocks.field_196864_iU, Blocks.field_196866_iV, Blocks.field_196868_iW, Blocks.field_196870_iX, Blocks.field_196872_iY, Blocks.field_196874_iZ, Blocks.field_196877_ja, Blocks.field_196878_jb, Blocks.field_196879_jc, Blocks.field_196880_jd, Blocks.field_196881_je, Blocks.field_196882_jf, Blocks.field_196883_jg, Blocks.field_196884_jh, Blocks.field_150467_bQ, Blocks.field_196717_eY, Blocks.field_196718_eZ, Blocks.field_150380_bt, Blocks.field_150351_n, Blocks.field_150354_m, Blocks.field_196611_F, Blocks.field_222384_bX, Blocks.field_222385_bY, Blocks.field_222386_bZ, Blocks.field_222389_ca, Blocks.field_222390_cb, Blocks.field_222391_cc, Blocks.field_222392_ch, Blocks.field_222393_ci, Blocks.field_222394_cj, Blocks.field_222395_ck, Blocks.field_222396_cl, Blocks.field_222397_cm}){

            @Override
            public BlockState func_196982_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
                return blockState;
            }
        }
        ,
        DEFAULT(new Block[0]){

            @Override
            public BlockState func_196982_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
                return blockState.func_196956_a(direction, iWorld.func_180495_p(blockPos2), iWorld, blockPos, blockPos2);
            }
        }
        ,
        CHEST(new Block[]{Blocks.field_150486_ae, Blocks.field_150447_bR}){

            @Override
            public BlockState func_196982_a(BlockState blockState3, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
                BlockState blockState3;
                if (blockState2.func_203425_a(blockState3.func_177230_c()) && direction.func_176740_k().func_176722_c() && blockState3.func_177229_b(ChestBlock.field_196314_b) == ChestType.SINGLE && blockState2.func_177229_b(ChestBlock.field_196314_b) == ChestType.SINGLE) {
                    Direction direction2 = blockState3.func_177229_b(ChestBlock.field_176459_a);
                    if (direction.func_176740_k() != direction2.func_176740_k() && direction2 == blockState2.func_177229_b(ChestBlock.field_176459_a)) {
                        ChestType chestType = direction == direction2.func_176746_e() ? ChestType.LEFT : ChestType.RIGHT;
                        iWorld.func_180501_a(blockPos2, (BlockState)blockState2.func_206870_a(ChestBlock.field_196314_b, chestType.func_208081_a()), 18);
                        if (direction2 == Direction.NORTH || direction2 == Direction.EAST) {
                            TileEntity tileEntity = iWorld.func_175625_s(blockPos);
                            \u2603 = iWorld.func_175625_s(blockPos2);
                            if (tileEntity instanceof ChestTileEntity && \u2603 instanceof ChestTileEntity) {
                                ChestTileEntity.func_199722_a((ChestTileEntity)tileEntity, (ChestTileEntity)\u2603);
                            }
                        }
                        return (BlockState)blockState3.func_206870_a(ChestBlock.field_196314_b, chestType);
                    }
                }
                return blockState3;
            }
        }
        ,
        LEAVES(true, new Block[]{Blocks.field_196572_aa, Blocks.field_196647_Y, Blocks.field_196574_ab, Blocks.field_196648_Z, Blocks.field_196642_W, Blocks.field_196645_X}){
            private final ThreadLocal<List<ObjectSet<BlockPos>>> field_208828_g = ThreadLocal.withInitial(() -> Lists.newArrayListWithCapacity((int)7));

            @Override
            public BlockState func_196982_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
                BlockState blockState3 = blockState.func_196956_a(direction, iWorld.func_180495_p(blockPos2), iWorld, blockPos, blockPos2);
                if (blockState != blockState3) {
                    int n = blockState3.func_177229_b(BlockStateProperties.field_208514_aa);
                    List<ObjectSet<BlockPos>> \u26032 = this.field_208828_g.get();
                    if (\u26032.isEmpty()) {
                        for (\u2603 = 0; \u2603 < 7; ++\u2603) {
                            \u26032.add((ObjectSet<BlockPos>)new ObjectOpenHashSet());
                        }
                    }
                    \u26032.get(n).add((Object)blockPos.func_185334_h());
                }
                return blockState;
            }

            @Override
            public void func_208826_a(IWorld iWorld) {
                BlockPos.Mutable mutable = new BlockPos.Mutable();
                List<ObjectSet<BlockPos>> \u26032 = this.field_208828_g.get();
                for (int i = 2; i < \u26032.size(); ++i) {
                    \u2603 = i - 1;
                    ObjectSet<BlockPos> objectSet = \u26032.get(\u2603);
                    \u2603 = \u26032.get(i);
                    for (BlockPos blockPos : objectSet) {
                        BlockState blockState = iWorld.func_180495_p(blockPos);
                        if (blockState.func_177229_b(BlockStateProperties.field_208514_aa) < \u2603) continue;
                        iWorld.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(BlockStateProperties.field_208514_aa, \u2603), 18);
                        if (i == 7) continue;
                        for (Direction direction : field_208827_f) {
                            mutable.func_239622_a_(blockPos, direction);
                            BlockState blockState2 = iWorld.func_180495_p(mutable);
                            if (!blockState2.func_235901_b_(BlockStateProperties.field_208514_aa) || blockState.func_177229_b(BlockStateProperties.field_208514_aa) <= i) continue;
                            \u2603.add((Object)mutable.func_185334_h());
                        }
                    }
                }
                \u26032.clear();
            }
        }
        ,
        STEM_BLOCK(new Block[]{Blocks.field_150394_bc, Blocks.field_150393_bb}){

            @Override
            public BlockState func_196982_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
                if (blockState.func_177229_b(StemBlock.field_176484_a) == 7 && blockState2.func_203425_a(\u2603 = ((StemBlock)blockState.func_177230_c()).func_208486_d())) {
                    return (BlockState)\u2603.func_196523_e().func_176223_P().func_206870_a(HorizontalBlock.field_185512_D, direction);
                }
                return blockState;
            }
        };

        public static final Direction[] field_208827_f;

        private BlockFixers(Block ... blockArray) {
            this(false, blockArray);
        }

        private BlockFixers(boolean bl2, Block ... blockArray) {
            boolean bl2;
            for (Block block : blockArray) {
                field_196997_d.put(block, this);
            }
            if (bl2) {
                field_208833_f.add(this);
            }
        }

        static {
            field_208827_f = Direction.values();
        }
    }

    public static interface IBlockFixer {
        public BlockState func_196982_a(BlockState var1, Direction var2, BlockState var3, IWorld var4, BlockPos var5, BlockPos var6);

        default public void func_208826_a(IWorld iWorld) {
        }
    }
}

