/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ILootGenerator;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntryManager;
import net.minecraft.loot.LootPoolEntryType;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class TagLootEntry
extends StandaloneLootEntry {
    private final ITag<Item> field_216180_c;
    private final boolean field_216181_h;

    private TagLootEntry(ITag<Item> iTag, boolean bl, int n, int n2, ILootCondition[] iLootConditionArray, ILootFunction[] iLootFunctionArray) {
        super(n, n2, iLootConditionArray, iLootFunctionArray);
        this.field_216180_c = iTag;
        this.field_216181_h = bl;
    }

    @Override
    public LootPoolEntryType func_230420_a_() {
        return LootEntryManager.field_237414_e_;
    }

    @Override
    public void func_216154_a(Consumer<ItemStack> consumer, LootContext lootContext) {
        this.field_216180_c.func_230236_b_().forEach(item -> consumer.accept(new ItemStack((IItemProvider)item)));
    }

    private boolean func_216179_a(LootContext lootContext, Consumer<ILootGenerator> consumer) {
        if (this.func_216141_a(lootContext)) {
            for (final Item item : this.field_216180_c.func_230236_b_()) {
                consumer.accept(new StandaloneLootEntry.Generator(){

                    @Override
                    public void func_216188_a(Consumer<ItemStack> consumer, LootContext lootContext) {
                        consumer.accept(new ItemStack(item));
                    }
                });
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean expand(LootContext lootContext, Consumer<ILootGenerator> consumer) {
        if (this.field_216181_h) {
            return this.func_216179_a(lootContext, consumer);
        }
        return super.expand(lootContext, consumer);
    }

    public static StandaloneLootEntry.Builder<?> func_216176_b(ITag<Item> iTag) {
        return TagLootEntry.func_216156_a((n, n2, iLootConditionArray, iLootFunctionArray) -> new TagLootEntry(iTag, true, n, n2, iLootConditionArray, iLootFunctionArray));
    }

    public static class Serializer
    extends StandaloneLootEntry.Serializer<TagLootEntry> {
        @Override
        public void func_230422_a_(JsonObject jsonObject, TagLootEntry tagLootEntry, JsonSerializationContext jsonSerializationContext) {
            super.func_230422_a_(jsonObject, tagLootEntry, jsonSerializationContext);
            jsonObject.addProperty("name", TagCollectionManager.func_242178_a().func_241836_b().func_232975_b_(tagLootEntry.field_216180_c).toString());
            jsonObject.addProperty("expand", Boolean.valueOf(tagLootEntry.field_216181_h));
        }

        @Override
        protected TagLootEntry func_212829_b_(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, int n, int n2, ILootCondition[] iLootConditionArray, ILootFunction[] iLootFunctionArray) {
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "name"));
            ITag<Item> \u26032 = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(resourceLocation);
            if (\u26032 == null) {
                throw new JsonParseException("Can't find tag: " + resourceLocation);
            }
            boolean \u26033 = JSONUtils.func_151212_i(jsonObject, "expand");
            return new TagLootEntry(\u26032, \u26033, n, n2, iLootConditionArray, iLootFunctionArray);
        }

        @Override
        protected /* synthetic */ StandaloneLootEntry func_212829_b_(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, int n, int n2, ILootCondition[] iLootConditionArray, ILootFunction[] iLootFunctionArray) {
            return this.func_212829_b_(jsonObject, jsonDeserializationContext, n, n2, iLootConditionArray, iLootFunctionArray);
        }
    }
}

