/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.UUID;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetExpiringGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.ToggleableNearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class WitchEntity
extends AbstractRaiderEntity
implements IRangedAttackMob {
    private static final UUID field_110184_bp = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier field_110185_bq = new AttributeModifier(field_110184_bp, "Drinking speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
    private static final DataParameter<Boolean> field_184731_c = EntityDataManager.func_187226_a(WitchEntity.class, DataSerializers.field_187198_h);
    private int field_82200_e;
    private NearestAttackableTargetExpiringGoal<AbstractRaiderEntity> field_213694_bC;
    private ToggleableNearestAttackableTargetGoal<PlayerEntity> field_213695_bD;

    public WitchEntity(EntityType<? extends WitchEntity> entityType, World world) {
        super((EntityType<? extends AbstractRaiderEntity>)entityType, world);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_213694_bC = new NearestAttackableTargetExpiringGoal<AbstractRaiderEntity>(this, AbstractRaiderEntity.class, true, livingEntity -> livingEntity != null && this.func_213657_el() && livingEntity.func_200600_R() != EntityType.field_200759_ay);
        this.field_213695_bD = new ToggleableNearestAttackableTargetGoal<PlayerEntity>(this, PlayerEntity.class, 10, true, false, null);
        this.field_70714_bg.func_75776_a(1, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(2, new RangedAttackGoal(this, 1.0, 60, 10.0f));
        this.field_70714_bg.func_75776_a(2, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, new LookRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, AbstractRaiderEntity.class));
        this.field_70715_bh.func_75776_a(2, this.field_213694_bC);
        this.field_70715_bh.func_75776_a(3, this.field_213695_bD);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(field_184731_c, false);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187920_gt;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187923_gw;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187921_gu;
    }

    public void func_82197_f(boolean bl) {
        this.func_184212_Q().func_187227_b(field_184731_c, bl);
    }

    public boolean func_184730_o() {
        return this.func_184212_Q().func_187225_a(field_184731_c);
    }

    public static AttributeModifierMap.MutableAttribute func_234323_eI_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 26.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.field_213694_bC.func_220780_j();
            if (this.field_213694_bC.func_220781_h() <= 0) {
                this.field_213695_bD.func_220783_a(true);
            } else {
                this.field_213695_bD.func_220783_a(false);
            }
            if (this.func_184730_o()) {
                if (this.field_82200_e-- <= 0) {
                    this.func_82197_f(false);
                    ItemStack itemStack = this.func_184614_ca();
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                    if (itemStack.func_77973_b() == Items.field_151068_bn && (\u2603 = PotionUtils.func_185189_a(itemStack)) != null) {
                        for (EffectInstance effectInstance : \u2603) {
                            this.func_195064_c(new EffectInstance(effectInstance));
                        }
                    }
                    this.func_110148_a(Attributes.field_233821_d_).func_111124_b(field_110185_bq);
                }
            } else {
                Potion potion = null;
                if (this.field_70146_Z.nextFloat() < 0.15f && this.func_208600_a(FluidTags.field_206959_a) && !this.func_70644_a(Effects.field_76427_o)) {
                    potion = Potions.field_185248_t;
                } else if (this.field_70146_Z.nextFloat() < 0.15f && (this.func_70027_ad() || this.func_189748_bU() != null && this.func_189748_bU().func_76347_k()) && !this.func_70644_a(Effects.field_76426_n)) {
                    potion = Potions.field_185241_m;
                } else if (this.field_70146_Z.nextFloat() < 0.05f && this.func_110143_aJ() < this.func_110138_aP()) {
                    potion = Potions.field_185250_v;
                } else if (this.field_70146_Z.nextFloat() < 0.5f && this.func_70638_az() != null && !this.func_70644_a(Effects.field_76424_c) && this.func_70638_az().func_70068_e(this) > 121.0) {
                    potion = Potions.field_185243_o;
                }
                if (potion != null) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, PotionUtils.func_185188_a(new ItemStack(Items.field_151068_bn), potion));
                    this.field_82200_e = this.func_184614_ca().func_77988_m();
                    this.func_82197_f(true);
                    if (!this.func_174814_R()) {
                        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187922_gv, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    }
                    ModifiableAttributeInstance modifiableAttributeInstance = this.func_110148_a(Attributes.field_233821_d_);
                    modifiableAttributeInstance.func_111124_b(field_110185_bq);
                    modifiableAttributeInstance.func_233767_b_(field_110185_bq);
                }
            }
            if (this.field_70146_Z.nextFloat() < 7.5E-4f) {
                this.field_70170_p.func_72960_a(this, (byte)15);
            }
        }
        super.func_70636_d();
    }

    @Override
    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219725_nh;
    }

    @Override
    protected float func_70672_c(DamageSource damageSource, float f) {
        f = super.func_70672_c(damageSource, f);
        if (damageSource.func_76346_g() == this) {
            f = 0.0f;
        }
        if (damageSource.func_82725_o()) {
            f = (float)((double)f * 0.15);
        }
        return f;
    }

    @Override
    public void func_82196_d(LivingEntity livingEntity, float f) {
        if (this.func_184730_o()) {
            return;
        }
        Vector3d vector3d = livingEntity.func_213322_ci();
        double \u26032 = livingEntity.func_226277_ct_() + vector3d.field_72450_a - this.func_226277_ct_();
        double \u26033 = livingEntity.func_226280_cw_() - (double)1.1f - this.func_226278_cu_();
        double \u26034 = livingEntity.func_226281_cx_() + vector3d.field_72449_c - this.func_226281_cx_();
        float \u26035 = MathHelper.func_76133_a(\u26032 * \u26032 + \u26034 * \u26034);
        Potion \u26036 = Potions.field_185252_x;
        if (livingEntity instanceof AbstractRaiderEntity) {
            \u26036 = livingEntity.func_110143_aJ() <= 4.0f ? Potions.field_185250_v : Potions.field_185220_C;
            this.func_70624_b(null);
        } else if (\u26035 >= 8.0f && !livingEntity.func_70644_a(Effects.field_76421_d)) {
            \u26036 = Potions.field_185246_r;
        } else if (livingEntity.func_110143_aJ() >= 8.0f && !livingEntity.func_70644_a(Effects.field_76436_u)) {
            \u26036 = Potions.field_185254_z;
        } else if (\u26035 <= 3.0f && !livingEntity.func_70644_a(Effects.field_76437_t) && this.field_70146_Z.nextFloat() < 0.25f) {
            \u26036 = Potions.field_185226_I;
        }
        PotionEntity \u26037 = new PotionEntity(this.field_70170_p, this);
        \u26037.func_213884_b(PotionUtils.func_185188_a(new ItemStack(Items.field_185155_bH), \u26036));
        \u26037.field_70125_A -= -20.0f;
        \u26037.func_70186_c(\u26032, \u26033 + (double)(\u26035 * 0.2f), \u26034, 0.75f, 8.0f);
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        this.field_70170_p.func_217376_c(\u26037);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return 1.62f;
    }

    @Override
    public void func_213660_a(int n, boolean bl) {
    }

    @Override
    public boolean func_213637_dY() {
        return false;
    }
}

