/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public class PhantomEntity
extends FlyingEntity
implements IMob {
    private static final DataParameter<Integer> field_203035_a = EntityDataManager.func_187226_a(PhantomEntity.class, DataSerializers.field_187192_b);
    private Vector3d field_203036_b = Vector3d.field_186680_a;
    private BlockPos field_203037_c = BlockPos.field_177992_a;
    private AttackPhase field_203038_bx = AttackPhase.CIRCLE;

    public PhantomEntity(EntityType<? extends PhantomEntity> entityType, World world) {
        super((EntityType<? extends FlyingEntity>)entityType, world);
        this.field_70728_aV = 5;
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new LookHelperController(this);
    }

    @Override
    protected BodyController func_184650_s() {
        return new BodyHelperController(this);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new PickAttackGoal());
        this.field_70714_bg.func_75776_a(2, new SweepAttackGoal());
        this.field_70714_bg.func_75776_a(3, new OrbitPointGoal());
        this.field_70715_bh.func_75776_a(1, new AttackPlayerGoal());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_203035_a, 0);
    }

    public void func_203034_a(int n) {
        this.field_70180_af.func_187227_b(field_203035_a, MathHelper.func_76125_a(n, 0, 64));
    }

    private void func_203033_m() {
        this.func_213323_x_();
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(6 + this.func_203032_dq());
    }

    public int func_203032_dq() {
        return this.field_70180_af.func_187225_a(field_203035_a);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return entitySize.field_220316_b * 0.35f;
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_203035_a.equals(dataParameter)) {
            this.func_203033_m();
        }
        super.func_184206_a(dataParameter);
    }

    @Override
    protected boolean func_225511_J_() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            float f = MathHelper.func_76134_b((float)(this.func_145782_y() * 3 + this.field_70173_aa) * 0.13f + (float)Math.PI);
            \u2603 = MathHelper.func_76134_b((float)(this.func_145782_y() * 3 + this.field_70173_aa + 1) * 0.13f + (float)Math.PI);
            if (f > 0.0f && \u2603 <= 0.0f) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_206944_gn, this.func_184176_by(), 0.95f + this.field_70146_Z.nextFloat() * 0.05f, 0.95f + this.field_70146_Z.nextFloat() * 0.05f, false);
            }
            int \u26032 = this.func_203032_dq();
            \u2603 = MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180)) * (1.3f + 0.21f * (float)\u26032);
            \u2603 = MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180)) * (1.3f + 0.21f * (float)\u26032);
            \u2603 = (0.3f + f * 0.45f) * ((float)\u26032 * 0.2f + 1.0f);
            this.field_70170_p.func_195594_a(ParticleTypes.field_197596_G, this.func_226277_ct_() + (double)\u2603, this.func_226278_cu_() + (double)\u2603, this.func_226281_cx_() + (double)\u2603, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a(ParticleTypes.field_197596_G, this.func_226277_ct_() - (double)\u2603, this.func_226278_cu_() + (double)\u2603, this.func_226281_cx_() - (double)\u2603, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.func_70089_S() && this.func_204609_dp()) {
            this.func_70015_d(8);
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld iServerWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        this.field_203037_c = this.func_233580_cy_().func_177981_b(5);
        this.func_203034_a(0);
        return super.func_213386_a(iServerWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        if (compoundNBT.func_74764_b("AX")) {
            this.field_203037_c = new BlockPos(compoundNBT.func_74762_e("AX"), compoundNBT.func_74762_e("AY"), compoundNBT.func_74762_e("AZ"));
        }
        this.func_203034_a(compoundNBT.func_74762_e("Size"));
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("AX", this.field_203037_c.func_177958_n());
        compoundNBT.func_74768_a("AY", this.field_203037_c.func_177956_o());
        compoundNBT.func_74768_a("AZ", this.field_203037_c.func_177952_p());
        compoundNBT.func_74768_a("Size", this.func_203032_dq());
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203256_ft;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_203259_fw;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203258_fv;
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    @Override
    protected float func_70599_aP() {
        return 1.0f;
    }

    @Override
    public boolean func_213358_a(EntityType<?> entityType) {
        return true;
    }

    @Override
    public EntitySize func_213305_a(Pose pose) {
        int n = this.func_203032_dq();
        EntitySize \u26032 = super.func_213305_a(pose);
        float \u26033 = (\u26032.field_220315_a + 0.2f * (float)n) / \u26032.field_220315_a;
        return \u26032.func_220313_a(\u26033);
    }

    class AttackPlayerGoal
    extends Goal {
        private final EntityPredicate field_220842_b = new EntityPredicate().func_221013_a(64.0);
        private int field_203142_b = 20;

        private AttackPlayerGoal() {
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_203142_b > 0) {
                --this.field_203142_b;
                return false;
            }
            this.field_203142_b = 60;
            List<PlayerEntity> list = PhantomEntity.this.field_70170_p.func_217373_a(this.field_220842_b, PhantomEntity.this, PhantomEntity.this.func_174813_aQ().func_72314_b(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::func_226278_cu_).reversed());
                for (PlayerEntity playerEntity : list) {
                    if (!PhantomEntity.this.func_213344_a(playerEntity, EntityPredicate.field_221016_a)) continue;
                    PhantomEntity.this.func_70624_b(playerEntity);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean func_75253_b() {
            LivingEntity livingEntity = PhantomEntity.this.func_70638_az();
            if (livingEntity != null) {
                return PhantomEntity.this.func_213344_a(livingEntity, EntityPredicate.field_221016_a);
            }
            return false;
        }
    }

    class PickAttackGoal
    extends Goal {
        private int field_203145_b;

        private PickAttackGoal() {
        }

        @Override
        public boolean func_75250_a() {
            LivingEntity livingEntity = PhantomEntity.this.func_70638_az();
            if (livingEntity != null) {
                return PhantomEntity.this.func_213344_a(PhantomEntity.this.func_70638_az(), EntityPredicate.field_221016_a);
            }
            return false;
        }

        @Override
        public void func_75249_e() {
            this.field_203145_b = 10;
            PhantomEntity.this.field_203038_bx = AttackPhase.CIRCLE;
            this.func_203143_f();
        }

        @Override
        public void func_75251_c() {
            PhantomEntity.this.field_203037_c = PhantomEntity.this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, PhantomEntity.this.field_203037_c).func_177981_b(10 + PhantomEntity.this.field_70146_Z.nextInt(20));
        }

        @Override
        public void func_75246_d() {
            if (PhantomEntity.this.field_203038_bx == AttackPhase.CIRCLE) {
                --this.field_203145_b;
                if (this.field_203145_b <= 0) {
                    PhantomEntity.this.field_203038_bx = AttackPhase.SWOOP;
                    this.func_203143_f();
                    this.field_203145_b = (8 + PhantomEntity.this.field_70146_Z.nextInt(4)) * 20;
                    PhantomEntity.this.func_184185_a(SoundEvents.field_203260_fx, 10.0f, 0.95f + PhantomEntity.this.field_70146_Z.nextFloat() * 0.1f);
                }
            }
        }

        private void func_203143_f() {
            PhantomEntity.this.field_203037_c = PhantomEntity.this.func_70638_az().func_233580_cy_().func_177981_b(20 + PhantomEntity.this.field_70146_Z.nextInt(20));
            if (PhantomEntity.this.field_203037_c.func_177956_o() < PhantomEntity.this.field_70170_p.func_181545_F()) {
                PhantomEntity.this.field_203037_c = new BlockPos(PhantomEntity.this.field_203037_c.func_177958_n(), PhantomEntity.this.field_70170_p.func_181545_F() + 1, PhantomEntity.this.field_203037_c.func_177952_p());
            }
        }
    }

    class SweepAttackGoal
    extends MoveGoal {
        private SweepAttackGoal() {
        }

        @Override
        public boolean func_75250_a() {
            return PhantomEntity.this.func_70638_az() != null && PhantomEntity.this.field_203038_bx == AttackPhase.SWOOP;
        }

        @Override
        public boolean func_75253_b() {
            List<Entity> list;
            LivingEntity livingEntity = PhantomEntity.this.func_70638_az();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.func_70089_S()) {
                return false;
            }
            if (livingEntity instanceof PlayerEntity && (((PlayerEntity)livingEntity).func_175149_v() || ((PlayerEntity)livingEntity).func_184812_l_())) {
                return false;
            }
            if (!this.func_75250_a()) {
                return false;
            }
            if (PhantomEntity.this.field_70173_aa % 20 == 0 && !(list = PhantomEntity.this.field_70170_p.func_175647_a(CatEntity.class, PhantomEntity.this.func_174813_aQ().func_186662_g(16.0), EntityPredicates.field_94557_a)).isEmpty()) {
                for (CatEntity catEntity : list) {
                    catEntity.func_213420_ej();
                }
                return false;
            }
            return true;
        }

        @Override
        public void func_75249_e() {
        }

        @Override
        public void func_75251_c() {
            PhantomEntity.this.func_70624_b(null);
            PhantomEntity.this.field_203038_bx = AttackPhase.CIRCLE;
        }

        @Override
        public void func_75246_d() {
            LivingEntity livingEntity = PhantomEntity.this.func_70638_az();
            PhantomEntity.this.field_203036_b = new Vector3d(livingEntity.func_226277_ct_(), livingEntity.func_226283_e_(0.5), livingEntity.func_226281_cx_());
            if (PhantomEntity.this.func_174813_aQ().func_186662_g(0.2f).func_72326_a(livingEntity.func_174813_aQ())) {
                PhantomEntity.this.func_70652_k(livingEntity);
                PhantomEntity.this.field_203038_bx = AttackPhase.CIRCLE;
                if (!PhantomEntity.this.func_174814_R()) {
                    PhantomEntity.this.field_70170_p.func_217379_c(1039, PhantomEntity.this.func_233580_cy_(), 0);
                }
            } else if (PhantomEntity.this.field_70123_F || PhantomEntity.this.field_70737_aN > 0) {
                PhantomEntity.this.field_203038_bx = AttackPhase.CIRCLE;
            }
        }
    }

    class OrbitPointGoal
    extends MoveGoal {
        private float field_203150_c;
        private float field_203151_d;
        private float field_203152_e;
        private float field_203153_f;

        private OrbitPointGoal() {
        }

        @Override
        public boolean func_75250_a() {
            return PhantomEntity.this.func_70638_az() == null || PhantomEntity.this.field_203038_bx == AttackPhase.CIRCLE;
        }

        @Override
        public void func_75249_e() {
            this.field_203151_d = 5.0f + PhantomEntity.this.field_70146_Z.nextFloat() * 10.0f;
            this.field_203152_e = -4.0f + PhantomEntity.this.field_70146_Z.nextFloat() * 9.0f;
            this.field_203153_f = PhantomEntity.this.field_70146_Z.nextBoolean() ? 1.0f : -1.0f;
            this.func_203148_i();
        }

        @Override
        public void func_75246_d() {
            if (PhantomEntity.this.field_70146_Z.nextInt(350) == 0) {
                this.field_203152_e = -4.0f + PhantomEntity.this.field_70146_Z.nextFloat() * 9.0f;
            }
            if (PhantomEntity.this.field_70146_Z.nextInt(250) == 0) {
                this.field_203151_d += 1.0f;
                if (this.field_203151_d > 15.0f) {
                    this.field_203151_d = 5.0f;
                    this.field_203153_f = -this.field_203153_f;
                }
            }
            if (PhantomEntity.this.field_70146_Z.nextInt(450) == 0) {
                this.field_203150_c = PhantomEntity.this.field_70146_Z.nextFloat() * 2.0f * (float)Math.PI;
                this.func_203148_i();
            }
            if (this.func_203146_f()) {
                this.func_203148_i();
            }
            if (((PhantomEntity)PhantomEntity.this).field_203036_b.field_72448_b < PhantomEntity.this.func_226278_cu_() && !PhantomEntity.this.field_70170_p.func_175623_d(PhantomEntity.this.func_233580_cy_().func_177979_c(1))) {
                this.field_203152_e = Math.max(1.0f, this.field_203152_e);
                this.func_203148_i();
            }
            if (((PhantomEntity)PhantomEntity.this).field_203036_b.field_72448_b > PhantomEntity.this.func_226278_cu_() && !PhantomEntity.this.field_70170_p.func_175623_d(PhantomEntity.this.func_233580_cy_().func_177981_b(1))) {
                this.field_203152_e = Math.min(-1.0f, this.field_203152_e);
                this.func_203148_i();
            }
        }

        private void func_203148_i() {
            if (BlockPos.field_177992_a.equals(PhantomEntity.this.field_203037_c)) {
                PhantomEntity.this.field_203037_c = PhantomEntity.this.func_233580_cy_();
            }
            this.field_203150_c += this.field_203153_f * 15.0f * ((float)Math.PI / 180);
            PhantomEntity.this.field_203036_b = Vector3d.func_237491_b_(PhantomEntity.this.field_203037_c).func_72441_c(this.field_203151_d * MathHelper.func_76134_b(this.field_203150_c), -4.0f + this.field_203152_e, this.field_203151_d * MathHelper.func_76126_a(this.field_203150_c));
        }
    }

    abstract class MoveGoal
    extends Goal {
        public MoveGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean func_203146_f() {
            return PhantomEntity.this.field_203036_b.func_186679_c(PhantomEntity.this.func_226277_ct_(), PhantomEntity.this.func_226278_cu_(), PhantomEntity.this.func_226281_cx_()) < 4.0;
        }
    }

    class LookHelperController
    extends LookController {
        public LookHelperController(MobEntity mobEntity) {
            super(mobEntity);
        }

        @Override
        public void func_75649_a() {
        }
    }

    class BodyHelperController
    extends BodyController {
        public BodyHelperController(MobEntity mobEntity) {
            super(mobEntity);
        }

        @Override
        public void func_75664_a() {
            PhantomEntity.this.field_70759_as = PhantomEntity.this.field_70761_aq;
            PhantomEntity.this.field_70761_aq = PhantomEntity.this.field_70177_z;
        }
    }

    class MoveHelperController
    extends MovementController {
        private float field_203105_j;

        public MoveHelperController(MobEntity mobEntity) {
            super(mobEntity);
            this.field_203105_j = 0.1f;
        }

        @Override
        public void func_75641_c() {
            if (PhantomEntity.this.field_70123_F) {
                PhantomEntity.this.field_70177_z += 180.0f;
                this.field_203105_j = 0.1f;
            }
            float f = (float)(((PhantomEntity)PhantomEntity.this).field_203036_b.field_72450_a - PhantomEntity.this.func_226277_ct_());
            \u2603 = (float)(((PhantomEntity)PhantomEntity.this).field_203036_b.field_72448_b - PhantomEntity.this.func_226278_cu_());
            \u2603 = (float)(((PhantomEntity)PhantomEntity.this).field_203036_b.field_72449_c - PhantomEntity.this.func_226281_cx_());
            double \u26032 = MathHelper.func_76129_c(f * f + \u2603 * \u2603);
            double \u26033 = 1.0 - (double)MathHelper.func_76135_e(\u2603 * 0.7f) / \u26032;
            f = (float)((double)f * \u26033);
            \u2603 = (float)((double)\u2603 * \u26033);
            \u26032 = MathHelper.func_76129_c(f * f + \u2603 * \u2603);
            double \u26034 = MathHelper.func_76129_c(f * f + \u2603 * \u2603 + \u2603 * \u2603);
            \u2603 = PhantomEntity.this.field_70177_z;
            \u2603 = (float)MathHelper.func_181159_b(\u2603, f);
            \u2603 = MathHelper.func_76142_g(PhantomEntity.this.field_70177_z + 90.0f);
            \u2603 = MathHelper.func_76142_g(\u2603 * 57.295776f);
            PhantomEntity.this.field_70761_aq = PhantomEntity.this.field_70177_z = MathHelper.func_203303_c(\u2603, \u2603, 4.0f) - 90.0f;
            this.field_203105_j = MathHelper.func_203301_d(\u2603, PhantomEntity.this.field_70177_z) < 3.0f ? MathHelper.func_203300_b(this.field_203105_j, 1.8f, 0.005f * (1.8f / this.field_203105_j)) : MathHelper.func_203300_b(this.field_203105_j, 0.2f, 0.025f);
            PhantomEntity.this.field_70125_A = \u2603 = (float)(-(MathHelper.func_181159_b(-\u2603, \u26032) * 57.2957763671875));
            \u2603 = PhantomEntity.this.field_70177_z + 90.0f;
            double \u26035 = (double)(this.field_203105_j * MathHelper.func_76134_b(\u2603 * ((float)Math.PI / 180))) * Math.abs((double)f / \u26034);
            double \u26036 = (double)(this.field_203105_j * MathHelper.func_76126_a(\u2603 * ((float)Math.PI / 180))) * Math.abs((double)\u2603 / \u26034);
            double \u26037 = (double)(this.field_203105_j * MathHelper.func_76126_a(\u2603 * ((float)Math.PI / 180))) * Math.abs((double)\u2603 / \u26034);
            Vector3d \u26038 = PhantomEntity.this.func_213322_ci();
            PhantomEntity.this.func_213317_d(\u26038.func_178787_e(new Vector3d(\u26035, \u26037, \u26036).func_178788_d(\u26038).func_186678_a(0.2)));
        }
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }
}

